/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IniFile {
    private Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private Pattern _keyValue = Pattern.compile("([^$=]*)=(.*)");
    private String iniPath = null;
    private Map<String, Map<String, String>> _entries = new TreeMap<String, Map<String, String>>();
    private final String section_default = "startup";

    public IniFile(String path) throws IOException {
        this.iniPath = path;
        this.load(path);
    }

    public void load(String path) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(path));){
                String line;
                String section = null;
                String key = null;
                String value = null;
                while ((line = br.readLine()) != null) {
                    Matcher m = this._section.matcher(line);
                    if (m.matches()) {
                        section = m.group(1).trim();
                        continue;
                    }
                    if (section == null) continue;
                    m = this._keyValue.matcher(line);
                    Map<String, String> kv = this._entries.get(section);
                    if (m.matches()) {
                        key = m.group(1).trim();
                        value = m.group(2).trim();
                        if (kv == null) {
                            kv = new TreeMap<String, String>();
                            this._entries.put(section, kv);
                        }
                        kv.put(key, value);
                        continue;
                    }
                    if (kv == null || key == null) continue;
                    kv.remove(key);
                    value = String.valueOf(value) + "\n" + line.trim();
                    kv.put(key, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            Map<String, String> kv = this._entries.get("startup");
            if (kv == null) {
                kv = new TreeMap<String, String>();
                this._entries.put("startup", kv);
            }
            kv.put("chipErase", "0");
            kv.put("chipSeries", "NuMicro M4");
            kv.put("config0", "0xFFFFFFFF");
            kv.put("config1", "0xFFFFFFFF");
            kv.put("config2", "0xFFFFFFFF");
            kv.put("config3", "0xFFFFFFFF");
            kv.put("doContinue", "1");
            kv.put("enableSemihosting", "0");
            kv.put("imageOffset", "");
            kv.put("imageOffsetInFlash", "");
            kv.put("initOther", "");
            kv.put("initResetEnable", "1");
            kv.put("initResetType", "init");
            kv.put("loadExecutable", "0");
            kv.put("loadExecutableToFlash", "1");
            kv.put("loadSymbols", "1");
            kv.put("pcRegisterValue", "");
            kv.put("runOther", "");
            kv.put("runResetEnable", "1");
            kv.put("runResetType", "init");
            kv.put("setPCRegister", "0");
            kv.put("setStopAtMain", "1");
            kv.put("symbolsOffset", "");
            kv.put("targetChip", "M480AE");
            kv.put("writeConfig", "0");
        }
    }

    public void unload() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.iniPath));
        for (Map.Entry<String, Map<String, String>> pairs : this._entries.entrySet()) {
            Iterator<Map.Entry<String, String>> it1 = pairs.getValue().entrySet().iterator();
            bw.write("[" + pairs.getKey() + "]\n");
            while (it1.hasNext()) {
                Map.Entry<String, String> pairs1 = it1.next();
                bw.write(String.valueOf(pairs1.getKey()) + "=" + pairs1.getValue() + "\n");
            }
        }
        bw.close();
    }

    public String getString(String section, String key, String defaultvalue) {
        Map<String, String> kv = this._entries.get(section);
        String KeyValue = null;
        if (kv == null) {
            return defaultvalue;
        }
        KeyValue = kv.get(key);
        if (KeyValue == null) {
            return defaultvalue;
        }
        return KeyValue;
    }

    public int getInt(String section, String key, int defaultvalue) {
        Map<String, String> kv = this._entries.get(section);
        if (kv == null) {
            return defaultvalue;
        }
        return Integer.parseInt(kv.get(key));
    }

    public float getFloat(String section, String key, float defaultvalue) {
        Map<String, String> kv = this._entries.get(section);
        if (kv == null) {
            return defaultvalue;
        }
        return Float.parseFloat(kv.get(key));
    }

    public double getDouble(String section, String key, double defaultvalue) {
        Map<String, String> kv = this._entries.get(section);
        if (kv == null) {
            return defaultvalue;
        }
        return Double.parseDouble(kv.get(key));
    }

    public String putString(String section, String key, String value) {
        Map<String, String> kv = this._entries.get(section);
        if (kv == null) {
            kv = new TreeMap<String, String>();
            this._entries.put(section, kv);
        }
        return kv.put(key, value);
    }

    public void removeSetByKey(String section, String key) {
        Map<String, String> kv = this._entries.get(section);
        if (kv == null) {
            return;
        }
        kv.remove(key);
    }
}

