/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class WorkweekProgressBar
extends Canvas {
    private static final int DEFAULT_HEIGHT = 5;
    private int currentTickCount = 0;
    private int maxTickCount = 0;
    private int colorBarWidth = 0;
    private final Color completedColor;
    private final Composite parent;

    public WorkweekProgressBar(Composite parent) {
        super(parent, 0);
        this.parent = parent;
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WorkweekProgressBar.this.colorBarWidth = WorkweekProgressBar.this.scale(WorkweekProgressBar.this.currentTickCount);
                WorkweekProgressBar.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                WorkweekProgressBar.this.paint(e);
            }
        });
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.completedColor = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.completed");
    }

    public void setMaximum(int max) {
        this.maxTickCount = max;
    }

    public void reset() {
        this.currentTickCount = 0;
        this.maxTickCount = 0;
        this.colorBarWidth = 0;
        this.redraw();
    }

    public void reset(int ticksDone, int maximum) {
        this.currentTickCount = ticksDone;
        this.maxTickCount = maximum;
        this.colorBarWidth = this.scale(ticksDone);
        this.computeSize(-1, -1, true);
        this.redraw();
    }

    private void paintStep(int startX, int endX) {
        GC gc = new GC((Drawable)this);
        this.setStatusColor(gc);
        Rectangle rect = this.getClientArea();
        startX = Math.max(1, startX);
        gc.fillRectangle(startX, 1, endX - startX, rect.height - 2);
        gc.dispose();
    }

    private void setStatusColor(GC gc) {
        gc.setBackground(this.completedColor);
    }

    private int scale(int value) {
        if (this.maxTickCount > 0) {
            Rectangle r = this.parent.getClientArea();
            if (r.width != 0) {
                return Math.max(0, value * (r.width - 2) / this.maxTickCount);
            }
        }
        return value;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Display disp = this.getDisplay();
        Rectangle rect = this.getClientArea();
        gc.fillRectangle(rect);
        this.drawBevelRect(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor(18), disp.getSystemColor(20));
        this.setStatusColor(gc);
        this.colorBarWidth = Math.min(rect.width - 2, this.colorBarWidth);
        gc.fillRectangle(1, 1, this.colorBarWidth, rect.height - 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(this.parent.getSize().x, 5);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    public void setCount(int count) {
        ++this.currentTickCount;
        int x = this.colorBarWidth;
        this.colorBarWidth = this.scale(this.currentTickCount);
        if (this.currentTickCount == this.maxTickCount) {
            this.colorBarWidth = this.getClientArea().width - 1;
        }
        this.paintStep(x, this.colorBarWidth);
    }

    public void step(int failures) {
        ++this.currentTickCount;
        int x = this.colorBarWidth;
        this.colorBarWidth = this.scale(this.currentTickCount);
        if (this.currentTickCount == this.maxTickCount) {
            this.colorBarWidth = this.getClientArea().width - 1;
        }
        this.paintStep(x, this.colorBarWidth);
    }
}

