/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.TextConsole;

public class ConsoleSaveAction
extends Action {
    private TextConsole fConsole;

    public ConsoleSaveAction(TextConsole console) {
        this.setToolTipText(ConsoleMessages.ConsoleMessages_save_action_tooltip);
        this.setImageDescriptor(GdbUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.dsf.gdb.ui", (String)"icons/full/obj16/save_console.gif"));
        this.fConsole = console;
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        final String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        Runnable saveJob = new Runnable(){

            @Override
            public void run() {
                ConsoleSaveAction.this.saveContent(fileName);
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)saveJob);
    }

    protected void saveContent(String fileName) {
        try {
            boolean confirmed = true;
            File file = new File(fileName);
            if (file.exists()) {
                confirmed = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)ConsoleMessages.ConsoleMessages_save_confirm_overwrite_title, (String)ConsoleMessages.ConsoleMessages_save_confirm_overwrite_desc);
            }
            if (confirmed) {
                BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
                out.write(this.fConsole.getDocument().get());
                out.close();
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ConsoleMessages.ConsoleMessages_save_info_io_error_title, (String)ConsoleMessages.ConsoleMessages_save_info_io_error_desc);
        }
    }
}

