/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.views;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.ui.RemoteUIPlugin;
import org.eclipse.remote.internal.ui.views.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteRemoteConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            ArrayList<IRemoteConnection> connections = new ArrayList<IRemoteConnection>();
            for (Object obj : (IStructuredSelection)selection) {
                IRemoteConnection connection;
                IRemoteConnectionType connectionType;
                if (!(obj instanceof IRemoteConnection) || !(connectionType = (connection = (IRemoteConnection)obj).getConnectionType()).canRemove()) continue;
                connections.add(connection);
            }
            String message = Messages.DeleteRemoteConnectionHandler_ConfirmDeleteMessage;
            for (IRemoteConnection connection : connections) {
                message = String.valueOf(message) + " " + connection.getName();
            }
            message = String.valueOf(message) + "?";
            if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeleteRemoteConnectionHandler_DeleteConnectionTitle, (String)message)) {
                for (IRemoteConnection connection : connections) {
                    IRemoteConnectionType connectionType = connection.getConnectionType();
                    try {
                        connectionType.removeConnection(connection);
                    }
                    catch (RemoteConnectionException e) {
                        RemoteUIPlugin.log(e.getStatus());
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }
}

