/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.zu;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "esase-Moscow Standard Time",
               "MST",
               "esase-Moscow Summer Time",
               "MST",
               "esase-Moscow Time",
               "MT",
            };
        final String[] Omsk = new String[] {
               "esase-Omsk Standard Time",
               "OST",
               "esase-Omsk Summer Time",
               "OST",
               "esase-Omsk Time",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "esase-Hawaii Aleutian Standard Time",
               "HAST",
               "esase-Hawaii Aleutian Daylight Time",
               "HADT",
               "esase-Hawaii Aleutian Time",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "esase-Sakhalin Standard Time",
               "SST",
               "esase-Sakhalin Summer Time",
               "SST",
               "esase-Sakhalin Time",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "esase-Yakutsk Standard Time",
               "YST",
               "esase-Yakutsk Summer Time",
               "YST",
               "esase-Yakutsk Time",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "esase-East Kazakhstan Time",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "esase-Vladivostok Standard Time",
               "VST",
               "esase-Vladivostok Summer Time",
               "VST",
               "esase-Vladivostok Time",
               "VT",
            };
        final String[] Brasilia = new String[] {
               "esase-Brasilia Standard Time",
               "BST",
               "esase-Brasilia Summer Time",
               "BST",
               "esase-Brasilia Time",
               "BT",
            };
        final String[] Hovd = new String[] {
               "esase-Hovd Standard Time",
               "HST",
               "esase-Hovd Summer Time",
               "HST",
               "esase-Hovd Time",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "esase-Indonesia Western Time",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "esase-Amazon Standard Time",
               "AST",
               "esase-Amazon Daylight Time",
               "AST",
               "esase-Amazon Time",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "esase-Ulan Bator Standard Time",
               "UBST",
               "esase-Ulan Bator Summer Time",
               "UBST",
               "esase-Ulan Bator Time",
               "UBT",
            };
        final String[] Indonesia_Central = new String[] {
               "esase-Indonesia Central Time",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "esase-Pacific Standard Time",
               "PST",
               "esase-Pacific Daylight Time",
               "PDT",
               "esase-Pacific Time",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "esase-Western Argentina Standard Time",
               "WAST",
               "esase-Western Argentina Summer Time",
               "WAST",
               "esase-Western Argentina Time",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "esase-Newfoundland Standard Time",
               "NST",
               "esase-Newfoundland Daylight Time",
               "NDT",
               "esase-Newfoundland Time",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "esase-Volgograd Standard Time",
               "VST",
               "esase-Volgograd Summer Time",
               "VST",
               "esase-Volgograd Time",
               "VT",
            };
        final String[] America_Central = new String[] {
               "esase-Central Standard Time",
               "CST",
               "esase-Central Daylight Time",
               "CDT",
               "esase-Central Time",
               "CT",
            };
        final String[] Argentina = new String[] {
               "esase-Argentina Standard Time",
               "AST",
               "esase-Argentina Summer Time",
               "AST",
               "esase-Argentina Time",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "esase-Yekaterinburg Standard Time",
               "YST",
               "esase-Yekaterinburg Summer Time",
               "YST",
               "esase-Yekaterinburg Time",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "esase-Lord Howe Standard Time",
               "LHST",
               "esase-Lord Howe Daylight Time",
               "LHDT",
               "esase-Lord Howe Time",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "esase-Macquarie Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "esase-Australian Eastern Standard Time",
               "AEST",
               "esase-Australian Eastern Daylight Time",
               "AEDT",
               "esase-Austrilian Eastern Time",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "esase-Irkutsk Standard Time",
               "IST",
               "esase-Irkutsk Summer Time",
               "IST",
               "esase-Irkutsk Time",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "esase-Choibalsan Standard Time",
               "CST",
               "esase-Choibalsan Summer Time",
               "CST",
               "esase-Choibalsan Time",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "esase-Eastern Standard Time",
               "EST",
               "esase-Eastern Daylight Time",
               "EDT",
               "esase-Eastern Time",
               "ET",
            };
        final String[] Kazakhstan_Western = new String[] {
               "esase-West Kazakhstan Time",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "esase-Austrilian Central Western Standard Time",
               "ACWST",
               "esase-Austrilian Central Western Daylight Time",
               "ACWDT",
               "esase-Austrilian Central Western Time",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "esase-Austrilian Western Standard Time",
               "AWST",
               "esase-Austrilian Western Daylight Time",
               "AWDT",
               "esase-Western Australia Time",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "esase-Krasnoyarsk Standard Time",
               "KST",
               "esase-Krasnoyarsk Summer Time",
               "KST",
               "esase-Krasnoyarsk Time",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "esase-Indonesia Eastern Time",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "esase-Fernando de Noronha Standard Time",
               "FNST",
               "esase-Fernando de Noronha Summer Time",
               "FNST",
               "esase-Fernando de Noronha Time",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "esase-Novosibirsk Standard Time",
               "NST",
               "esase-Novosibirsk Summer Time",
               "NST",
               "esase-Novosibirsk Time",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "esase-Mountain Standard Time",
               "MST",
               "esase-Mountain Daylight Time",
               "MDT",
               "esase-Mountain Time",
               "MT",
            };
        final String[] Alaska = new String[] {
               "esase-Alaska Standard Time",
               "AKST",
               "esase-Alaska Daylight Time",
               "AKDT",
               "esase-Alaska Time",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "esase-Austrilian Central Standard Time",
               "ACST",
               "esase-Austrilian Central Daylight Time",
               "ACDT",
               "esase-Central Australia Time",
               "CAT",
            };
        final String[] Atlantic = new String[] {
               "esase-Atlantic Standard Time",
               "AST",
               "esase-Atlantic Daylight Time",
               "ADT",
               "esase-Atlantic Time",
               "AT",
            };
        final String[] Magadan = new String[] {
               "esase-Magadan Standard Time",
               "MST",
               "esase-Magadan Summer Time",
               "MST",
               "esase-Magadan Time",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Samara", Moscow },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Regina", America_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Vladivostok", Vladivostok },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "America/Cayman", America_Eastern },
            { "Asia/Omsk", Omsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Asia/Choibalsan", Choibalsan },
            { "America/Indiana/Winamac", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Nome", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "America/Vancouver", America_Pacific },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "America/Montreal", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "America/Cambridge_Bay", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "America/Jamaica", America_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "America/Jujuy", Argentina },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Swift_Current", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "America/Monterrey", America_Central },
        };
        return data;
    }
}
