/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HT_IO;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.LeafNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public class HistoryTree {
    public static final int TREE_HEADER_SIZE = 4096;
    private static final int HISTORY_FILE_MAGIC_NUMBER = 100641024;
    private static final int FILE_VERSION = 5;
    private final HTConfig config;
    private final HT_IO treeIO;
    private long treeEnd;
    private int nodeCount;
    private final List<HTNode> latestBranch;

    public HistoryTree(HTConfig conf) throws IOException {
        if (conf.getBlockSize() < 4096) {
            throw new IllegalArgumentException();
        }
        this.config = conf;
        this.treeEnd = conf.getTreeStart();
        this.nodeCount = 0;
        this.latestBranch = Collections.synchronizedList(new ArrayList());
        this.treeIO = new HT_IO(this.config, true);
        LeafNode firstNode = this.initNewLeafNode(-1, conf.getTreeStart());
        this.latestBranch.add(firstNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryTree(File existingStateFile, int expProviderVersion) throws IOException {
        long startTime;
        int rootNodeSeqNb;
        block18: {
            if (!existingStateFile.exists()) {
                throw new IOException("Selected state file does not exist");
            }
            if (existingStateFile.length() <= 0L) {
                throw new IOException("Empty target file");
            }
            Throwable throwable = null;
            Object var10_5 = null;
            try {
                FileInputStream fis = new FileInputStream(existingStateFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(4096);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        buffer.clear();
                        fc.read(buffer);
                        buffer.flip();
                        int res = buffer.getInt();
                        if (res != 100641024) {
                            throw new IOException("Wrong magic number");
                        }
                        res = buffer.getInt();
                        if (res != 5) {
                            throw new IOException("Mismatching History Tree file format versions");
                        }
                        res = buffer.getInt();
                        if (res != expProviderVersion && expProviderVersion != -42) {
                            throw new IOException("Mismatching event handler versions");
                        }
                        int bs = buffer.getInt();
                        int maxc = buffer.getInt();
                        this.nodeCount = buffer.getInt();
                        rootNodeSeqNb = buffer.getInt();
                        startTime = buffer.getLong();
                        this.config = new HTConfig(existingStateFile, bs, maxc, expProviderVersion, startTime);
                    }
                    if (fis == null) break block18;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.treeIO = new HT_IO(this.config, false);
        this.latestBranch = this.buildLatestBranch(rootNodeSeqNb);
        this.treeEnd = this.getRootNode().getNodeEnd();
        if (startTime == this.getRootNode().getNodeStart()) return;
        throw new IOException("Inconsistent start times in thehistory file, it might be corrupted.");
    }

    private List<HTNode> buildLatestBranch(int rootNodeSeqNb) throws ClosedChannelException {
        ArrayList<HTNode> list = new ArrayList<HTNode>();
        HTNode nextChildNode = this.treeIO.readNode(rootNodeSeqNb);
        list.add(nextChildNode);
        while (nextChildNode.getNodeType() == HTNode.NodeType.CORE) {
            nextChildNode = this.treeIO.readNode(((CoreNode)nextChildNode).getLatestChild());
            list.add(nextChildNode);
        }
        return Collections.synchronizedList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTree(long requestedEndTime) {
        List<HTNode> list = this.latestBranch;
        synchronized (list) {
            this.treeEnd = requestedEndTime;
            int i2 = 0;
            while (i2 < this.latestBranch.size()) {
                this.latestBranch.get(i2).closeThisNode(this.treeEnd);
                this.treeIO.writeNode(this.latestBranch.get(i2));
                ++i2;
            }
            try {
                Throwable i2 = null;
                Object var5_7 = null;
                try (FileChannel fc = this.treeIO.getFcOut();){
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.clear();
                    fc.position(0L);
                    buffer.putInt(100641024);
                    buffer.putInt(5);
                    buffer.putInt(this.config.getProviderVersion());
                    buffer.putInt(this.config.getBlockSize());
                    buffer.putInt(this.config.getMaxChildren());
                    buffer.putInt(this.nodeCount);
                    buffer.putInt(this.latestBranch.get(0).getSequenceNumber());
                    buffer.putLong(this.latestBranch.get(0).getNodeStart());
                    buffer.flip();
                    int res = fc.write(buffer);
                    assert (res <= 4096);
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    throw i2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("State system write error");
            }
        }
    }

    public long getTreeStart() {
        return this.config.getTreeStart();
    }

    public long getTreeEnd() {
        return this.treeEnd;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public HTNode getRootNode() {
        return this.latestBranch.get(0);
    }

    public FileInputStream supplyATReader() {
        return this.treeIO.supplyATReader(this.getNodeCount());
    }

    public File supplyATWriterFile() {
        return this.config.getStateFile();
    }

    public long supplyATWriterFilePos() {
        return 4096L + (long)this.getNodeCount() * (long)this.config.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTNode readNode(int seqNumber) throws ClosedChannelException {
        List<HTNode> list = this.latestBranch;
        synchronized (list) {
            for (HTNode node : this.latestBranch) {
                if (node.getSequenceNumber() != seqNumber) continue;
                return node;
            }
        }
        return this.treeIO.readNode(seqNumber);
    }

    public void writeNode(HTNode node) {
        this.treeIO.writeNode(node);
    }

    public void closeFile() {
        this.treeIO.closeFile();
    }

    public void deleteFile() {
        this.treeIO.deleteFile();
    }

    public void insertInterval(HTInterval interval) throws TimeRangeException {
        if (interval.getStartTime() < this.config.getTreeStart()) {
            throw new TimeRangeException("Interval Start:" + interval.getStartTime() + ", Config Start:" + this.config.getTreeStart());
        }
        this.tryInsertAtNode(interval, this.latestBranch.size() - 1);
    }

    private void tryInsertAtNode(HTInterval interval, int indexOfNode) {
        HTNode targetNode = this.latestBranch.get(indexOfNode);
        if (interval.getIntervalSize() > targetNode.getNodeFreeSpace()) {
            this.addSiblingNode(indexOfNode);
            this.tryInsertAtNode(interval, this.latestBranch.size() - 1);
            return;
        }
        if (interval.getStartTime() < targetNode.getNodeStart()) {
            assert (indexOfNode >= 1);
            this.tryInsertAtNode(interval, indexOfNode - 1);
            return;
        }
        targetNode.addInterval(interval);
        if (interval.getEndTime() > this.treeEnd) {
            this.treeEnd = interval.getEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSiblingNode(int indexOfNode) {
        List<HTNode> list = this.latestBranch;
        synchronized (list) {
            long splitTime = this.treeEnd;
            if (indexOfNode >= this.latestBranch.size()) {
                throw new IllegalStateException();
            }
            if (indexOfNode == 0) {
                this.addNewRootNode();
                return;
            }
            if (((CoreNode)this.latestBranch.get(indexOfNode - 1)).getNbChildren() == this.config.getMaxChildren()) {
                this.addSiblingNode(indexOfNode - 1);
                return;
            }
            int i = indexOfNode;
            while (i < this.latestBranch.size()) {
                HTNode newNode;
                this.latestBranch.get(i).closeThisNode(splitTime);
                this.treeIO.writeNode(this.latestBranch.get(i));
                CoreNode prevNode = (CoreNode)this.latestBranch.get(i - 1);
                switch (this.latestBranch.get(i).getNodeType()) {
                    case CORE: {
                        newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), splitTime + 1L);
                        break;
                    }
                    case LEAF: {
                        newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), splitTime + 1L);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                prevNode.linkNewChild(newNode);
                this.latestBranch.set(i, newNode);
                ++i;
            }
        }
    }

    private void addNewRootNode() {
        long splitTime = this.treeEnd;
        HTNode oldRootNode = this.latestBranch.get(0);
        CoreNode newRootNode = this.initNewCoreNode(-1, this.config.getTreeStart());
        oldRootNode.setParentSequenceNumber(newRootNode.getSequenceNumber());
        int i = 0;
        while (i < this.latestBranch.size()) {
            this.latestBranch.get(i).closeThisNode(splitTime);
            this.treeIO.writeNode(this.latestBranch.get(i));
            ++i;
        }
        newRootNode.linkNewChild(oldRootNode);
        int depth = this.latestBranch.size();
        this.latestBranch.clear();
        this.latestBranch.add(newRootNode);
        int i2 = 1;
        while (i2 < depth + 1) {
            CoreNode prevNode = (CoreNode)this.latestBranch.get(i2 - 1);
            CoreNode newNode = this.initNewCoreNode(prevNode.getParentSequenceNumber(), splitTime + 1L);
            prevNode.linkNewChild(newNode);
            this.latestBranch.add(newNode);
            ++i2;
        }
        CoreNode prevNode = (CoreNode)this.latestBranch.get(depth);
        LeafNode newNode = this.initNewLeafNode(prevNode.getParentSequenceNumber(), splitTime + 1L);
        prevNode.linkNewChild(newNode);
        this.latestBranch.add(newNode);
    }

    private CoreNode initNewCoreNode(int parentSeqNumber, long startTime) {
        CoreNode newNode = new CoreNode(this.config, this.nodeCount, parentSeqNumber, startTime);
        ++this.nodeCount;
        if (startTime >= this.treeEnd) {
            this.treeEnd = startTime + 1L;
        }
        return newNode;
    }

    private LeafNode initNewLeafNode(int parentSeqNumber, long startTime) {
        LeafNode newNode = new LeafNode(this.config, this.nodeCount, parentSeqNumber, startTime);
        ++this.nodeCount;
        if (startTime >= this.treeEnd) {
            this.treeEnd = startTime + 1L;
        }
        return newNode;
    }

    public HTNode selectNextChild(CoreNode currentNode, long t) throws ClosedChannelException {
        assert (currentNode.getNbChildren() > 0);
        int potentialNextSeqNb = currentNode.getSequenceNumber();
        int i = 0;
        while (i < currentNode.getNbChildren()) {
            if (t < currentNode.getChildStart(i)) break;
            potentialNextSeqNb = currentNode.getChild(i);
            ++i;
        }
        assert (potentialNextSeqNb != currentNode.getSequenceNumber());
        if (currentNode.isOnDisk()) {
            return this.treeIO.readNode(potentialNextSeqNb);
        }
        return this.readNode(potentialNextSeqNb);
    }

    public long getFileSize() {
        return this.config.getStateFile().length();
    }

    public boolean checkNodeIntegrity(HTNode zenode) {
        StringBuffer buf = new StringBuffer();
        boolean ret = true;
        if (!(zenode instanceof CoreNode)) {
            return true;
        }
        CoreNode node = (CoreNode)zenode;
        try {
            HTNode otherNode;
            if (node.getNbChildren() > 0) {
                otherNode = this.treeIO.readNode(node.getChild(0));
                if (node.getNodeStart() != otherNode.getNodeStart()) {
                    buf.append("Start time of node (" + node.getNodeStart() + ") " + "does not match start time of first child " + "(" + otherNode.getNodeStart() + "), " + "node #" + otherNode.getSequenceNumber() + ")\n");
                    ret = false;
                }
                if (node.isOnDisk()) {
                    otherNode = this.treeIO.readNode(node.getLatestChild());
                    if (node.getNodeEnd() != otherNode.getNodeEnd()) {
                        buf.append("End time of node (" + node.getNodeEnd() + ") does not match end time of last child (" + otherNode.getNodeEnd() + ", node #" + otherNode.getSequenceNumber() + ")\n");
                        ret = false;
                    }
                }
            }
            int i = 0;
            while (i < node.getNbChildren()) {
                otherNode = this.treeIO.readNode(node.getChild(i));
                if (otherNode.getNodeStart() != node.getChildStart(i)) {
                    buf.append("  Expected start time of child node #" + node.getChild(i) + ": " + node.getChildStart(i) + "\n" + "  Actual start time of node #" + otherNode.getSequenceNumber() + ": " + otherNode.getNodeStart() + "\n");
                    ret = false;
                }
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        if (!ret) {
            System.out.println("");
            System.out.println("SHT: Integrity check failed for node #" + node.getSequenceNumber() + ":");
            System.out.println(buf.toString());
        }
        return ret;
    }

    public void checkIntegrity() {
        try {
            int i = 0;
            while (i < this.nodeCount) {
                this.checkNodeIntegrity(this.treeIO.readNode(i));
                ++i;
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Information on the current tree:\n\nBlocksize: " + this.config.getBlockSize() + "\n" + "Max nb. of children per node: " + this.config.getMaxChildren() + "\n" + "Number of nodes: " + this.nodeCount + "\n" + "Depth of the tree: " + this.latestBranch.size() + "\n" + "Size of the treefile: " + this.getFileSize() + "\n" + "Root node has sequence number: " + this.latestBranch.get(0).getSequenceNumber() + "\n" + "'Latest leaf' has sequence number: " + this.latestBranch.get(this.latestBranch.size() - 1).getSequenceNumber();
    }

    private void preOrderPrint(PrintWriter writer, boolean printIntervals, HTNode currentNode, int curDepth) {
        writer.println(currentNode.toString());
        if (printIntervals) {
            currentNode.debugPrintIntervals(writer);
        }
        switch (currentNode.getNodeType()) {
            case LEAF: {
                return;
            }
            case CORE: {
                try {
                    CoreNode node = (CoreNode)currentNode;
                    int extension = node.getExtensionSequenceNumber();
                    while (extension != -1) {
                        HTNode nextNode = this.treeIO.readNode(extension);
                        this.preOrderPrint(writer, printIntervals, nextNode, curDepth);
                    }
                    int i = 0;
                    while (i < node.getNbChildren()) {
                        HTNode nextNode = this.treeIO.readNode(node.getChild(i));
                        int j = 0;
                        while (j < curDepth) {
                            writer.print("  ");
                            ++j;
                        }
                        writer.print("+-");
                        this.preOrderPrint(writer, printIntervals, nextNode, curDepth + 1);
                        ++i;
                    }
                }
                catch (ClosedChannelException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                break;
            }
        }
    }

    public void debugPrintFullTree(PrintWriter writer, boolean printIntervals) {
        this.preOrderPrint(writer, false, this.latestBranch.get(0), 0);
        if (printIntervals) {
            writer.println("\nDetails of intervals:");
            this.preOrderPrint(writer, true, this.latestBranch.get(0), 0);
        }
        writer.println('\n');
    }
}

