/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

final class MAC
extends Authenticator {
    static final MAC NULL = new MAC();
    private static final byte[] nullMAC = new byte[0];
    private final CipherSuite.MacAlg macAlg;
    private final Mac mac;

    private MAC() {
        this.macAlg = CipherSuite.M_NULL;
        this.mac = null;
    }

    MAC(CipherSuite.MacAlg macAlg, ProtocolVersion protocolVersion, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        super(protocolVersion);
        String algorithm;
        boolean tls;
        this.macAlg = macAlg;
        boolean bl = tls = protocolVersion.v >= ProtocolVersion.TLS10.v;
        if (macAlg == CipherSuite.M_MD5) {
            algorithm = tls ? "HmacMD5" : "SslMacMD5";
        } else if (macAlg == CipherSuite.M_SHA) {
            algorithm = tls ? "HmacSHA1" : "SslMacSHA1";
        } else if (macAlg == CipherSuite.M_SHA256) {
            algorithm = "HmacSHA256";
        } else if (macAlg == CipherSuite.M_SHA384) {
            algorithm = "HmacSHA384";
        } else {
            throw new RuntimeException("Unknown Mac " + macAlg);
        }
        this.mac = JsseJce.getMac(algorithm);
        this.mac.init(key);
    }

    int MAClen() {
        return this.macAlg.size;
    }

    int hashBlockLen() {
        return this.macAlg.hashBlockSize;
    }

    int minimalPaddingLen() {
        return this.macAlg.minimalPaddingSize;
    }

    final byte[] compute(byte type, byte[] buf, int offset, int len, boolean isSimulated) {
        if (this.macAlg.size == 0) {
            return nullMAC;
        }
        if (!isSimulated) {
            byte[] additional = this.acquireAuthenticationBytes(type, len);
            this.mac.update(additional);
        }
        this.mac.update(buf, offset, len);
        return this.mac.doFinal();
    }

    final byte[] compute(byte type, ByteBuffer bb, boolean isSimulated) {
        if (this.macAlg.size == 0) {
            return nullMAC;
        }
        if (!isSimulated) {
            byte[] additional = this.acquireAuthenticationBytes(type, bb.remaining());
            this.mac.update(additional);
        }
        this.mac.update(bb);
        return this.mac.doFinal();
    }
}

