/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Aggregator {
    public static File aggregate(String gprof2use, String binaryFile, List<String> gmons, File directory) {
        File ret;
        String[] cmd = new String[gmons.size() + 3];
        cmd[0] = gprof2use;
        cmd[1] = "-s";
        cmd[2] = binaryFile;
        int i = 3;
        for (String string : gmons) {
            cmd[i++] = string;
        }
        String errorMessage = null;
        try {
            Process p = ProcessFactory.getFactory().exec(cmd, null, directory);
            ProcessReader pr = new ProcessReader(p);
            pr.start();
            int ret2 = p.waitFor();
            if (ret2 != 0) {
                errorMessage = Messages.Aggregator_ERROR_COMMON_PREFIX;
                errorMessage = String.valueOf(errorMessage) + pr.errorMessage;
            }
        }
        catch (Exception _) {
            errorMessage = Messages.Aggregator_ERROR_COMMON_PREFIX;
            errorMessage = String.valueOf(errorMessage) + _.getMessage();
        }
        if (!(ret = new File(directory, "gmon.sum")).isFile() && errorMessage == null) {
            errorMessage = Messages.Aggregator_ERROR_COMMON_PREFIX;
            errorMessage = String.valueOf(errorMessage) + ret.getName();
            errorMessage = String.valueOf(errorMessage) + Messages.Aggregator_NOT_FOUND;
        }
        if (errorMessage != null) {
            final String finalErrorMessage = errorMessage;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.Aggregator_GPROF_ERROR, (String)finalErrorMessage);
                }
            });
            return null;
        }
        return ret;
    }

    static final class ProcessReader
    extends Thread {
        private final Process p;
        private String errorMessage = "";

        ProcessReader(Process p) {
            this.p = p;
        }

        @Override
        public void run() {
            try {
                String s;
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(this.p.getErrorStream()));
                while ((s = lnr.readLine()) != null) {
                    this.errorMessage = String.valueOf(this.errorMessage) + s + "\n";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

