/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.preferences;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.preferences.DirectoryNotStrictFieldEditor;
import ilg.gnuarmeclipse.core.preferences.LabelFakeFieldEditor;
import ilg.gnuarmeclipse.managedbuild.cross.Activator;
import ilg.gnuarmeclipse.managedbuild.cross.Option;
import ilg.gnuarmeclipse.managedbuild.cross.preferences.ToolchainsFieldEditor;
import ilg.gnuarmeclipse.managedbuild.cross.ui.DefaultPreferences;
import ilg.gnuarmeclipse.managedbuild.cross.ui.Messages;
import ilg.gnuarmeclipse.managedbuild.cross.ui.PersistentPreferences;
import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GlobalToolsPathsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ilg.gnuarmeclipse.managedbuild.cross.preferencePage.globalToolsPaths";

    public GlobalToolsPathsPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "ilg.gnuarmeclipse.managedbuild.cross"));
        this.setDescription(Messages.GlobalToolsPathsPropertyPage_description);
    }

    public void init(IWorkbench workbench) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GlobalToolsPathsPage.init()");
        }
    }

    protected void createFieldEditors() {
        boolean isStrict = DefaultPreferences.getBoolean("global.buildTools.path.strict", true);
        DirectoryNotStrictFieldEditor buildToolsPathField = new DirectoryNotStrictFieldEditor("buildTools.path", Messages.ToolsPaths_label, this.getFieldEditorParent(), isStrict);
        this.addField((FieldEditor)buildToolsPathField);
        ToolchainsFieldEditor toolchainNameField = new ToolchainsFieldEditor("toolchain.name", Messages.ToolchainName_label, this.getFieldEditorParent());
        this.addField((FieldEditor)toolchainNameField);
        HashSet<String> toolchainNames = new HashSet<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IConfiguration[] configs = EclipseUtils.getConfigurationsForProject((IProject)projects[i]);
            if (configs != null) {
                int j = 0;
                while (j < configs.length) {
                    IOption option;
                    IToolChain toolchain = configs[j].getToolChain();
                    if (toolchain != null && (option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME)) != null) {
                        try {
                            String name = option.getStringValue();
                            if (!name.isEmpty()) {
                                toolchainNames.add(name);
                            }
                        }
                        catch (BuildException buildException) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (toolchainNames.isEmpty()) {
            toolchainNames.add(PersistentPreferences.getToolchainName());
        }
        for (String toolchainName : toolchainNames) {
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchainName, Messages.ToolsPaths_ToolchainName_label, this.getFieldEditorParent());
            this.addField((FieldEditor)labelField);
            String key = PersistentPreferences.getToolchainKey(toolchainName);
            isStrict = DefaultPreferences.getBoolean("global.toolchain.path.strict", true);
            DirectoryNotStrictFieldEditor toolchainPathField = new DirectoryNotStrictFieldEditor(key, Messages.ToolchainPaths_label, this.getFieldEditorParent(), isStrict);
            this.addField((FieldEditor)toolchainPathField);
        }
    }
}

