/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.MultiResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSettingsPrefStore;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.MultiLineTextFieldEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class BuildToolSettingUI
extends AbstractToolSettingUI {
    private static final String ALL_OPTIONS = Messages.BuildToolSettingsPage_alloptions;
    private static final String DEFAULT_SEPERATOR = ";";
    private static final String WHITESPACE = " ";
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private StringFieldEditor commandStringField;
    private StringFieldEditor commandLinePatternField;
    private Vector<String> defaultOptionNames;
    private HashMap<String, String> stringOptionsMap;
    private ITool fTool;
    private HashMap<IOption, String> userObjsMap;

    public BuildToolSettingUI(AbstractCBuildPropertyTab page, IResourceInfo info, ITool _tool) {
        super(info);
        this.fTool = _tool;
        this.buildPropPage = page;
        this.stringOptionsMap = new HashMap();
        this.userObjsMap = new HashMap();
    }

    public Point computeSize() {
        return super.computeSize();
    }

    @Override
    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        FontMetrics fm = AbstractCPropertyTab.getFontMetrics((Control)parent);
        this.commandStringField = new StringFieldEditor(this.fTool.getId(), Messages.BuildToolSettingsPage_tool_command, parent);
        this.commandStringField.setEmptyStringAllowed(false);
        GridData gd = (GridData)this.commandStringField.getTextControl(parent).getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)3);
        this.addField((FieldEditor)this.commandStringField);
        Composite par = this.getFieldEditorParent();
        this.allOptionFieldEditor = new MultiLineTextFieldEditor(ToolSettingsPrefStore.ALL_OPTIONS_ID, ALL_OPTIONS, par);
        this.allOptionFieldEditor.getTextControl(par).setEditable(false);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)20);
        this.addField((FieldEditor)this.allOptionFieldEditor);
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), WHITESPACE));
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.BuildToolSettingsPage_tool_advancedSettings));
        parent = this.getFieldEditorParent();
        this.commandLinePatternField = new StringFieldEditor(String.valueOf(this.fTool.getId()) + "org.eclipse.commandLinePatternId", Messages.BuildToolSettingsPage_tool_commandLinePattern, parent);
        gd = (GridData)this.commandLinePatternField.getTextControl(parent).getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)30);
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)20);
        this.addField((FieldEditor)this.commandLinePatternField);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title) {
        return new LabelFieldEditor(parent, title);
    }

    private Vector<String> getDefaultOptionNames() {
        if (this.defaultOptionNames == null) {
            this.defaultOptionNames = new Vector();
            this.defaultOptionNames.add("Other flags");
            this.defaultOptionNames.add("Linker flags");
            this.defaultOptionNames.add("Archiver flags");
            this.defaultOptionNames.add("Assembler flags");
        }
        return this.defaultOptionNames;
    }

    private Vector<String> getOptionVector(String rawOptionString) {
        Vector<String> tokens = new Vector<String>(Arrays.asList(rawOptionString.split("\\s")));
        Vector<String> output = new Vector<String>(tokens.size());
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            int firstIndex = token.indexOf("\"");
            int lastIndex = token.lastIndexOf("\"");
            if (firstIndex != -1 && firstIndex == lastIndex) {
                while (iter.hasNext()) {
                    String nextToken = iter.next();
                    token = String.valueOf(token) + WHITESPACE + nextToken;
                    if (nextToken.indexOf("\"") != -1) break;
                }
            }
            output.add(token);
        }
        return output;
    }

    @Override
    public boolean isFor(Object tool, Object unused) {
        if (tool != null && tool instanceof ITool && unused == null) {
            return tool.equals(this.fTool);
        }
        return false;
    }

    public void parseAllOptions() {
        IOption opt;
        String alloptions = this.getToolSettingsPrefStore().getString(ToolSettingsPrefStore.ALL_OPTIONS_ID);
        ArrayList<String> optionsList = new ArrayList<String>();
        StringBuffer addnOptions = new StringBuffer();
        Vector<String> optionsArr = this.getOptionVector(alloptions);
        for (String optionValue : optionsArr) {
            IOption[] options;
            boolean optionValueExist = false;
            IOption[] iOptionArray = options = this.fTool.getOptions();
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                opt = iOptionArray[n2];
                for (String s : this.stringOptionsMap.values()) {
                    if (s.indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                for (String s : this.userObjsMap.values()) {
                    if (s.indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                if (!optionValueExist) {
                    try {
                        switch (opt.getValueType()) {
                            case 0: {
                                String boolCommand = opt.getCommand();
                                if (boolCommand != null && boolCommand.equals(optionValue)) {
                                    this.setOption(opt, true);
                                    optionValueExist = true;
                                }
                                if ((boolCommand = opt.getCommandFalse()) != null && boolCommand.equals(optionValue)) {
                                    this.setOption(opt, false);
                                    optionValueExist = true;
                                }
                                break;
                            }
                            case 1: {
                                String enumeration = "";
                                String[] enumValues = opt.getApplicableValues();
                                int i = 0;
                                while (i < enumValues.length) {
                                    if (opt.getEnumCommand(enumValues[i]).equals(optionValue)) {
                                        enumeration = enumValues[i];
                                        optionValueExist = true;
                                    }
                                    ++i;
                                }
                                if (!enumeration.equals("")) {
                                    this.setOption(opt, enumeration);
                                }
                                break;
                            }
                            case 12: {
                                String selectedID = "";
                                IOption.ITreeRoot treeRoot = opt.getTreeRoot();
                                String[] treeValues = opt.getApplicableValues();
                                int i = 0;
                                while (i < treeValues.length) {
                                    if (opt.getCommand(treeValues[i]).equals(optionValue)) {
                                        selectedID = treeValues[i];
                                        optionValueExist = true;
                                    }
                                    ++i;
                                }
                                if (!selectedID.equals("")) {
                                    this.setOption(opt, selectedID);
                                }
                                break;
                            }
                            case -11: 
                            case -10: 
                            case -9: 
                            case -8: 
                            case -5: 
                            case -4: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                if (opt.getCommand() != null && optionValue.startsWith(opt.getCommand())) {
                                    optionsList.add(optionValue);
                                    optionValueExist = true;
                                }
                                break;
                            }
                        }
                    }
                    catch (BuildException buildException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (optionValueExist) continue;
            addnOptions.append(String.valueOf(optionValue) + WHITESPACE);
        }
        Set<String> set = this.stringOptionsMap.keySet();
        int i = 0;
        while (i < set.size()) {
            for (String key : set) {
                String val = this.stringOptionsMap.get(key);
                if (alloptions.indexOf(val) != -1) continue;
                StringBuffer buf = new StringBuffer();
                String[] vals = val.split(WHITESPACE);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        buf.append(String.valueOf(vals[t]) + WHITESPACE);
                    }
                    ++t;
                }
                this.setOption((IOption)key, buf.toString().trim());
            }
            ++i;
        }
        Set<IOption> objSet = this.userObjsMap.keySet();
        int s = 0;
        while (s < objSet.size()) {
            for (IOption op : objSet) {
                String val = this.userObjsMap.get(op);
                ArrayList<String> list = new ArrayList<String>();
                String[] stringArray = BuildToolSettingUI.parseString(val);
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String v = stringArray[n3];
                    if (alloptions.indexOf(v) != -1) {
                        list.add(v);
                    }
                    ++n3;
                }
                String[] listArr = new String[list.size()];
                list.toArray(listArr);
                this.setOption(op, listArr);
            }
            ++s;
        }
        IOption[] options = this.fTool.getOptions();
        int k = 0;
        while (k < options.length) {
            opt = options[k];
            try {
                switch (opt.getValueType()) {
                    case 0: {
                        ArrayList<String> optsList = new ArrayList<String>(optionsArr);
                        if (opt.getCommand() != null && opt.getCommand().length() > 0 && !optsList.contains(opt.getCommand())) {
                            this.setOption(opt, false);
                        }
                        if (opt.getCommandFalse() != null && opt.getCommandFalse().length() > 0 && !optsList.contains(opt.getCommandFalse())) {
                            this.setOption(opt, true);
                        }
                        break;
                    }
                    case 2: {
                        if (this.getDefaultOptionNames().contains(opt.getName())) {
                            String newOptions = opt.getStringValue();
                            if (addnOptions.length() > 0) {
                                newOptions = String.valueOf(newOptions) + WHITESPACE + addnOptions.toString().trim();
                            }
                            this.setOption(opt, newOptions);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ArrayList<String> newList = new ArrayList<String>();
                        for (String s2 : optionsList) {
                            if (opt.getCommand() == null || !s2.startsWith(opt.getCommand())) continue;
                            newList.add(s2.substring(opt.getCommand().length()));
                        }
                        String[] strlist = new String[newList.size()];
                        newList.toArray(strlist);
                        newList.clear();
                        this.setOption(opt, strlist);
                        break;
                    }
                }
            }
            catch (BuildException buildException) {
                // empty catch block
            }
            ++k;
        }
    }

    public static String[] parseString(String stringList) {
        if (stringList == null || stringList.length() == 0) {
            return new String[0];
        }
        return stringList.split(DEFAULT_SEPERATOR);
    }

    protected void setOption(IOption option, boolean value) {
        try {
            this.fInfo.setOption((IHoldsOptions)this.fTool, option, value);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    protected void setOption(IOption option, String value) {
        try {
            this.fInfo.setOption((IHoldsOptions)this.fTool, option, value);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    protected void setOption(IOption option, String[] value) {
        try {
            this.fInfo.setOption((IHoldsOptions)this.fTool, option, value);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public boolean performOk() {
        return super.performOk();
    }

    @Override
    public void updateFields() {
        this.allOptionFieldEditor.load();
    }

    @Override
    public void setValues() {
        this.commandStringField.load();
        this.commandLinePatternField.load();
        this.updateFields();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.fInfo instanceof MultiResourceInfo) {
            MultiResourceInfo mri = (MultiResourceInfo)this.fInfo;
            if (event.getSource() == this.commandStringField) {
                mri.setToolsCommand(this.fTool, this.commandStringField.getStringValue());
                this.updateFields();
            } else if (event.getSource() == this.commandLinePatternField) {
                mri.setCommandLinePattern(this.fTool, this.commandLinePatternField.getStringValue());
            }
        } else if (event.getSource() == this.commandStringField) {
            this.fTool.setToolCommand(this.commandStringField.getStringValue());
            this.updateFields();
        } else if (event.getSource() == this.commandLinePatternField) {
            this.fTool.setCommandLinePattern(this.commandLinePatternField.getStringValue());
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private String fTitle;
        private Label fTitleLabel;

        public LabelFieldEditor(Composite parent, String title) {
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fTitleLabel.getLayoutData()).horizontalSpan = 2;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fTitleLabel = new Label(parent, 64);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = 2;
            this.fTitleLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

