/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.managedbuild.cross.Activator;
import ilg.gnuarmeclipse.managedbuild.cross.Option;
import ilg.gnuarmeclipse.managedbuild.cross.ui.PersistentPreferences;
import ilg.gnuarmeclipse.managedbuild.cross.ui.ProjectStorage;
import java.io.File;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public class EnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        if (path != null) {
            return new IBuildEnvironmentVariable[]{path};
        }
        return new IBuildEnvironmentVariable[0];
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private File path;

        private PathEnvironmentVariable(File path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            IToolChain toolchain = configuration.getToolChain();
            IProject project = (IProject)configuration.getManagedProject().getOwner();
            String path = PersistentPreferences.getBuildToolsPath(project);
            IOption option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME);
            String toolchainName = (String)option.getValue();
            String toolchainPath = null;
            boolean isPathPerProject = ProjectStorage.isToolchainPathPerProject(configuration);
            if (isPathPerProject) {
                toolchainPath = ProjectStorage.getToolchainPath(configuration);
                PersistentPreferences.putToolchainPath(toolchainName, toolchainPath, project);
                ProjectStorage.putToolchainPathPerProject(configuration, false);
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Path \"" + toolchainPath + "\" copied to project " + project.getName());
                }
            }
            toolchainPath = PersistentPreferences.getToolchainPath(toolchainName, project);
            if (path.isEmpty()) {
                path = toolchainPath;
            } else if (!toolchainPath.isEmpty()) {
                path = String.valueOf(path) + EclipseUtils.getPathSeparator();
                path = String.valueOf(path) + toolchainPath;
            }
            if (!path.isEmpty()) {
                File sysroot;
                File bin;
                if (path.indexOf("${") >= 0) {
                    path = PathEnvironmentVariable.resolveMacros(path, configuration);
                }
                if ((bin = new File(sysroot = new File(path), "bin")).isDirectory()) {
                    sysroot = bin;
                }
                return new PathEnvironmentVariable(sysroot);
            }
            return null;
        }

        private static String resolveMacros(String str, IConfiguration configuration) {
            String result = str;
            try {
                result = ManagedBuildManager.getBuildMacroProvider().resolveValue(str, "", " ", 3, (Object)configuration);
            }
            catch (CdtVariableException e) {
                Activator.log((String)("resolveMacros " + e.getMessage()));
            }
            return result;
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path.getAbsolutePath();
        }
    }
}

