/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.properties;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.ScopedPreferenceStoreWithoutDefaults;
import ilg.gnuarmeclipse.core.preferences.DirectoryNotStrictFieldEditor;
import ilg.gnuarmeclipse.core.preferences.LabelFakeFieldEditor;
import ilg.gnuarmeclipse.core.ui.FieldEditorPropertyPage;
import ilg.gnuarmeclipse.managedbuild.cross.Option;
import ilg.gnuarmeclipse.managedbuild.cross.ui.DefaultPreferences;
import ilg.gnuarmeclipse.managedbuild.cross.ui.Messages;
import ilg.gnuarmeclipse.managedbuild.cross.ui.PersistentPreferences;
import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectToolsPathPropertyPage
extends FieldEditorPropertyPage {
    public static final String ID = "ilg.gnuarmeclipse.managedbuild.cross.properties.toolsPage";

    public ProjectToolsPathPropertyPage() {
        super(1);
        this.setDescription(Messages.ProjectToolsPathsPropertyPage_description);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return new ScopedPreferenceStoreWithoutDefaults((IScopeContext)new ProjectScope((IProject)element), "ilg.gnuarmeclipse.managedbuild.cross");
        }
        return null;
    }

    protected void createFieldEditors() {
        IProject project;
        IConfiguration[] configs;
        boolean isStrict = DefaultPreferences.getBoolean("project.buildTools.path.strict", true);
        DirectoryNotStrictFieldEditor buildToolsPathField = new DirectoryNotStrictFieldEditor("buildTools.path", Messages.ToolsPaths_label, this.getFieldEditorParent(), isStrict);
        this.addField((FieldEditor)buildToolsPathField);
        HashSet<String> toolchainNames = new HashSet<String>();
        IAdaptable element = this.getElement();
        if (element instanceof IProject && (configs = EclipseUtils.getConfigurationsForProject((IProject)(project = (IProject)element))) != null) {
            int i = 0;
            while (i < configs.length) {
                IOption option;
                IToolChain toolchain = configs[i].getToolChain();
                if (toolchain != null && (option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME)) != null) {
                    try {
                        String name = option.getStringValue();
                        if (!name.isEmpty()) {
                            toolchainNames.add(name);
                        }
                    }
                    catch (BuildException buildException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if (toolchainNames.isEmpty()) {
            toolchainNames.add(PersistentPreferences.getToolchainName());
        }
        for (String toolchainName : toolchainNames) {
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchainName, Messages.ToolsPaths_ToolchainName_label, this.getFieldEditorParent());
            this.addField((FieldEditor)labelField);
            isStrict = DefaultPreferences.getBoolean("project.toolchain.path.strict", true);
            String key = PersistentPreferences.getToolchainKey(toolchainName);
            DirectoryNotStrictFieldEditor toolchainPathField = new DirectoryNotStrictFieldEditor(key, Messages.ToolchainPaths_label, this.getFieldEditorParent(), isStrict);
            this.addField((FieldEditor)toolchainPathField);
        }
    }
}

