/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.ui;

import ilg.gnuarmeclipse.managedbuild.cross.Activator;
import ilg.gnuarmeclipse.managedbuild.cross.ToolchainDefinition;
import ilg.gnuarmeclipse.managedbuild.cross.ui.DefaultPreferences;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

public class DefaultPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferenceInitializer.initializeDefaultPreferences()");
        }
        String toolchainName = "GNU Tools for ARM Embedded Processors";
        DefaultPreferences.putToolchainName(toolchainName);
        Preferences prefs = Platform.getPreferencesService().getRootNode().node("default");
        if (prefs instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)new LateInitializer());
        }
    }

    private class LateInitializer
    implements IEclipsePreferences.INodeChangeListener {
        private LateInitializer() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("LateInitializer.added() " + event + " " + event.getChild().name());
            }
            if ("ilg.gnuarmeclipse.managedbuild.cross".equals(event.getChild().name())) {
                this.finalizeInitializationsDefaultPreferences();
                ((IEclipsePreferences)event.getSource()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("LateInitializer.removed() " + event);
            }
        }

        public void finalizeInitializationsDefaultPreferences() {
            String value = DefaultPreferences.getBuildToolsPath();
            if (value.isEmpty() && !(value = DefaultPreferences.discoverBuildToolsPath()).isEmpty()) {
                DefaultPreferences.putBuildToolsPath(value);
            }
            for (ToolchainDefinition toolchain : ToolchainDefinition.getList()) {
                String toolchainName = toolchain.getName();
                String path = DefaultPreferences.getToolchainPath(toolchainName);
                if (!path.isEmpty()) continue;
                String searchPath = DefaultPreferences.getToolchainSearchPath(toolchainName);
                if (searchPath.isEmpty() && !(searchPath = DefaultPreferences.getToolchainSearchPathOs(toolchainName)).isEmpty()) {
                    DefaultPreferences.putToolchainSearchPath(toolchainName, searchPath);
                }
                if (searchPath.isEmpty() || (value = DefaultPreferences.discoverToolchainPath(toolchainName, searchPath)) == null || value.isEmpty()) continue;
                DefaultPreferences.putToolchainPath(toolchainName, value);
            }
        }
    }
}

