/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.managedbuild.cross.ui;

import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.preferences.Discoverer;
import ilg.gnuarmeclipse.managedbuild.cross.Activator;
import ilg.gnuarmeclipse.managedbuild.cross.ToolchainDefinition;
import ilg.gnuarmeclipse.managedbuild.cross.ui.PersistentPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class DefaultPreferences {
    private static final String REG_SUBKEY = "\\GNU ARM Eclipse\\Build Tools";
    private static final String REG_NAME = "InstallLocation";
    private static final String REG_NAME_DEPRECATED = "InstallFolder";
    private static final String EXECUTABLE_NAME = "make.exe";
    private static IEclipsePreferences fgPreferences;
    public static final String DEFAULT_NAME = "default.name";
    public static final String DEFAULT_PATH = "default.path";
    public static final String TOOLCHAIN = "toolchains.prefs";
    private static Properties fgToolchainProperties;

    private static IEclipsePreferences getPreferences() {
        if (fgPreferences == null) {
            fgPreferences = DefaultScope.INSTANCE.getNode("ilg.gnuarmeclipse.managedbuild.cross");
        }
        return fgPreferences;
    }

    public static String getString(String key, String defaulValue) {
        String value = DefaultPreferences.getPreferences().get(key, defaulValue);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return DefaultPreferences.getPreferences().getBoolean(key, defaultValue);
    }

    private static void putString(String key, String value) {
        DefaultPreferences.getPreferences().put(key, value);
    }

    public static String getToolchainName() {
        String key = "toolchain.name";
        String value = DefaultPreferences.getString(key, null);
        if (value == null) {
            try {
                Properties prop = DefaultPreferences.getToolchainProperties();
                value = prop.getProperty(DEFAULT_NAME, "").trim();
            }
            catch (IOException e) {
                value = "";
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("getToolchainName()=\"" + value + "\"");
        }
        return value;
    }

    public static void putToolchainName(String value) {
        String key = "toolchain.name";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Default " + key + "=" + value);
        }
        DefaultPreferences.putString(key, value);
    }

    public static String getToolchainPath(String toolchainName) {
        String key = PersistentPreferences.getToolchainKey(toolchainName);
        String value = DefaultPreferences.getString(key, null);
        if (value == null) {
            try {
                Properties prop = DefaultPreferences.getToolchainProperties();
                int hash = Math.abs(toolchainName.trim().hashCode());
                value = prop.getProperty("default.path." + String.valueOf(hash), "").trim();
            }
            catch (IOException e) {
                value = "";
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("getToolchainPath()=\"" + value + "\" (" + key + ")");
        }
        return value;
    }

    public static void putToolchainPath(String toolchainName, String value) {
        String key = PersistentPreferences.getToolchainKey(toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Default " + key + "=" + value);
        }
        DefaultPreferences.putString(key, value);
    }

    public static String getToolchainSearchPath(String toolchainName) {
        String key = PersistentPreferences.getToolchainSearchKey(toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Check " + key + " for \"" + toolchainName + "\"");
        }
        String value = DefaultPreferences.getString(PersistentPreferences.getToolchainSearchKey(toolchainName), "");
        return value;
    }

    public static void putToolchainSearchPath(String toolchainName, String value) {
        String key = PersistentPreferences.getToolchainSearchKey(toolchainName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Default " + key + "=" + value);
        }
        DefaultPreferences.putString(key, value);
    }

    public static String getToolchainSearchPathOs(String toolchainName) {
        String value = DefaultPreferences.getString(PersistentPreferences.getToolchainSearchOsKey(toolchainName), "");
        return value;
    }

    public static String getBuildToolsPath() {
        return DefaultPreferences.getString("buildTools.path", "");
    }

    public static void putBuildToolsPath(String value) {
        String key = "buildTools.path";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Default " + key + "=" + value);
        }
        DefaultPreferences.putString(key, value);
    }

    public static String discoverBuildToolsPath() {
        String value = null;
        if (EclipseUtils.isWindows()) {
            value = Discoverer.getRegistryInstallFolder((String)EXECUTABLE_NAME, (String)"bin", (String)REG_SUBKEY, (String)REG_NAME);
            if (value == null) {
                value = Discoverer.getRegistryInstallFolder((String)EXECUTABLE_NAME, (String)"bin", (String)REG_SUBKEY, (String)REG_NAME_DEPRECATED);
            }
        } else {
            EclipseUtils.isMacOSX();
        }
        if (value != null) {
            File file = new File(value = value.trim());
            if (!file.isDirectory()) {
                value = "";
            }
        } else {
            value = "";
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferences.discoverBuildToolsPath()=\"" + value + "\"");
        }
        return value;
    }

    private static String getLastToolchain(String folder, final String executableName) {
        File local = new File(folder);
        if (!local.isDirectory()) {
            return null;
        }
        File[] files = local.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                IPath path = new Path(dir.getAbsolutePath()).append(name).append("bin").append(executableName);
                return path.toFile().isFile();
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        IPath latestPath = null;
        long latestDate = 0L;
        int i = 0;
        while (i < files.length) {
            IPath path = new Path(files[i].getAbsolutePath()).append("bin").append(executableName);
            long date = path.toFile().lastModified();
            if (date > latestDate) {
                latestPath = new Path(files[i].getAbsolutePath()).append("bin");
                latestDate = date;
            }
            ++i;
        }
        return latestPath.toString();
    }

    public static String discoverToolchainPath(String toolchainName, String searchPath) {
        int ix;
        if (searchPath == null || searchPath.isEmpty()) {
            return null;
        }
        String resolvedPath = searchPath;
        if (resolvedPath.indexOf("${user.home}") >= 0) {
            resolvedPath = resolvedPath.replaceAll("\\$\\{user.home\\}", System.getProperty("user.home"));
        }
        if (resolvedPath.indexOf("${") >= 0) {
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                resolvedPath = variableManager.performStringSubstitution(resolvedPath, false);
            }
            catch (CoreException e) {
                resolvedPath = null;
            }
        }
        if (resolvedPath == null || resolvedPath.isEmpty()) {
            return null;
        }
        String[] paths = resolvedPath.split(EclipseUtils.getPathSeparator());
        if (paths.length == 0) {
            return null;
        }
        try {
            ix = ToolchainDefinition.findToolchainByName(toolchainName);
        }
        catch (IndexOutOfBoundsException e) {
            ix = ToolchainDefinition.getDefault();
        }
        String executableName = ToolchainDefinition.getToolchain(ix).getFullCmdC();
        if (EclipseUtils.isWindows() && !executableName.endsWith(".exe")) {
            executableName = String.valueOf(executableName) + ".exe";
        }
        int i = 0;
        while (i < paths.length) {
            String value = DefaultPreferences.getLastToolchain(paths[i], executableName);
            if (value != null && !value.isEmpty()) {
                return value;
            }
            ++i;
        }
        return null;
    }

    private static Properties getToolchainProperties() throws IOException {
        if (fgToolchainProperties == null) {
            URL url = Platform.getInstallLocation().getURL();
            Path path = new Path(url.getPath());
            File file = path.append("configuration").append("ilg.gnuarmeclipse.managedbuild.cross").append(TOOLCHAIN).toFile();
            FileInputStream is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            fgToolchainProperties = prop;
        }
        return fgToolchainProperties;
    }
}

