/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.jobs;

import ilg.gnuarmeclipse.core.Activator;
import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.packs.core.ConsoleStream;
import ilg.gnuarmeclipse.packs.core.Utils;
import ilg.gnuarmeclipse.packs.core.data.PacksStorage;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import ilg.gnuarmeclipse.packs.data.DataManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.console.MessageConsoleStream;

public class InstallJob
extends Job {
    private static boolean fgRunning = false;
    private MessageConsoleStream fOut = ConsoleStream.getConsoleOut();
    private TreeSelection fSelection;
    private IProgressMonitor fMonitor;
    private DataManager fDataManager;

    public InstallJob(String name, TreeSelection selection) {
        super(name);
        this.fSelection = selection;
        this.fDataManager = DataManager.getInstance();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        if (fgRunning) {
            return Status.CANCEL_STATUS;
        }
        fgRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(Utils.getCurrentDateTime());
        this.fOut.println("Installing packs...");
        ArrayList<Node> packsToInstall = new ArrayList<Node>();
        Object[] objectArray = this.fSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Node node = (Node)obj;
            if (!node.isBooleanProperty("installed")) {
                String type = node.getType();
                if ("package".equals(type)) {
                    packsToInstall.add((Node)node.getFirstChild());
                } else if ("version".equals(type)) {
                    packsToInstall.add(node);
                }
            }
            ++n2;
        }
        int workUnits = 0;
        int i = 0;
        while (i < packsToInstall.size()) {
            workUnits += this.computeWorkUnits((Node)packsToInstall.get(i));
            ++i;
        }
        monitor.beginTask("Install packs", ++workUnits);
        LinkedList<Node> installedPacksList = new LinkedList<Node>();
        for (Node versionNode : packsToInstall) {
            if (monitor.isCanceled()) break;
            String packFullName = versionNode.getProperty("archive.name");
            monitor.subTask(packFullName);
            this.fOut.println("Install \"" + packFullName + "\".");
            try {
                if (!this.installPack(versionNode)) continue;
                installedPacksList.add(versionNode);
                versionNode.setBooleanProperty("installed", true);
            }
            catch (IOException e) {
                this.fOut.println(ilg.gnuarmeclipse.packs.data.Utils.reportError((String)e.toString()));
            }
        }
        if (installedPacksList.size() > 0) {
            this.fDataManager.notifyUpdateView("update.versions", installedPacksList);
            this.fDataManager.notifyInstallRemove();
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            int n3;
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            if ((n3 = installedPacksList.size()) == 0) {
                this.fOut.print("No packs");
            } else if (n3 == 1) {
                this.fOut.print("1 pack");
            } else {
                this.fOut.print(String.valueOf(installedPacksList.size()) + " packs");
            }
            this.fOut.println(" installed.");
            this.fOut.print("Install completed in ");
            if (duration < 1500L) {
                this.fOut.println(String.valueOf(duration) + "ms.");
            } else {
                this.fOut.println(String.valueOf((duration + 500L) / 1000L) + "s.");
            }
            status = Status.OK_STATUS;
        }
        fgRunning = false;
        return status;
    }

    private int computeWorkUnits(Node versionNode) {
        int workUnits = 0;
        String size = versionNode.getProperty("archive.size", "0");
        try {
            workUnits += Integer.valueOf(size).intValue();
        }
        catch (NumberFormatException e) {
            Activator.log((Throwable)e);
        }
        Node packNode = versionNode.getParent();
        String pdscUrl = packNode.getProperty("archive.url");
        if (pdscUrl.length() > 0) {
            try {
                int sz = ilg.gnuarmeclipse.packs.data.Utils.getRemoteFileSize((URL)new URL(pdscUrl));
                if (sz > 0) {
                    workUnits += sz;
                }
            }
            catch (IOException e) {
                Activator.log((Throwable)e);
            }
        }
        return workUnits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean installPack(Node versionNode) throws IOException {
        URL packUrl = new URL(versionNode.getProperty("archive.url"));
        String archiveName = versionNode.getProperty("archive.name");
        File archiveFile = PacksStorage.getCachedFileObject((String)archiveName);
        if (archiveFile == null || !archiveFile.exists()) {
            File archiveFileDownload = PacksStorage.getCachedFileObject((String)(String.valueOf(archiveName) + ".download"));
            if (!this.copyFile(packUrl, archiveFileDownload)) return false;
            archiveFileDownload.renameTo(archiveFile);
            ilg.gnuarmeclipse.packs.data.Utils.reportInfo((String)("Pack " + archiveName + " downloaded."));
        } else {
            this.fMonitor.worked((int)archiveFile.length());
        }
        String dest = versionNode.getProperty("dest.folder");
        Path destRelPath = new Path(dest);
        File destFolder = PacksStorage.getFileObject((String)dest);
        if (destFolder.exists()) {
            this.fOut.println("Remove existing \"" + destRelPath + "\".");
            ilg.gnuarmeclipse.packs.data.Utils.deleteFolderRecursive((File)destFolder);
        }
        boolean flag = false;
        try {
            flag = this.unzip(archiveFile, (IPath)destRelPath);
        }
        catch (IOException e) {
            String msg = String.valueOf(e.getMessage()) + ", file: " + archiveFile.getName();
            this.fOut.println("Error: " + msg);
            ilg.gnuarmeclipse.packs.data.Utils.reportError((String)msg);
        }
        if (!flag) {
            this.fOut.println("Install cancelled due to errors.");
            ilg.gnuarmeclipse.packs.data.Utils.deleteFolderRecursive((File)destFolder);
            archiveFile.delete();
            return false;
        }
        ilg.gnuarmeclipse.packs.data.Utils.makeFolderReadOnlyRecursive((File)destRelPath.toFile());
        ilg.gnuarmeclipse.packs.data.Utils.reportInfo((String)("Pack " + archiveName + " installed."));
        this.fOut.println("All files write protected.");
        return true;
    }

    private boolean copyFile(URL sourceUrl, File destinationFile) throws IOException {
        ilg.gnuarmeclipse.packs.data.Utils.copyFile((URL)sourceUrl, (File)destinationFile, (MessageConsoleStream)this.fOut, (IProgressMonitor)this.fMonitor);
        return true;
    }

    private boolean unzip(File archiveFile, IPath destRelativePath) throws IOException {
        this.fOut.println("Unzip \"" + archiveFile + "\".");
        boolean result = true;
        ZipInputStream zipInput = new ZipInputStream(new FileInputStream(archiveFile));
        ZipEntry zipEntry = zipInput.getNextEntry();
        int countFiles = 0;
        int countBytes = 0;
        while (zipEntry != null && result) {
            if (!zipEntry.isDirectory()) {
                String msg;
                int bytesRead;
                String fileName = zipEntry.getName();
                IPath path = destRelativePath.append(fileName);
                File outFile = PacksStorage.getFileObject((String)path.toString());
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                this.fOut.println("Write \"" + outFile + "\".");
                FileOutputStream output = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((bytesRead = zipInput.read(buf)) > 0) {
                    try {
                        ((OutputStream)output).write(buf, 0, bytesRead);
                    }
                    catch (IOException e) {
                        msg = String.valueOf(e.getMessage()) + ", file: " + outFile.getName();
                        this.fOut.println("Error: " + msg);
                        ilg.gnuarmeclipse.packs.data.Utils.reportError((String)msg);
                        result = false;
                        break;
                    }
                    countBytes += bytesRead;
                }
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    msg = String.valueOf(e.getMessage()) + ", file: " + outFile.getName();
                    this.fOut.println("Error: " + msg);
                    ilg.gnuarmeclipse.packs.data.Utils.reportError((String)msg);
                    result = false;
                }
                outFile.setReadOnly();
                ++countFiles;
            }
            zipEntry = zipInput.getNextEntry();
        }
        this.fMonitor.worked(1);
        zipInput.closeEntry();
        zipInput.close();
        if (countBytes > 0) {
            this.fOut.println(String.valueOf(countFiles) + " files written, " + StringUtils.convertSizeToString((int)countBytes) + ".");
        } else {
            this.fOut.println("No files written.");
            result = false;
        }
        return result;
    }
}

