/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.News;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.operations.AbstractProvisioningOperation;
import org.eclipse.epp.internal.mpc.ui.operations.ProfileChangeOperationComputer;
import org.eclipse.epp.internal.mpc.ui.wizards.FeatureSelectionWizardPage;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.InstallProfile;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceBrowserIntegration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.ProvisioningJobListener;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModelStateSerializer;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.ui.AcceptLicensesWizardPage;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceWizard
extends DiscoveryWizard
implements InstallProfile,
IMarketplaceWebBrowser {
    private static final String PREF_DEFAULT_CATALOG = CatalogDescriptor.class.getSimpleName();
    private static final String DEBUG_NEWS_FLAG = "org.eclipse.epp.mpc.ui/news/debug";
    private static final String DEBUG_NEWS_TITLE = "org.eclipse.epp.mpc.ui/news/title";
    private static final String DEBUG_NEWS_URL = "org.eclipse.epp.mpc.ui/news/url";
    private Set<String> installedFeatures;
    private SelectionModel selectionModel;
    private MarketplaceBrowserIntegration browserListener;
    private ProfileChangeOperation profileChangeOperation;
    private FeatureSelectionWizardPage featureSelectionWizardPage;
    private AcceptLicensesWizardPage acceptLicensesPage;
    private IInstallableUnit[] operationIUs;
    private Set<CatalogItem> operationNewInstallItems;
    private boolean initialSelectionInitialized;
    private Set<URI> addedRepositoryLocations;
    private boolean withRemediation;
    private String errorMessage;
    private WizardState initialState;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MarketplaceWizard(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration) {
        super((Catalog)catalog, (CatalogConfiguration)configuration);
        this.setWindowTitle(Messages.MarketplaceWizard_eclipseSolutionCatalogs);
        this.createSelectionModel();
        this.withRemediation = true;
        String withRemediationOverride = System.getProperty("marketplace.remediation.enabled");
        if (withRemediationOverride != null) {
            this.withRemediation = Boolean.parseBoolean(withRemediationOverride);
        }
    }

    private void createSelectionModel() {
        this.selectionModel = new SelectionModel(this){

            public void selectionChanged() {
                super.selectionChanged();
                MarketplaceWizard.this.profileChangeOperation = null;
            }
        };
    }

    public MarketplaceCatalogConfiguration getConfiguration() {
        return (MarketplaceCatalogConfiguration)super.getConfiguration();
    }

    public MarketplaceCatalog getCatalog() {
        return (MarketplaceCatalog)super.getCatalog();
    }

    protected MarketplacePage doCreateCatalogPage() {
        return new MarketplacePage(this.getCatalog(), this.getConfiguration());
    }

    public ProfileChangeOperation getProfileChangeOperation() {
        return this.profileChangeOperation;
    }

    public void setProfileChangeOperation(ProfileChangeOperation profileChangeOperation) {
        this.profileChangeOperation = profileChangeOperation;
    }

    void initializeInitialSelection() throws CoreException {
        if (!this.wantInitializeInitialSelection()) {
            throw new IllegalStateException();
        }
        this.initialSelectionInitialized = true;
        this.initializeCatalog();
        if (this.getConfiguration().getInitialState() != null || this.getConfiguration().getInitialOperations() != null) {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        new SelectionModelStateSerializer(MarketplaceWizard.this.getCatalog(), MarketplaceWizard.this.getSelectionModel()).deserialize(MarketplaceWizard.this.getConfiguration().getInitialState(), MarketplaceWizard.this.getConfiguration().getInitialOperations(), monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new CoreException(MarketplaceClientCore.computeStatus((Exception)e, (String)Messages.MarketplaceViewer_unexpectedException));
            }
            catch (InterruptedException interruptedException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            ArrayList<Map.Entry<CatalogItem, Operation>> itemToSelectedOperation = new ArrayList<Map.Entry<CatalogItem, Operation>>(this.getSelectionModel().getItemToSelectedOperation().entrySet());
            ArrayList<CatalogItem> noninstallableItems = new ArrayList<CatalogItem>();
            for (Map.Entry entry : itemToSelectedOperation) {
                boolean unavailableInstall;
                if (entry.getValue() == Operation.NONE) continue;
                boolean bl = unavailableInstall = !(!Boolean.FALSE.equals(((CatalogItem)entry.getKey()).getAvailable()) && ((CatalogItem)entry.getKey()).getSiteUrl() != null || entry.getValue() != Operation.INSTALL && entry.getValue() != Operation.UPDATE);
                if (unavailableInstall) {
                    this.getSelectionModel().select((CatalogItem)entry.getKey(), Operation.NONE);
                    noninstallableItems.add((CatalogItem)entry.getKey());
                    continue;
                }
                ((CatalogItem)entry.getKey()).setSelected(true);
            }
            if (!noninstallableItems.isEmpty()) {
                this.notifyNonInstallableItems(noninstallableItems);
            }
        }
    }

    protected void notifyNonInstallableItems(final List<CatalogItem> noninstallableItems) {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.MarketplaceWizard_UnableToInstallSolutions, null, Messages.MarketplaceWizard_IncompatibleSolutionsMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createCustomArea(Composite parent) {
                parent.setLayout((Layout)new GridLayout());
                TableViewer tableViewer = new TableViewer(parent, 2820);
                tableViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
                tableViewer.setContentProvider((IContentProvider)this.createContentProvider());
                tableViewer.setInput((Object)noninstallableItems);
                Control tableControl = tableViewer.getControl();
                GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(-1, Math.max(40, Math.min(120, tableControl.computeSize((int)-1, (int)-1).y))).applyTo(tableControl);
                return tableControl;
            }

            private LabelProvider createLabelProvider() {
                return new LabelProvider(){

                    public String getText(Object element) {
                        return ((CatalogItem)element).getName();
                    }

                    public Image getImage(Object element) {
                        return MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("IU_ICON_ERROR");
                    }
                };
            }

            private IStructuredContentProvider createContentProvider() {
                return new IStructuredContentProvider(){

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }

                    public void dispose() {
                    }

                    public Object[] getElements(Object inputElement) {
                        return ((List)inputElement).toArray();
                    }
                };
            }
        };
        dialog.open();
    }

    boolean wantInitializeInitialSelection() {
        WizardState initialState;
        if (this.initialSelectionInitialized) {
            return false;
        }
        if (this.getConfiguration().getInitialState() != null || this.getConfiguration().getInitialOperations() != null) {
            return true;
        }
        return this.initialState != null && ((initialState = this.getInitialState()).getContent() != null && !initialState.getContent().isEmpty() || initialState.getContentType() != null && initialState.getContentType() != MarketplaceViewer.ContentType.SEARCH || initialState.getFilterCategory() != null || initialState.getFilterMarket() != null || initialState.getFilterQuery() != null);
    }

    public boolean canFinish() {
        if (this.computeMustCheckLicenseAcceptance()) {
            if (this.acceptLicensesPage == null && this.getContainer().getCurrentPage() == this.getFeatureSelectionWizardPage()) {
                this.getNextPage((IWizardPage)this.getFeatureSelectionWizardPage(), false);
            }
            if (this.acceptLicensesPage == null || !this.acceptLicensesPage.isPageComplete()) {
                return false;
            }
        }
        if (this.profileChangeOperation != null) {
            IStatus resolutionResult = this.profileChangeOperation.getResolutionResult();
            switch (resolutionResult.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.getNextPage(page, true);
    }

    IWizardPage getNextPage(IWizardPage page, boolean nextpressed) {
        if (page == this.getCatalogPage() && nextpressed) {
            this.profileChangeOperation = null;
            this.featureSelectionWizardPage.updateMessage();
        }
        if (page == this.featureSelectionWizardPage) {
            if (nextpressed && this.profileChangeOperation != null && this.profileChangeOperation instanceof RemediationOperation) {
                try {
                    this.getContainer().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            ((RemediationOperation)MarketplaceWizard.this.profileChangeOperation).setCurrentRemedy(MarketplaceWizard.this.featureSelectionWizardPage.getRemediationGroup().getCurrentRemedy());
                            MarketplaceWizard.this.profileChangeOperation.resolveModal(monitor);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    ProvUI.handleException((Throwable)e.getCause(), null, (int)3);
                }
            }
            if (this.profileChangeOperation == null) {
                if (nextpressed) {
                    this.updateProfileChangeOperation();
                    if (this.profileChangeOperation != null) {
                        this.getContainer().updateButtons();
                    }
                }
                if (this.profileChangeOperation == null || !this.profileChangeOperation.getResolutionResult().isOK()) {
                    return this.featureSelectionWizardPage;
                }
                if (this.profileChangeOperation instanceof UninstallOperation) {
                    return this.featureSelectionWizardPage;
                }
                if (this.profileChangeOperation instanceof RemediationOperation) {
                    return this.featureSelectionWizardPage;
                }
            }
            if (nextpressed && this.profileChangeOperation instanceof RemediationOperation && !this.featureSelectionWizardPage.isInRemediationMode()) {
                this.featureSelectionWizardPage.flipToRemediationComposite();
                return this.featureSelectionWizardPage;
            }
            if (this.computeMustCheckLicenseAcceptance()) {
                if (this.acceptLicensesPage == null) {
                    this.acceptLicensesPage = new AcceptLicensesWizardPage(ProvisioningUI.getDefaultUI().getLicenseManager(), this.operationIUs, this.profileChangeOperation);
                    this.addPage((IWizardPage)this.acceptLicensesPage);
                } else {
                    this.acceptLicensesPage.update(this.operationIUs, this.profileChangeOperation);
                }
                if (this.acceptLicensesPage.hasLicensesToAccept() || this.profileChangeOperation instanceof RemediationOperation) {
                    return this.acceptLicensesPage;
                }
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean computeMustCheckLicenseAcceptance() {
        return this.profileChangeOperation != null && !(this.profileChangeOperation instanceof UninstallOperation);
    }

    public void addPages() {
        this.doDefaultCatalogSelection();
        super.addPages();
        this.featureSelectionWizardPage = new FeatureSelectionWizardPage();
        this.addPage((IWizardPage)this.featureSelectionWizardPage);
    }

    FeatureSelectionWizardPage getFeatureSelectionWizardPage() {
        return this.featureSelectionWizardPage;
    }

    public IWizardPage getStartingPage() {
        if (this.getConfiguration().getCatalogDescriptor() != null) {
            WizardState initialState;
            if (this.wantInitializeInitialSelection() && ((initialState = this.getInitialState()) == null || !Boolean.FALSE.equals(initialState.getProceedWithInstallation()))) {
                return this.getFeatureSelectionWizardPage();
            }
            return this.getCatalogPage();
        }
        return super.getStartingPage();
    }

    private void doDefaultCatalogSelection() {
        if (this.getConfiguration().getCatalogDescriptor() == null) {
            String defaultCatalogUrl = MarketplaceClientUiPlugin.getInstance().getPreferenceStore().getString(PREF_DEFAULT_CATALOG);
            if (defaultCatalogUrl != null && defaultCatalogUrl.length() > 0) {
                for (CatalogDescriptor descriptor : this.getConfiguration().getCatalogDescriptors()) {
                    URL url = descriptor.getUrl();
                    try {
                        if (!url.toURI().toString().equals(defaultCatalogUrl)) continue;
                        this.getConfiguration().setCatalogDescriptor(descriptor);
                        break;
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
            if (this.getConfiguration().getCatalogDescriptor() == null && this.getConfiguration().getCatalogDescriptors().size() > 0) {
                this.getConfiguration().setCatalogDescriptor(this.getConfiguration().getCatalogDescriptors().get(0));
            }
        }
    }

    public void dispose() {
        this.removeAddedRepositoryLocations();
        if (this.getConfiguration().getCatalogDescriptor() != null) {
            try {
                MarketplaceClientUiPlugin.getInstance().getPreferenceStore().setValue(PREF_DEFAULT_CATALOG, this.getConfiguration().getCatalogDescriptor().getUrl().toURI().toString());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (this.getCatalog() != null) {
            this.getCatalog().dispose();
        }
        super.dispose();
    }

    public boolean performFinish() {
        if (this.profileChangeOperation != null && this.profileChangeOperation.getResolutionResult().getSeverity() != 4) {
            ProvisioningJob provisioningJob;
            if (this.computeMustCheckLicenseAcceptance() && this.acceptLicensesPage != null && this.acceptLicensesPage.isPageComplete()) {
                this.acceptLicensesPage.performFinish();
            }
            if ((provisioningJob = this.profileChangeOperation.getProvisioningJob(null)) != null) {
                if (!this.operationNewInstallItems.isEmpty()) {
                    provisioningJob.addJobChangeListener((IJobChangeListener)new ProvisioningJobListener(this.operationNewInstallItems));
                }
                ProvisioningUI.getDefaultUI().schedule(provisioningJob, 3);
                this.addedRepositoryLocations = null;
                return true;
            }
        }
        return false;
    }

    public MarketplacePage getCatalogPage() {
        return (MarketplacePage)super.getCatalogPage();
    }

    @Override
    public synchronized Set<String> getInstalledFeatures() {
        if (this.installedFeatures == null) {
            try {
                if (Display.getCurrent() != null) {
                    this.getContainer().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            MarketplaceWizard.this.installedFeatures = MarketplaceClientUi.computeInstalledFeatures(monitor);
                        }
                    });
                } else {
                    this.installedFeatures = MarketplaceClientUi.computeInstalledFeatures((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (InvocationTargetException e) {
                MarketplaceClientUi.error(e.getCause());
                this.installedFeatures = Collections.emptySet();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.installedFeatures;
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void openUrl(String url) {
        String catalogUrl = this.getCatalogUrl();
        if (WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() && url.toLowerCase().startsWith(catalogUrl.toLowerCase())) {
            int style = 38;
            String browserId = "MPC-" + catalogUrl.replaceAll("[^a-zA-Z0-9_-]", "_");
            try {
                CatalogDescriptor catalogDescriptor = this.getConfiguration().getCatalogDescriptor();
                IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(style, browserId, catalogDescriptor.getLabel(), catalogDescriptor.getDescription());
                String originalUrl = url;
                url = this.appendWizardState(url);
                browser.openURL(new URL(url));
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setActive();
                if (!this.hookLocationListener(browser)) {
                    browser.openURL(new URL(originalUrl));
                }
            }
            catch (PartInitException e) {
                MarketplaceClientUi.handle(e.getStatus(), 7);
            }
            catch (MalformedURLException e) {
                Status status = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.MarketplaceWizard_cannotOpenUrl, (Object[])new Object[]{url, e.getMessage()}), (Throwable)e);
                MarketplaceClientUi.handle((IStatus)status, 7);
            }
        } else {
            WorkbenchUtil.openUrl((String)url, (int)128);
        }
    }

    private String getCatalogUrl() {
        URI catalogUri;
        CatalogDescriptor catalogDescriptor = this.getConfiguration().getCatalogDescriptor();
        URL catalogUrl = catalogDescriptor.getUrl();
        try {
            catalogUri = catalogUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return catalogUri.toString();
    }

    private String appendWizardState(String url) {
        try {
            url = url.indexOf(63) == -1 ? String.valueOf(url) + '?' : String.valueOf(url) + '&';
            String state = new SelectionModelStateSerializer(this.getCatalog(), this.getSelectionModel()).serialize();
            url = String.valueOf(url) + "mpc=true&mpc_state=" + URLEncoder.encode(state, "UTF-8");
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean hookLocationListener(IWebBrowser webBrowser) {
        try {
            Field partField = this.findField(webBrowser.getClass(), "part", IWorkbenchPart.class);
            if (partField != null) {
                Field browserViewerField;
                partField.setAccessible(true);
                IWorkbenchPart part = (IWorkbenchPart)partField.get(webBrowser);
                if (part != null && (browserViewerField = this.findField(part.getClass(), "webBrowser", null)) != null) {
                    Field browserField;
                    browserViewerField.setAccessible(true);
                    Object browserViewer = browserViewerField.get(part);
                    if (browserViewer != null && (browserField = this.findField(browserViewer.getClass(), "browser", Browser.class)) != null) {
                        browserField.setAccessible(true);
                        Browser browser = (Browser)browserField.get(browserViewer);
                        if (browser != null) {
                            if (browser.getData(MarketplaceBrowserIntegration.class.getName()) == null) {
                                if (this.browserListener == null) {
                                    this.browserListener = new MarketplaceBrowserIntegration();
                                }
                                browser.setData(MarketplaceBrowserIntegration.class.getName(), (Object)this.browserListener);
                                browser.addLocationListener((LocationListener)this.browserListener);
                                browser.addOpenWindowListener((OpenWindowListener)this.browserListener);
                            }
                            return true;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    private Field findField(Class<?> clazz, String fieldName, Class<?> fieldClass) {
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals(fieldName) && (fieldClass == null || fieldClass.isAssignableFrom(field.getType()))) {
                    return field;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public void updateProfileChangeOperation() {
        IWizardContainer wizardContainer;
        block23: {
            this.removeAddedRepositoryLocations();
            this.addedRepositoryLocations = null;
            this.profileChangeOperation = null;
            this.operationIUs = null;
            wizardContainer = this.getContainer();
            if (this.getSelectionModel().computeProvisioningOperationViable()) {
                AbstractProvisioningOperation provisioningOperation = null;
                try {
                    Map<CatalogItem, Operation> itemToOperation = this.getSelectionModel().getItemToSelectedOperation();
                    Set<CatalogItem> selectedItems = this.getSelectionModel().getSelectedCatalogItems();
                    ProfileChangeOperationComputer.OperationType operationType = null;
                    for (Map.Entry<CatalogItem, Operation> entry : itemToOperation.entrySet()) {
                        ProfileChangeOperationComputer.OperationType entryOperationType;
                        if (!selectedItems.contains(entry.getKey()) || (entryOperationType = ProfileChangeOperationComputer.OperationType.map(entry.getValue())) == null || operationType != null && operationType != ProfileChangeOperationComputer.OperationType.UPDATE && entryOperationType != ProfileChangeOperationComputer.OperationType.CHANGE) continue;
                        operationType = entryOperationType;
                    }
                    Map<SelectionModel.FeatureEntry, Operation> featureEntries = this.getSelectionModel().getFeatureEntryToOperation(false, false);
                    if (operationType == ProfileChangeOperationComputer.OperationType.CHANGE || operationType == ProfileChangeOperationComputer.OperationType.UPDATE) {
                        EnumSet<ProfileChangeOperationComputer.OperationType> featureOperations = EnumSet.noneOf(ProfileChangeOperationComputer.OperationType.class);
                        for (Map.Entry<SelectionModel.FeatureEntry, Operation> entry : featureEntries.entrySet()) {
                            ProfileChangeOperationComputer.OperationType operation = ProfileChangeOperationComputer.OperationType.map(entry.getValue());
                            if (operation == null) continue;
                            featureOperations.add(operation);
                        }
                        if (featureOperations.contains((Object)ProfileChangeOperationComputer.OperationType.INSTALL) && featureOperations.contains((Object)ProfileChangeOperationComputer.OperationType.UPDATE)) {
                            featureOperations.remove((Object)ProfileChangeOperationComputer.OperationType.UPDATE);
                        }
                        if (featureOperations.size() == 1) {
                            operationType = (ProfileChangeOperationComputer.OperationType)((Object)featureOperations.iterator().next());
                        }
                    }
                    URI dependenciesRepository = null;
                    if (this.getConfiguration().getCatalogDescriptor().getDependenciesRepository() != null) {
                        try {
                            dependenciesRepository = this.getConfiguration().getCatalogDescriptor().getDependenciesRepository().toURI();
                        }
                        catch (URISyntaxException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    provisioningOperation = new ProfileChangeOperationComputer(operationType, selectedItems, featureEntries.keySet(), dependenciesRepository, this.getConfiguration().getCatalogDescriptor().isInstallFromAllRepositories() ? ProfileChangeOperationComputer.ResolutionStrategy.FALLBACK_STRATEGY : ProfileChangeOperationComputer.ResolutionStrategy.SELECTED_REPOSITORIES, this.withRemediation);
                    wizardContainer.run(true, true, (IRunnableWithProgress)provisioningOperation);
                    this.profileChangeOperation = ((ProfileChangeOperationComputer)provisioningOperation).getOperation();
                    this.operationIUs = ((ProfileChangeOperationComputer)provisioningOperation).getIus();
                    this.addedRepositoryLocations = provisioningOperation.getAddedRepositoryLocations();
                    this.operationNewInstallItems = this.computeNewInstallCatalogItems();
                    this.errorMessage = ((ProfileChangeOperationComputer)provisioningOperation).getErrorMessage();
                    IStatus result = this.profileChangeOperation.getResolutionResult();
                    if (result != null && this.operationIUs != null && this.operationIUs.length > 0 && operationType == ProfileChangeOperationComputer.OperationType.INSTALL) {
                        switch (result.getSeverity()) {
                            case 4: {
                                Job job = new Job(Messages.MarketplaceWizard_errorNotificationJob, result, itemToOperation){
                                    IStatus r;
                                    Set<CatalogItem> items;
                                    IInstallableUnit[] ius;
                                    String details;
                                    {
                                        this.r = iStatus;
                                        this.items = new HashSet(map.keySet());
                                        this.ius = MarketplaceWizard.this.operationIUs;
                                        this.details = MarketplaceWizard.this.profileChangeOperation.getResolutionDetails();
                                        this.setSystem(false);
                                        this.setUser(false);
                                        this.setPriority(30);
                                    }

                                    protected IStatus run(IProgressMonitor monitor) {
                                        MarketplaceWizard.this.getCatalog().installErrorReport(monitor, this.r, this.items, this.ius, this.details);
                                        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                                    }
                                };
                                job.schedule();
                            }
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    Object status = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.MarketplaceWizard_problemsPerformingProvisioningOperation, (Object[])new Object[]{cause.getMessage()}), cause);
                    MarketplaceClientUi.handle(status, 7);
                    if (provisioningOperation != null) {
                        this.addedRepositoryLocations = provisioningOperation.getAddedRepositoryLocations();
                    }
                    break block23;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (provisioningOperation != null) {
                            this.addedRepositoryLocations = provisioningOperation.getAddedRepositoryLocations();
                        }
                    }
                }
                if (provisioningOperation == null) break block23;
                this.addedRepositoryLocations = provisioningOperation.getAddedRepositoryLocations();
            }
        }
        if ((wizardContainer = this.getContainer()) != null && wizardContainer.getCurrentPage() == this.featureSelectionWizardPage) {
            this.featureSelectionWizardPage.updateMessage();
        }
    }

    private void removeAddedRepositoryLocations() {
        AbstractProvisioningOperation.removeRepositoryLocations(this.addedRepositoryLocations);
        this.addedRepositoryLocations = null;
    }

    private Set<CatalogItem> computeNewInstallCatalogItems() {
        HashSet<CatalogItem> items = new HashSet<CatalogItem>();
        HashMap iusByCatalogItem = new HashMap();
        for (SelectionModel.CatalogItemEntry entry : this.getSelectionModel().getCatalogItemEntries()) {
            List<SelectionModel.FeatureEntry> features = entry.getChildren();
            ArrayList<String> featureIds = new ArrayList<String>(features.size());
            for (SelectionModel.FeatureEntry featureEntry : features) {
                if (featureEntry.computeChangeOperation() != Operation.INSTALL) continue;
                featureIds.add(featureEntry.getFeatureDescriptor().getId());
            }
            if (featureIds.isEmpty()) continue;
            iusByCatalogItem.put(entry.getItem(), featureIds);
        }
        IInstallableUnit[] iInstallableUnitArray = this.operationIUs;
        int n = this.operationIUs.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit unit = iInstallableUnitArray[n2];
            for (Map.Entry entry : iusByCatalogItem.entrySet()) {
                if (!((Collection)entry.getValue()).contains(unit.getId())) continue;
                items.add((CatalogItem)entry.getKey());
            }
            ++n2;
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeCatalog() {
        MarketplaceCatalog catalog;
        MarketplaceCatalog marketplaceCatalog = catalog = this.getCatalog();
        synchronized (marketplaceCatalog) {
            List discoveryStrategies = catalog.getDiscoveryStrategies();
            for (AbstractDiscoveryStrategy strategy : discoveryStrategies) {
                strategy.dispose();
            }
            discoveryStrategies.clear();
            if (this.getConfiguration().getCatalogDescriptor() != null) {
                discoveryStrategies.add(new MarketplaceDiscoveryStrategy(this.getConfiguration().getCatalogDescriptor()));
            }
        }
    }

    protected void updateNews() {
        String debugNewsUrl;
        CatalogDescriptor catalogDescriptor = this.getConfiguration().getCatalogDescriptor();
        INews news = null;
        if (Boolean.parseBoolean(Platform.getDebugOption((String)DEBUG_NEWS_FLAG)) && (debugNewsUrl = Platform.getDebugOption((String)DEBUG_NEWS_URL)) != null && debugNewsUrl.length() > 0) {
            News debugNews = new News();
            news = debugNews;
            debugNews.setUrl(debugNewsUrl);
            String debugNewsTitle = Platform.getDebugOption((String)DEBUG_NEWS_TITLE);
            if (debugNewsTitle == null || debugNewsTitle.length() == 0) {
                debugNews.setShortTitle("Debug News");
            } else {
                debugNews.setShortTitle(debugNewsTitle);
            }
            debugNews.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        }
        if (news == null) {
            try {
                final INews[] result = new INews[1];
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IStatus status = MarketplaceWizard.this.getCatalog().performNewsDiscovery(monitor);
                        if (!status.isOK() && status.getSeverity() != 8) {
                            MarketplaceClientUi.handle(status, 1);
                        }
                        result[0] = MarketplaceWizard.this.getCatalog().getNews();
                    }
                });
                if (result[0] != null) {
                    news = result[0];
                }
            }
            catch (InvocationTargetException e) {
                IStatus status = MarketplaceClientCore.computeStatus((Exception)e, (String)Messages.MarketplaceViewer_unexpectedException);
                MarketplaceClientUi.handle(status, 1);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (news == null) {
            news = CatalogRegistry.getInstance().getCatalogNews(catalogDescriptor);
        }
        CatalogRegistry.getInstance().addCatalogNews(catalogDescriptor, news);
    }

    public Object suspendWizard() {
        String catalogUrl = this.getCatalogUrl();
        String key = this.appendWizardState(catalogUrl);
        this.getContainer().getShell().close();
        return key;
    }

    public void setInitialState(WizardState initialState) {
        this.initialState = initialState;
    }

    public WizardState getInitialState() {
        return this.initialState;
    }

    public static void resumeWizard(Display display, Object state, boolean proceedWithInstall) {
        String mpcState;
        MarketplaceUrlHandler.SolutionInstallationInfo installInfo;
        String catalogUrl = (String)state;
        if (proceedWithInstall && (installInfo = MarketplaceUrlHandler.createSolutionInstallInfo(catalogUrl)) != null) {
            MarketplaceUrlHandler.triggerInstall(installInfo);
            return;
        }
        CatalogDescriptor descriptor = catalogUrl == null ? null : CatalogRegistry.getInstance().findCatalogDescriptor(catalogUrl);
        final MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        if (descriptor != null) {
            descriptor = new CatalogDescriptor(descriptor);
            descriptor.setLabel("org.eclipse.epp.mpc.descriptorHint");
            command.setSelectedCatalogDescriptor(descriptor);
        }
        if ((mpcState = MarketplaceUrlHandler.getMPCState(catalogUrl)) != null && mpcState.length() > 0) {
            try {
                command.setWizardState(URLDecoder.decode(mpcState, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            if (!proceedWithInstall) {
                WizardState wizardState = new WizardState();
                wizardState.setProceedWithInstallation(false);
                command.setWizardDialogState(wizardState);
            }
        }
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    command.execute(new ExecutionEvent());
                }
                catch (ExecutionException e) {
                    IStatus status = MarketplaceClientCore.computeStatus((Exception)((Object)e), (String)Messages.MarketplaceBrowserIntegration_cannotOpenMarketplaceWizard);
                    MarketplaceClientUi.handle(status, 7);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WizardState {
        private MarketplaceViewer.ContentType contentType;
        private Set<INode> content;
        private IMarket filterMarket;
        private ICategory filterCategory;
        private String filterQuery;
        private Boolean proceedWithInstallation;

        public MarketplaceViewer.ContentType getContentType() {
            return this.contentType;
        }

        public void setContentType(MarketplaceViewer.ContentType contentType) {
            this.contentType = contentType;
        }

        public Set<INode> getContent() {
            return this.content;
        }

        public void setContent(Set<INode> content) {
            this.content = content;
        }

        public IMarket getFilterMarket() {
            return this.filterMarket;
        }

        public void setFilterMarket(IMarket filterMarket) {
            this.filterMarket = filterMarket;
        }

        public ICategory getFilterCategory() {
            return this.filterCategory;
        }

        public void setFilterCategory(ICategory filterCategory) {
            this.filterCategory = filterCategory;
        }

        public String getFilterQuery() {
            return this.filterQuery;
        }

        public void setFilterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
        }

        public Boolean getProceedWithInstallation() {
            return this.proceedWithInstallation;
        }

        public void setProceedWithInstallation(Boolean proceedWithInstallation) {
            this.proceedWithInstallation = proceedWithInstallation;
        }
    }
}

