/*
 * Decompiled with CFR 0.152.
 */
package com.nuvoton.debug.gdbjtag.nulink;

import com.nuvoton.debug.gdbjtag.nulink.Activator;
import com.nuvoton.debug.gdbjtag.nulink.DefaultPreferences;
import ilg.gnuarmeclipse.core.EclipseUtils;
import ilg.gnuarmeclipse.core.preferences.Discoverer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

public class DefaultPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String REG_SUBKEY = "\\Nuvoton\\OpenOCD";
    private static final String REG_NAME = "InstallLocation";
    private static final String REG_NAME_DEPRECATED = "InstallFolder";

    public void initializeDefaultPreferences() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("DefaultPreferenceInitializer.initializeDefaultPreferences()");
        }
        DefaultPreferences.putBoolean("gdb.server.nulink.doStart", true);
        DefaultPreferences.putString("gdb.client.nulink.commands", "set mem inaccessible-by-default off\n");
        DefaultPreferences.putBoolean("tab.main.checkProgram", false);
        Preferences prefs = Platform.getPreferencesService().getRootNode().node("default");
        if (prefs instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)new LateInitializer());
        }
    }

    private class LateInitializer
    implements IEclipsePreferences.INodeChangeListener {
        private LateInitializer() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("LateInitializer.added() " + event + " " + event.getChild().name());
            }
            if ("com.nuvoton.debug.gdbjtag.nulink".equals(event.getChild().name())) {
                this.finalizeInitializationsDefaultPreferences();
                ((IEclipsePreferences)event.getSource()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("LateInitializer.removed() " + event);
            }
        }

        public void finalizeInitializationsDefaultPreferences() {
            IPath path;
            String folder;
            String searchPath;
            String executableName;
            String name;
            if (Activator.getInstance().isDebugging()) {
                System.out.println("LateInitializer.finalizeInitializationsDefaultPreferences()");
            }
            if ((name = DefaultPreferences.getExecutableName()).isEmpty() && !(name = DefaultPreferences.getExecutableNameOs()).isEmpty()) {
                DefaultPreferences.putExecutableName(name);
            }
            if ((executableName = EclipseUtils.getVariableValue((String)"openocd_nulink_executable")) == null || executableName.isEmpty()) {
                executableName = DefaultPreferences.getExecutableName();
            }
            if (EclipseUtils.isWindows() && !executableName.endsWith(".exe")) {
                executableName = String.valueOf(executableName) + ".exe";
            }
            if ((searchPath = DefaultPreferences.getSearchPath()).isEmpty() && !(searchPath = DefaultPreferences.getSearchPathOs()).isEmpty()) {
                DefaultPreferences.putSearchPath(searchPath);
            }
            if (!(folder = DefaultPreferences.getInstallFolder()).isEmpty() && !(path = new Path(folder).append(executableName)).toFile().isFile()) {
                folder = "";
            }
            if (folder.isEmpty()) {
                folder = Discoverer.getRegistryInstallFolder((String)executableName, (String)"bin", (String)DefaultPreferenceInitializer.REG_SUBKEY, (String)DefaultPreferenceInitializer.REG_NAME);
                if (folder == null) {
                    folder = Discoverer.getRegistryInstallFolder((String)executableName, (String)"bin", (String)DefaultPreferenceInitializer.REG_SUBKEY, (String)DefaultPreferenceInitializer.REG_NAME_DEPRECATED);
                }
                if (folder == null) {
                    folder = Discoverer.searchInstallFolder((String)executableName, (String)searchPath, (String)"bin");
                }
            }
            if (folder != null && !folder.isEmpty()) {
                DefaultPreferences.putInstallFolder(folder);
            }
        }
    }
}

