/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.handler;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.module.Messages;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportXmlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dlg = new FileDialog(new Shell(), 4096);
        dlg.setFilterNames(new String[]{String.valueOf(Messages.ImportXmlHandler_ImportXmlFile) + " (*.xml)"});
        dlg.setFilterExtensions(new String[]{"*.xml"});
        String fn = dlg.open();
        if (fn != null) {
            File file = new File(fn);
            IStatus status = XmlUtils.xmlValidate((File)file);
            if (status.isOK()) {
                status = XmlUtils.addXmlFile((File)file);
                if (status.isOK()) {
                    XmlAnalysisModuleSource.notifyModuleChange();
                    ImportXmlHandler.refreshProject();
                } else {
                    TraceUtils.displayErrorMsg((String)Messages.ImportXmlHandler_ImportXmlFile, (String)status.getMessage());
                }
            } else {
                TraceUtils.displayErrorMsg((String)Messages.ImportXmlHandler_ImportXmlFile, (String)status.getMessage());
            }
        }
        return null;
    }

    private static void refreshProject() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfProjectModelElement) {
            ((TmfProjectModelElement)element).getProject().refresh();
        }
    }
}

