/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.views.timegraph.XmlEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.w3c.dom.Element;

public class XmlPresentationProvider
extends TimeGraphPresentationProvider {
    private List<StateItem> stateValues = new ArrayList<StateItem>();
    private Map<Integer, Integer> stateIndex = new HashMap<Integer, Integer>();

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            Integer index;
            TimeEvent tcEvent = (TimeEvent)event;
            XmlEntry entry = (XmlEntry)event.getEntry();
            int value = tcEvent.getValue();
            if (entry.getType() == XmlEntry.EntryDisplayType.DISPLAY && (index = this.stateIndex.get(value)) != null) {
                return index;
            }
        }
        return -1;
    }

    public StateItem[] getStateTable() {
        return this.stateValues.toArray(new StateItem[this.stateValues.size()]);
    }

    public String getEventName(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            TimeEvent tcEvent = (TimeEvent)event;
            XmlEntry entry = (XmlEntry)event.getEntry();
            int value = tcEvent.getValue();
            if (entry.getType() == XmlEntry.EntryDisplayType.DISPLAY) {
                Integer index = this.stateIndex.get(value);
                String rgb = this.stateValues.get(index).getStateString();
                return rgb;
            }
            return null;
        }
        return Messages.XmlPresentationProvider_MultipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        return Collections.EMPTY_MAP;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
    }

    public void loadNewStates(@NonNull Element viewElement) {
        this.stateValues.clear();
        this.stateIndex.clear();
        List states = XmlUtils.getChildElements((Element)viewElement, (String)"definedValue");
        for (Element state : states) {
            int value = Integer.parseInt(state.getAttribute("value"));
            String name = state.getAttribute("name");
            String color = state.getAttribute("color");
            if (value < 0) {
                return;
            }
            RGB colorRGB = new RGB(255, 0, 0);
            if (color.startsWith("#")) {
                Integer hex = Integer.parseInt(color.substring(1), 16);
                int hex1 = hex % 256;
                int hex2 = hex / 256 % 256;
                int hex3 = hex / 65536 % 256;
                colorRGB = new RGB(hex3, hex2, hex1);
            } else {
                colorRGB = XmlPresentationProvider.calcColor(value);
            }
            StateItem item = new StateItem(colorRGB, name);
            Integer index = this.stateIndex.get(value);
            if (index == null) {
                this.stateIndex.put(value, this.stateValues.size());
                this.stateValues.add(item);
                continue;
            }
            this.stateValues.set(index, item);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XmlPresentationProvider.this.fireColorSettingsChanged();
            }
        });
    }

    private static RGB calcColor(int value) {
        int x = value * 97 % 1530;
        int r = 0;
        int g = 0;
        int b = 0;
        if (x >= 0 && x < 255) {
            r = 255;
            g = x;
            b = 0;
        }
        if (x >= 255 && x < 510) {
            r = 510 - x;
            g = 255;
            b = 0;
        }
        if (x >= 510 && x < 765) {
            r = 0;
            g = 255;
            b = x - 510;
        }
        if (x >= 765 && x < 1020) {
            r = 0;
            g = 1020 - x;
            b = 255;
        }
        if (x >= 1020 && x < 1275) {
            r = x - 1020;
            g = 0;
            b = 255;
        }
        if (x >= 1275 && x <= 1530) {
            r = 255;
            g = 0;
            b = 1530 - x;
        }
        return new RGB(r, g, b);
    }
}

