/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.cpuusage;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KernelCpuUsageStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 2;
    private final Map<Integer, Long> fLastStartTimes = new HashMap<Integer, Long>();
    private final long fTraceStart;
    private final IKernelAnalysisEventLayout fLayout;

    public KernelCpuUsageStateProvider(ITmfTrace trace, IKernelAnalysisEventLayout layout) {
        super(trace, "Kernel CPU usage");
        this.fTraceStart = trace.getStartTime().getValue();
        this.fLayout = layout;
    }

    public int getVersion() {
        return 2;
    }

    public KernelCpuUsageStateProvider getNewInstance() {
        return new KernelCpuUsageStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        if (event == null) {
            return;
        }
        String eventName = event.getName();
        if (eventName.equals(this.fLayout.eventSchedSwitch())) {
            Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
            if (cpuObj == null) {
                return;
            }
            Integer cpu = (Integer)cpuObj;
            ITmfEventField content = event.getContent();
            long ts = event.getTimestamp().getValue();
            Long prevTid = (Long)content.getField(new String[]{this.fLayout.fieldPrevTid()}).getValue();
            try {
                ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
                Integer currentCPUNode = ss.getQuarkRelativeAndAdd(KernelCpuUsageStateProvider.getNodeCPUs(ss), new String[]{cpu.toString()});
                Integer cumulativeTimeQuark = ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{prevTid.toString()});
                Long startTime = this.fLastStartTimes.get(cpu);
                if (startTime == null) {
                    startTime = this.fTraceStart;
                }
                ITmfStateValue value = ss.queryOngoingState(cumulativeTimeQuark.intValue());
                long prevCumulativeTime = Math.max(0L, value.unboxLong());
                long newCumulativeTime = prevCumulativeTime + (ts - startTime);
                value = TmfStateValue.newValueLong((long)newCumulativeTime);
                ss.modifyAttribute(ts, value, cumulativeTimeQuark.intValue());
                this.fLastStartTimes.put(cpu, ts);
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError("Attribute not found in LttngKernelCpuStateProvider", e);
            }
        }
    }

    private static int getNodeCPUs(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }
}

