/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.ctf.core.event.LostEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.scope.LexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderDefinition;

public class CTFStreamInputPacketReader
implements IDefinitionScope,
AutoCloseable {
    private static final int BITS_PER_BYTE = 8;
    private static final IDefinitionScope EVENT_HEADER_SCOPE = new IDefinitionScope(){

        @Override
        public IDefinition lookupDefinition(String lookupPath) {
            return null;
        }

        @Override
        public ILexicalScope getScopePath() {
            return null;
        }
    };
    @Nullable
    private BitBuffer fBitBuffer;
    private final CTFStreamInputReader fStreamInputReader;
    private final StructDeclaration fTracePacketHeaderDecl;
    private final StructDeclaration fStreamPacketContextDecl;
    private final IDeclaration fStreamEventHeaderDecl;
    private final StructDeclaration fStreamEventContextDecl;
    private ICompositeDefinition fCurrentTracePacketHeaderDef;
    private ICompositeDefinition fCurrentStreamEventHeaderDef;
    private ICompositeDefinition fCurrentStreamPacketContextDef;
    private ICTFPacketDescriptor fCurrentPacket = null;
    private long fLastTimestamp = 0L;
    private int fCurrentCpu = 0;
    private int fLostEventsInThisPacket;
    private boolean fHasLost = false;

    public CTFStreamInputPacketReader(CTFStreamInputReader streamInputReader) {
        this.fStreamInputReader = streamInputReader;
        ByteBuffer allocateDirect = ByteBuffer.allocateDirect(0);
        if (allocateDirect == null) {
            throw new IllegalStateException("Unable to allocate 0 bytes!");
        }
        this.fBitBuffer = new BitBuffer(allocateDirect);
        CTFStream currentStream = streamInputReader.getStreamInput().getStream();
        this.fTracePacketHeaderDecl = currentStream.getTrace().getPacketHeader();
        this.fStreamPacketContextDecl = currentStream.getPacketContextDecl();
        this.fStreamEventHeaderDecl = currentStream.getEventHeaderDeclaration();
        this.fStreamEventContextDecl = currentStream.getEventContextDecl();
    }

    public StructDefinition getEventContextDefinition(@NonNull BitBuffer input) throws CTFException {
        return this.fStreamEventContextDecl.createDefinition((IDefinitionScope)this.fStreamInputReader.getStreamInput(), ILexicalScope.STREAM_EVENT_CONTEXT, input);
    }

    public StructDefinition getStreamPacketContextDefinition(@NonNull BitBuffer input) throws CTFException {
        return this.fStreamPacketContextDecl.createDefinition((IDefinitionScope)this.fStreamInputReader.getStreamInput(), ILexicalScope.STREAM_PACKET_CONTEXT, input);
    }

    public StructDefinition getTracePacketHeaderDefinition(@NonNull BitBuffer input) throws CTFException {
        return this.fTracePacketHeaderDecl.createDefinition((IDefinitionScope)this.fStreamInputReader.getStreamInput().getStream().getTrace(), ILexicalScope.TRACE_PACKET_HEADER, input);
    }

    @Override
    public void close() {
        this.fBitBuffer = null;
    }

    ICTFPacketDescriptor getCurrentPacket() {
        return this.fCurrentPacket;
    }

    public int getCPU() {
        return this.fCurrentCpu;
    }

    @Override
    public LexicalScope getScopePath() {
        return ILexicalScope.PACKET;
    }

    @NonNull
    private ByteBuffer getByteBufferAt(long position, long size) throws CTFException, IOException {
        ByteBuffer map = SafeMappedByteBuffer.map(this.fStreamInputReader.getFc(), FileChannel.MapMode.READ_ONLY, position, size);
        if (map == null) {
            throw new CTFIOException("Failed to allocate mapped byte buffer");
        }
        return map;
    }

    public void setCurrentPacket(ICTFPacketDescriptor currentPacket) throws CTFException {
        this.fCurrentPacket = currentPacket;
        this.fHasLost = false;
        if (this.fCurrentPacket != null) {
            BitBuffer bitBuffer;
            ByteBuffer bb = null;
            try {
                bb = this.getByteBufferAt(this.fCurrentPacket.getOffsetBytes(), (this.fCurrentPacket.getPacketSizeBits() + 8L - 1L) / 8L);
            }
            catch (IOException e) {
                throw new CTFIOException(e.getMessage(), e);
            }
            this.fBitBuffer = bitBuffer = new BitBuffer(bb);
            if (this.fTracePacketHeaderDecl != null) {
                this.fCurrentTracePacketHeaderDef = this.getTracePacketHeaderDefinition(bitBuffer);
            }
            if (this.fStreamPacketContextDecl != null) {
                this.fCurrentStreamPacketContextDef = this.getStreamPacketContextDefinition(bitBuffer);
                if (this.getCurrentPacket().getTarget() != null) {
                    this.fCurrentCpu = (int)this.getCurrentPacket().getTargetId();
                }
                this.fLostEventsInThisPacket = (int)this.getCurrentPacket().getLostEvents();
                if (this.fLostEventsInThisPacket != 0) {
                    this.fHasLost = true;
                }
            }
            this.fLastTimestamp = Math.max(currentPacket.getTimestampBegin(), 0L);
        } else {
            this.fBitBuffer = null;
            this.fLastTimestamp = 0L;
        }
    }

    public boolean hasMoreEvents() {
        BitBuffer bitBuffer = this.fBitBuffer;
        ICTFPacketDescriptor currentPacket = this.fCurrentPacket;
        if (currentPacket != null && bitBuffer != null) {
            return this.fHasLost || bitBuffer.position() < currentPacket.getContentSizeBits();
        }
        return false;
    }

    public EventDefinition readNextEvent() throws CTFException {
        EventDeclaration eventDeclaration;
        int eventID = -2;
        BitBuffer currentBitBuffer = this.fBitBuffer;
        ICTFPacketDescriptor currentPacket = this.fCurrentPacket;
        if (currentBitBuffer == null || currentPacket == null) {
            return null;
        }
        long posStart = currentBitBuffer.position();
        if (this.fHasLost && posStart >= currentPacket.getContentSizeBits()) {
            this.fHasLost = false;
            LostEventDeclaration lostEventDeclaration = LostEventDeclaration.INSTANCE;
            StructDeclaration lostFields = lostEventDeclaration.getFields();
            IntegerDeclaration lostFieldsDecl = (IntegerDeclaration)lostFields.getField("Lost events");
            if (lostFieldsDecl == null) {
                throw new IllegalStateException("Lost events count not declared!");
            }
            IntegerDeclaration lostEventsDurationDecl = (IntegerDeclaration)lostFields.getField("duration");
            if (lostEventsDurationDecl == null) {
                throw new IllegalStateException("Lost events duration not declared!");
            }
            long lostEventsTimestamp = this.fLastTimestamp;
            long lostEventsDuration = currentPacket.getTimestampEnd() - lostEventsTimestamp;
            IntegerDefinition lostDurationDef = new IntegerDefinition(lostFieldsDecl, null, "duration", lostEventsDuration);
            IntegerDefinition lostCountDef = new IntegerDefinition(lostEventsDurationDecl, null, "Lost events", this.fLostEventsInThisPacket);
            Definition[] fields = new IntegerDefinition[]{lostCountDef, lostDurationDef};
            return new EventDefinition(lostEventDeclaration, this.fStreamInputReader, lostEventsTimestamp, null, null, null, new StructDefinition(lostFields, (IDefinitionScope)this, "fields", fields));
        }
        if (this.fStreamEventHeaderDecl != null) {
            if (this.fStreamEventHeaderDecl instanceof IEventHeaderDeclaration) {
                this.fCurrentStreamEventHeaderDef = (ICompositeDefinition)((Object)this.fStreamEventHeaderDecl.createDefinition(EVENT_HEADER_SCOPE, "", currentBitBuffer));
                EventHeaderDefinition ehd = (EventHeaderDefinition)this.fCurrentStreamEventHeaderDef;
                eventID = ehd.getId();
            } else {
                StructDefinition variantCurrentField;
                Definition vIdDef;
                this.fCurrentStreamEventHeaderDef = ((StructDeclaration)this.fStreamEventHeaderDecl).createDefinition(EVENT_HEADER_SCOPE, ILexicalScope.EVENT_HEADER, currentBitBuffer);
                StructDefinition StructEventHeaderDef = (StructDefinition)this.fCurrentStreamEventHeaderDef;
                Definition idDef = StructEventHeaderDef.lookupDefinition("id");
                SimpleDatatypeDefinition simpleIdDef = null;
                if (idDef instanceof SimpleDatatypeDefinition) {
                    simpleIdDef = (SimpleDatatypeDefinition)idDef;
                } else if (idDef != null) {
                    throw new CTFIOException("Id defintion not an integer, enum or float definiton in event header.");
                }
                Definition variantDef = StructEventHeaderDef.lookupDefinition("v");
                if (variantDef instanceof VariantDefinition && (vIdDef = (variantCurrentField = (StructDefinition)((VariantDefinition)variantDef).getCurrentField()).lookupDefinition("id")) instanceof IntegerDefinition) {
                    simpleIdDef = (SimpleDatatypeDefinition)vIdDef;
                }
                if (simpleIdDef != null) {
                    eventID = simpleIdDef.getIntegerValue().intValue();
                }
            }
        }
        if ((eventDeclaration = (EventDeclaration)this.fStreamInputReader.getStreamInput().getStream().getEventDeclaration(eventID)) == null) {
            throw new CTFIOException("Incorrect event id : " + eventID);
        }
        EventDefinition eventDef = eventDeclaration.createDefinition(this.fStreamInputReader, this.fCurrentStreamEventHeaderDef, currentBitBuffer, this.fLastTimestamp);
        this.fLastTimestamp = eventDef.getTimestamp();
        if (posStart == currentBitBuffer.position()) {
            throw new CTFIOException("Empty event not allowed, event: " + eventDef.getDeclaration().getName());
        }
        return eventDef;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals(ILexicalScope.STREAM_PACKET_CONTEXT.getPath())) {
            return (Definition)((Object)this.fCurrentStreamPacketContextDef);
        }
        if (lookupPath.equals(ILexicalScope.TRACE_PACKET_HEADER.getPath())) {
            return (Definition)((Object)this.fCurrentTracePacketHeaderDef);
        }
        return null;
    }

    public ICompositeDefinition getStreamEventHeaderDefinition() {
        return this.fCurrentStreamEventHeaderDef;
    }

    public StructDefinition getCurrentPacketEventHeader() {
        if (this.fCurrentTracePacketHeaderDef instanceof StructDefinition) {
            return (StructDefinition)this.fCurrentTracePacketHeaderDef;
        }
        return null;
    }
}

