/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFResponse;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputPacketReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.Activator;

public class CTFStreamInputReader
implements AutoCloseable {
    @NonNull
    private final File fFile;
    @NonNull
    private final CTFStreamInput fStreamInput;
    private final FileChannel fFileChannel;
    private final CTFStreamInputPacketReader fPacketReader;
    private int fPacketIndex;
    private EventDefinition fCurrentEvent = null;
    private int fId;
    private CTFTraceReader fParent;
    private boolean fLive = false;

    public CTFStreamInputReader(CTFStreamInput streamInput) throws CTFException {
        if (streamInput == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.fStreamInput = streamInput;
        this.fFile = this.fStreamInput.getFile();
        try {
            this.fFileChannel = FileChannel.open(this.fFile.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new CTFIOException(e);
        }
        try {
            this.fPacketReader = new CTFStreamInputPacketReader(this);
            this.fPacketIndex = -1;
            this.goToNextPacket();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fFileChannel != null) {
            this.fFileChannel.close();
        }
        if (this.fPacketReader != null) {
            this.fPacketReader.close();
        }
    }

    public EventDefinition getCurrentEvent() {
        return this.fCurrentEvent;
    }

    public ByteOrder getByteOrder() {
        return this.fStreamInput.getStream().getTrace().getByteOrder();
    }

    public int getName() {
        return this.fId;
    }

    public void setName(int name) {
        this.fId = name;
    }

    public int getCPU() {
        return this.fPacketReader.getCPU();
    }

    public String getFilename() {
        return this.fStreamInput.getFilename();
    }

    CTFStreamInput getStreamInput() {
        return this.fStreamInput;
    }

    public Iterable<IEventDeclaration> getEventDeclarations() {
        return ImmutableList.copyOf(this.fStreamInput.getStream().getEventDeclarations());
    }

    public void setLive(boolean live) {
        this.fLive = live;
    }

    public boolean isLive() {
        return this.fLive;
    }

    public StructDeclaration getStreamEventContextDecl() {
        return this.getStreamInput().getStream().getEventContextDecl();
    }

    public CTFResponse readNextEvent() throws CTFException {
        ICTFPacketDescriptor prevPacket;
        if (!this.fPacketReader.hasMoreEvents() && ((prevPacket = this.fPacketReader.getCurrentPacket()) != null || this.fLive)) {
            this.goToNextPacket();
        }
        if (this.fPacketReader.hasMoreEvents()) {
            this.setCurrentEvent(this.fPacketReader.readNextEvent());
            return CTFResponse.OK;
        }
        this.setCurrentEvent(null);
        return this.fLive ? CTFResponse.WAIT : CTFResponse.FINISH;
    }

    private void goToNextPacket() throws CTFException {
        ++this.fPacketIndex;
        if (this.getPacketSize() >= this.fPacketIndex + 1) {
            this.fPacketReader.setCurrentPacket(this.getPacket());
        } else if (this.fStreamInput.addPacketHeaderIndex()) {
            this.fPacketIndex = this.getPacketSize() - 1;
            this.fPacketReader.setCurrentPacket(this.getPacket());
        } else {
            this.fPacketReader.setCurrentPacket(null);
        }
    }

    private int getPacketSize() {
        return this.fStreamInput.getIndex().size();
    }

    public long seek(long timestamp) throws CTFException {
        long offset = 0L;
        this.gotoPacket(timestamp);
        while (this.fPacketReader.getCurrentPacket() != null && this.fPacketReader.getCurrentPacket().getTimestampEnd() < timestamp) {
            try {
                this.fStreamInput.addPacketHeaderIndex();
                this.goToNextPacket();
            }
            catch (CTFException e) {
                Activator.log(e.getMessage());
            }
        }
        if (this.fPacketReader.getCurrentPacket() == null) {
            this.gotoPacket(timestamp);
        }
        this.readNextEvent();
        boolean done = this.getCurrentEvent() == null;
        while (!done && this.getCurrentEvent().getTimestamp() < timestamp) {
            this.readNextEvent();
            done = this.getCurrentEvent() == null;
            ++offset;
        }
        return offset;
    }

    private void gotoPacket(long timestamp) throws CTFException {
        this.fPacketIndex = this.fStreamInput.getIndex().search(timestamp).previousIndex();
        this.goToNextPacket();
    }

    public void goToLastEvent() throws CTFException {
        int lastPacketIndex;
        this.seek(0L);
        if (this.fStreamInput.getIndex().isEmpty() || !this.fPacketReader.hasMoreEvents()) {
            return;
        }
        this.fPacketIndex = this.fStreamInput.getIndex().size() - 1;
        this.fPacketReader.setCurrentPacket(this.getPacket());
        while (this.fPacketReader.getCurrentPacket() != null) {
            this.goToNextPacket();
        }
        int pos = lastPacketIndex = this.fStreamInput.getIndex().size() - 1;
        while (pos > 0) {
            this.fPacketIndex = pos--;
            this.fPacketReader.setCurrentPacket(this.getPacket());
            if (this.fPacketReader.hasMoreEvents()) break;
        }
        EventDefinition prevEvent = null;
        while (this.fCurrentEvent != null) {
            prevEvent = this.fCurrentEvent;
            this.readNextEvent();
        }
        this.setCurrentEvent(prevEvent);
    }

    public CTFTraceReader getParent() {
        return this.fParent;
    }

    public void setParent(CTFTraceReader parent) {
        this.fParent = parent;
    }

    public void setCurrentEvent(EventDefinition currentEvent) {
        this.fCurrentEvent = currentEvent;
    }

    private int getPacketIndex() {
        return this.fPacketIndex;
    }

    private ICTFPacketDescriptor getPacket() {
        return this.fStreamInput.getIndex().getElement(this.getPacketIndex());
    }

    FileChannel getFc() {
        return this.fFileChannel;
    }

    public CTFStreamInputPacketReader getPacketReader() {
        return this.fPacketReader;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fId;
        result = 31 * result + this.fFile.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFStreamInputReader)) {
            return false;
        }
        CTFStreamInputReader other = (CTFStreamInputReader)obj;
        if (this.fId != other.fId) {
            return false;
        }
        return this.fFile.equals(other.fFile);
    }

    public String toString() {
        return String.valueOf(this.fId + 32) + this.fCurrentEvent.toString();
    }
}

