/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ByteArrayDefinition;

public final class ArrayDeclaration
extends CompoundDeclaration {
    private final int fLength;
    private final IDeclaration fElemType;
    private final transient ArrayListMultimap<String, String> fChildrenNames = ArrayListMultimap.create();

    public ArrayDeclaration(int length, IDeclaration elemType) {
        this.fLength = length;
        this.fElemType = elemType;
    }

    @Override
    public IDeclaration getElementType() {
        return this.fElemType;
    }

    public int getLength() {
        return this.fLength;
    }

    @Override
    public AbstractArrayDefinition createDefinition(@Nullable IDefinitionScope definitionScope, @NonNull String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        if (this.isAlignedBytes()) {
            byte[] data = new byte[this.fLength];
            if (input.getByteBuffer().remaining() < this.fLength) {
                throw new CTFException("Buffer underflow");
            }
            input.get(data);
            return new ByteArrayDefinition(this, definitionScope, fieldName, data);
        }
        List<Definition> definitions = this.read(input, definitionScope, fieldName);
        return new ArrayDefinition(this, definitionScope, fieldName, definitions);
    }

    public String toString() {
        return "[declaration] array[" + Integer.toHexString(this.hashCode()) + ']';
    }

    @NonNull
    private List<Definition> read(@NonNull BitBuffer input, @Nullable IDefinitionScope definitionScope, String fieldName) throws CTFException {
        ImmutableList.Builder definitions = new ImmutableList.Builder();
        if (!this.fChildrenNames.containsKey((Object)fieldName)) {
            int i = 0;
            while (i < this.fLength) {
                this.fChildrenNames.put((Object)fieldName, (Object)(String.valueOf(fieldName) + '[' + i + ']'));
                ++i;
            }
        }
        List elemNames = this.fChildrenNames.get((Object)fieldName);
        int i = 0;
        while (i < this.fLength) {
            String name = (String)elemNames.get(i);
            if (name == null) {
                throw new IllegalStateException();
            }
            definitions.add((Object)this.fElemType.createDefinition(definitionScope, name, input));
            ++i;
        }
        return (List)NonNullUtils.checkNotNull((Object)definitions.build());
    }

    @Override
    public int getMaximumSize() {
        long val = (long)this.fLength * (long)this.fElemType.getMaximumSize();
        return (int)Math.min(Integer.MAX_VALUE, val);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fElemType.hashCode();
        result = 31 * result + this.fLength;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayDeclaration other = (ArrayDeclaration)obj;
        if (!this.fElemType.equals(other.fElemType)) {
            return false;
        }
        return this.fLength == other.fLength;
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayDeclaration other = (ArrayDeclaration)obj;
        if (!this.fElemType.isBinaryEquivalent(other.fElemType)) {
            return false;
        }
        return this.fLength == other.fLength;
    }
}

