/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.HexUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    private static final int MAX_FILE_NAME_LENGTH = 200;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final ObjectOutputStream DEV_NULL = IOUtil.createDevNull();
    private static final String IMAGE_DATA_PREFIX = "imagedata:";

    private IOUtil() {
    }

    private static ObjectOutputStream createDevNull() {
        try {
            return new ObjectOutputStream(new OutputStream(){

                public void write(int b) throws IOException {
                }
            });
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isValidFolder(File folder) {
        try {
            return folder.isDirectory() && folder.getAbsoluteFile().equals(folder.getCanonicalFile()) && folder.listFiles() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static File getExistingFolder(File file) {
        if (file.isDirectory()) {
            return file.getAbsoluteFile();
        }
        File parent = file.getParentFile();
        if (parent != null) {
            return IOUtil.getExistingFolder(parent);
        }
        return null;
    }

    public static File getFromPath(String command) {
        String path = System.getenv().get("PATH");
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String folder = tokenizer.nextToken();
            File file = new File(folder, command);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    public static boolean isSerializeable(Object object) {
        try {
            DEV_NULL.writeObject(object);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static byte[] serialize(Serializable object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(baos);
            stream.writeObject(object);
            stream.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            UtilPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static Serializable deserialize(byte[] bytes) {
        try {
            ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return (Serializable)stream.readObject();
        }
        catch (Exception ex) {
            UtilPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static Serializable deserialize(byte[] bytes, final ClassLoader classLoader) {
        try {
            ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    block4: {
                        if (classLoader != null) {
                            String className = desc.getName();
                            try {
                                Class<?> c = classLoader.loadClass(className);
                                if (c != null) {
                                    return c;
                                }
                            }
                            catch (ClassNotFoundException ex) {
                                if (StackTraceElement[].class.getName().equals(className)) break block4;
                                UtilPlugin.INSTANCE.log(ex);
                            }
                        }
                    }
                    return super.resolveClass(desc);
                }
            };
            return (Serializable)stream.readObject();
        }
        catch (Exception ex) {
            UtilPlugin.INSTANCE.log(ex);
            return null;
        }
    }

    public static byte[] getSHA1(String contents) throws NoSuchAlgorithmException, IOException {
        return IOUtil.getSHA1(new ByteArrayInputStream(contents.getBytes()));
    }

    public static byte[] getSHA1(InputStream contents) throws NoSuchAlgorithmException, IOException {
        byte[] byArray;
        FilterInputStream stream = null;
        try {
            final MessageDigest digest = MessageDigest.getInstance("SHA-1");
            stream = new FilterInputStream(contents){

                public int read() throws IOException {
                    int ch;
                    block4: while (true) {
                        ch = super.read();
                        switch (ch) {
                            case -1: {
                                return -1;
                            }
                            case 10: 
                            case 13: {
                                continue block4;
                            }
                        }
                        break;
                    }
                    digest.update((byte)ch);
                    return ch;
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    int read = super.read(b, off, len);
                    if (read == -1) {
                        return -1;
                    }
                    int i = off;
                    while (i < off + read) {
                        byte c = b[i];
                        if (c == 10 || c == 13) {
                            if (i + 1 < off + read) {
                                System.arraycopy(b, i + 1, b, i, read - i - 1);
                                --i;
                            }
                            --read;
                        }
                        ++i;
                    }
                    digest.update(b, off, read);
                    return read;
                }
            };
            byte[] bytes = new byte[8192];
            while (((InputStream)stream).read(bytes) != -1) {
            }
            byArray = digest.digest();
        }
        catch (Throwable throwable) {
            IOUtil.close(stream);
            throw throwable;
        }
        IOUtil.close(stream);
        return byArray;
    }

    public static String encodeFileName(String path) {
        String result = path.replace(':', '_').replace('/', '_').replace('\\', '_').replace('?', '_');
        int length = result.length();
        if (length > 200) {
            String digest;
            try {
                byte[] bytes = IOUtil.getSHA1(result);
                digest = "-" + HexUtil.bytesToHex(bytes) + "-";
            }
            catch (Exception exception) {
                digest = "---" + result.hashCode() + "---";
            }
            int half = (200 - digest.length() >> 1) - 1;
            result = String.valueOf(result.substring(0, half)) + digest + result.substring(result.length() - half);
        }
        return result;
    }

    public static String encodeImageData(String imageURI) {
        block6: {
            int lastDot;
            if (!imageURI.startsWith(IMAGE_DATA_PREFIX) && (lastDot = imageURI.lastIndexOf(46)) != -1) {
                String extension = imageURI.substring(lastDot);
                InputStream in = null;
                try {
                    try {
                        in = new URL(imageURI).openStream();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtil.copy(in, baos);
                        String data = HexUtil.bytesToHex(baos.toByteArray());
                        imageURI = IMAGE_DATA_PREFIX + data + extension;
                    }
                    catch (Exception exception) {
                        IOUtil.closeSilent(in);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(in);
                    throw throwable;
                }
                IOUtil.closeSilent(in);
            }
        }
        return imageURI;
    }

    public static String decodeImageData(String imageURI) {
        if (imageURI.startsWith(IMAGE_DATA_PREFIX)) {
            String data = imageURI.substring(IMAGE_DATA_PREFIX.length());
            FileOutputStream out = null;
            try {
                try {
                    byte[] digest = IOUtil.getSHA1(data);
                    int lastDot = data.lastIndexOf(46);
                    if (lastDot != -1) {
                        String extension = data.substring(lastDot);
                        data = data.substring(0, lastDot);
                        File iconFile = new File(PropertiesUtil.getProperty("java.io.tmpdir"), "icon-" + HexUtil.bytesToHex(digest) + extension);
                        if (!iconFile.exists()) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(HexUtil.hexToBytes(data));
                            out = new FileOutputStream(iconFile);
                            IOUtil.copy(bais, out);
                        }
                        imageURI = iconFile.toURI().toString();
                    }
                }
                catch (Exception exception) {
                    IOUtil.closeSilent(out);
                }
            }
            finally {
                IOUtil.closeSilent(out);
            }
        }
        return imageURI;
    }

    public static URI newURI(String uri) throws IORuntimeException {
        if (StringUtil.isEmpty(uri)) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static FileInputStream openInputStream(File file) throws IORuntimeException {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IORuntimeException {
        try {
            IOUtil.mkdirs(file.getParentFile());
            return new FileOutputStream(file);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static Exception closeSilent(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return null;
        }
        catch (Exception ex) {
            UtilPlugin.INSTANCE.log(ex, 2);
            return ex;
        }
    }

    public static Exception closeSilent(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
            return null;
        }
        catch (Exception ex) {
            UtilPlugin.INSTANCE.log(ex, 2);
            return ex;
        }
    }

    public static Exception closeSilent(ServerSocket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
            return null;
        }
        catch (Exception ex) {
            UtilPlugin.INSTANCE.log(ex, 2);
            return ex;
        }
    }

    public static void close(Closeable closeable) throws IORuntimeException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static void mkdirs(File folder) throws IORuntimeException {
        if (folder != null && !folder.exists() && !folder.mkdirs()) {
            throw new IORuntimeException("Unable to create directory " + folder.getAbsolutePath());
        }
    }

    public static File createTempFolder(String prefix, boolean deleteOnExit) throws IORuntimeException {
        try {
            File folder = File.createTempFile(prefix, "");
            IOUtil.deleteBestEffort(folder, deleteOnExit);
            IOUtil.mkdirs(folder);
            return folder;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static boolean deleteBestEffort(File file) {
        return IOUtil.deleteBestEffort(file, true);
    }

    public static boolean deleteBestEffort(File file, boolean deleteOnExit) {
        boolean deleted = true;
        if (file != null) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    deleted &= IOUtil.deleteBestEffort(child, deleteOnExit);
                    ++n2;
                }
            }
            if (!file.delete()) {
                deleted = false;
                if (deleteOnExit) {
                    file.deleteOnExit();
                }
            }
        }
        return deleted;
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IORuntimeException {
        try {
            int n;
            long length = 0L;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                length += (long)n;
            }
            return length;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IORuntimeException {
        return IOUtil.copy(input, output, new byte[bufferSize]);
    }

    public static long copy(InputStream input, OutputStream output) throws IORuntimeException {
        return IOUtil.copy(input, output, 8192);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyTree(File source, File target, boolean bestEffort) throws IORuntimeException {
        if (source.isDirectory()) {
            File[] files;
            IOUtil.mkdirs(target);
            File[] fileArray = files = source.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                IOUtil.copyTree(new File(source, name), new File(target, name), bestEffort);
                ++n2;
            }
            return;
        } else {
            try {
                IOUtil.copyFile(source, target);
                return;
            }
            catch (RuntimeException ex) {
                if (bestEffort) return;
                throw ex;
            }
        }
    }

    public static void copyTree(File source, File target) throws IORuntimeException {
        IOUtil.copyTree(source, target, false);
    }

    public static void copyFile(File source, File target) throws IORuntimeException {
        IOUtil.mkdirs(target.getParentFile());
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = IOUtil.openInputStream(source);
            output = IOUtil.openOutputStream(target);
            IOUtil.copy(input, output);
        }
        finally {
            IOUtil.closeSilent(input);
            IOUtil.closeSilent(output);
        }
    }

    public static byte[] readFile(File file) throws IORuntimeException {
        if (file.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + file.length());
        }
        int size = (int)file.length();
        FileInputStream input = IOUtil.openInputStream(file);
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(size);
            IOUtil.copy(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.closeSilent(input);
        }
    }

    public static void writeFile(File file, byte[] bytes) throws IORuntimeException {
        FileOutputStream output = IOUtil.openOutputStream(file);
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            IOUtil.copy(input, output);
        }
        finally {
            IOUtil.closeSilent(output);
        }
    }

    public static List<String> readLines(File file, String charsetName) {
        ArrayList<String> lines = new ArrayList<String>();
        if (file.exists()) {
            List<String> list;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                list = IOUtil.readLines(in, charsetName);
            }
            catch (IOException ex) {
                try {
                    throw new IORuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(in);
                    throw throwable;
                }
            }
            IOUtil.closeSilent(in);
            return list;
        }
        return lines;
    }

    public static List<String> readLines(InputStream in, String charsetName) {
        ArrayList<String> lines = new ArrayList<String>();
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String line;
                reader = charsetName == null ? new InputStreamReader(in) : new InputStreamReader(in, charsetName);
                bufferedReader = new BufferedReader(reader);
                while ((line = bufferedReader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(bufferedReader);
            IOUtil.closeSilent(reader);
            throw throwable;
        }
        IOUtil.closeSilent(bufferedReader);
        IOUtil.closeSilent(reader);
        return lines;
    }

    public static void writeLines(File file, String charsetName, List<String> lines) {
        IOUtil.mkdirs(file.getParentFile());
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                IOUtil.writeLines(out, charsetName, lines);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(out);
            throw throwable;
        }
        IOUtil.closeSilent(out);
    }

    public static void writeLines(OutputStream out, String charsetName, List<String> lines) {
        OutputStreamWriter writer = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                writer = charsetName == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, charsetName);
                bufferedWriter = new BufferedWriter(writer);
                for (String line : lines) {
                    bufferedWriter.write(line);
                    bufferedWriter.write(StringUtil.NL);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(bufferedWriter);
            IOUtil.closeSilent(writer);
            throw throwable;
        }
        IOUtil.closeSilent(bufferedWriter);
        IOUtil.closeSilent(writer);
    }

    public static String readUTF8(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtil.copy(inputStream, outputStream);
        }
        finally {
            IOUtil.close(inputStream);
        }
        return new String(outputStream.toByteArray(), "UTF-8");
    }

    public static void writeUTF8(File file, String contents) throws Exception {
        IOUtil.mkdirs(file.getParentFile());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            IOUtil.copy(inputStream, outputStream);
        }
        finally {
            IOUtil.close(outputStream);
        }
    }

    public static Object readObject(File file) throws Exception {
        return IOUtil.readObject(file, null);
    }

    public static Object readObject(File file, ClassLoader classLoader) throws Exception {
        return IOUtil.readObject(file, new ClassLoaderClassResolver(classLoader));
    }

    public static Object readObject(File file, final ClassResolver classResolver) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            ObjectInputStream ois = new ObjectInputStream(inputStream){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    Class<?> c;
                    if (classResolver != null && (c = classResolver.resolveClass(desc)) != null) {
                        return c;
                    }
                    return super.resolveClass(desc);
                }
            };
            Object object = ois.readObject();
            return object;
        }
        finally {
            IOUtil.close(inputStream);
        }
    }

    public static void writeObject(File file, Object object) throws Exception {
        IOUtil.mkdirs(file.getParentFile());
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(outputStream);
            oos.writeObject(object);
            oos.flush();
        }
        finally {
            IOUtil.close(outputStream);
        }
    }

    public static String readXML(InputStream inputStream) throws Exception {
        try {
            DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            out.close();
            String string = out.toString();
            return string;
        }
        finally {
            IOUtil.close(inputStream);
        }
    }

    public static List<File> listDepthFirst(File file) {
        FileCollector collector = new FileCollector();
        IOUtil.visitDepthFirst(file, (IOVisitor)collector);
        return collector.getFiles();
    }

    public static List<File> listBreadthFirst(File file) {
        FileCollector collector = new FileCollector();
        IOUtil.visitBreadthFirst(file, (IOVisitor)collector);
        return collector.getFiles();
    }

    private static void visitDepthFirst(File file, IOVisitor visitor) throws IORuntimeException {
        try {
            boolean recurse = visitor.visit(file);
            if (recurse && file.isDirectory()) {
                IOUtil.visitDepthFirst(file.listFiles(), visitor);
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    private static void visitDepthFirst(File[] files, IOVisitor visitor) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IOUtil.visitDepthFirst(file, visitor);
            ++n2;
        }
    }

    private static void visitBreadthFirst(File file, IOVisitor visitor) throws IORuntimeException {
        File[] files = new File[]{file};
        IOUtil.visitBreadthFirst(files, visitor);
    }

    private static void visitBreadthFirst(File[] files, IOVisitor visitor) throws IORuntimeException {
        try {
            File file;
            boolean[] recurse = new boolean[files.length];
            int i = 0;
            while (i < files.length) {
                file = files[i];
                recurse[i] = visitor.visit(file);
                ++i;
            }
            i = 0;
            while (i < files.length) {
                file = files[i];
                if (file.isDirectory() && recurse[i]) {
                    File[] children;
                    File[] fileArray = children = file.listFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        IOUtil.visitBreadthFirst(child, visitor);
                        ++n2;
                    }
                }
                ++i;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassLoaderClassResolver
    implements ClassResolver {
        private static final String STACK_TRACE_ELEMENT = StackTraceElement[].class.getName();
        private final ClassLoader classLoader;

        public ClassLoaderClassResolver(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass v) throws ClassNotFoundException {
            String className = v.getName();
            try {
                return this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                if (!STACK_TRACE_ELEMENT.equals(className)) {
                    UtilPlugin.INSTANCE.log(ex, 2);
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ClassResolver {
        public Class<?> resolveClass(ObjectStreamClass var1) throws ClassNotFoundException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCollector
    implements IOVisitor {
        private List<File> files = new ArrayList<File>();

        public List<File> getFiles() {
            return this.files;
        }

        @Override
        public boolean visit(File file) throws IOException {
            this.files.add(file);
            return true;
        }
    }

    private static interface IOVisitor {
        public boolean visit(File var1) throws IOException;
    }
}

