/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.action.ExpandAllModelAction;
import org.eclipse.egit.ui.internal.synchronize.action.GitOpenInCompareAction;
import org.eclipse.egit.ui.internal.synchronize.action.OpenWorkingFileAction;
import org.eclipse.egit.ui.internal.synchronize.action.PullAction;
import org.eclipse.egit.ui.internal.synchronize.action.PushAction;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.SupportedContextActionsHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

class GitActionContributor
extends SynchronizePageActionGroup {
    private static final String GIT_ACTIONS = "gitActions";
    private OpenWorkingFileAction openWorkingFileAction;

    GitActionContributor() {
    }

    public void fillContextMenu(IMenuManager menu) {
        ModelSynchronizeParticipant msp;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        IResource resource = ResourceUtil.getResource((Object)element);
        if (resource != null) {
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.Commit"));
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.AddToIndex"));
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.Ignore"));
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.MergeTool"));
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.CreatePatch"));
        } else if (element instanceof GitModelObject && selection.size() == 1) {
            this.createMenuForGitModelObject(menu, (GitModelObject)((Object)element));
        }
        IContributionItem fileGroup = this.findGroup((IContributionManager)menu, "file");
        if (fileGroup != null && (msp = (ModelSynchronizeParticipant)this.getConfiguration().getParticipant()).hasCompareInputFor(element)) {
            menu.appendToGroup(fileGroup.getId(), (IAction)this.openWorkingFileAction);
        }
    }

    private void createMenuForGitModelObject(IMenuManager menu, GitModelObject object) {
        if (SupportedContextActionsHelper.canCommit(object)) {
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.Commit"));
        }
        if (SupportedContextActionsHelper.canUseMergeTool(object)) {
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.MergeTool"));
        }
        if (SupportedContextActionsHelper.canStage(object)) {
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.AddToIndex"));
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.Ignore"));
        }
        if (SupportedContextActionsHelper.canPush(object)) {
            menu.appendToGroup(GIT_ACTIONS, (IContributionItem)this.createItem("org.eclipse.egit.ui.team.Push"));
        }
    }

    private CommandContributionItem createItem(String itemAction) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        CommandContributionItemParameter itemParam = new CommandContributionItemParameter((IServiceLocator)workbench, null, itemAction, 8);
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IHandlerService hsr = CommonUtils.getService((IServiceLocator)activeWorkbenchWindow, IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        ctx.addVariable("activeMenuSelection", (Object)this.getContext().getSelection());
        return new CommandContributionItem(itemParam);
    }

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ExpandAllModelAction expandAllAction = new ExpandAllModelAction(UIText.GitActionContributor_ExpandAll, configuration);
        expandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "navigate", (IAction)expandAllAction);
        PullAction pullAction = new PullAction(UIText.GitActionContributor_Pull, configuration);
        pullAction.setImageDescriptor(UIIcons.PULL);
        this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "synchronize", (IAction)pullAction);
        PushAction pushAction = new PushAction(UIText.GitActionContributor_Push, configuration);
        pushAction.setImageDescriptor(UIIcons.PUSH);
        this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "synchronize", (IAction)pushAction);
        ISynchronizePageSite site = configuration.getSite();
        IWorkbenchSite ws = site.getWorkbenchSite();
        this.openWorkingFileAction = new OpenWorkingFileAction(ws.getWorkbenchWindow().getActivePage());
        site.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.openWorkingFileAction);
        if (ws instanceof IViewSite) {
            Object oldAction = configuration.getProperty("org.eclipse.team.ui.P_OPEN_ACTION");
            if (!(oldAction instanceof Action)) {
                return;
            }
            GitOpenInCompareAction openInCompareAction = new GitOpenInCompareAction(configuration, (Action)oldAction);
            configuration.setProperty("org.eclipse.team.ui.P_OPEN_ACTION", (Object)openInCompareAction);
        }
    }
}

