/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.property;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BasePropertySource;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TraceEventPropertySource
extends BasePropertySource {
    public static final String TRACE_EVENT_NAME_PROPERTY_ID = "trace.event.name";
    public static final String TRACE_EVENT_TYPE_PROPERTY_ID = "trace.event.type";
    public static final String TRACE_EVENT_LOGLEVEL_PROPERTY_ID = "trace.event.loglevel";
    public static final String TRACE_EVENT_STATE_PROPERTY_ID = "trace.event.state";
    public static final String TRACE_EVENT_FILTER_PROPERTY_ID = "trace.event.filter";
    public static final String TRACE_EVENT_NAME_PROPERTY_NAME = Messages.TraceControl_EventNamePropertyName;
    public static final String TRACE_EVENT_TYPE_PROPERTY_NAME = Messages.TraceControl_EventTypePropertyName;
    public static final String TRACE_EVENT_LOGLEVEL_PROPERTY_NAME = Messages.TraceControl_LogLevelPropertyName;
    public static final String TRACE_EVENT_STATE_PROPERTY_NAME = Messages.TraceControl_StatePropertyName;
    public static final String TRACE_EVENT_FILTER_PROPERTY_NAME = Messages.TraceControl_FilterPropertyName;
    protected final TraceEventComponent fEvent;

    public TraceEventPropertySource(TraceEventComponent component) {
        this.fEvent = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<ReadOnlyTextPropertyDescriptor> list = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_NAME_PROPERTY_ID, TRACE_EVENT_NAME_PROPERTY_NAME));
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_TYPE_PROPERTY_ID, TRACE_EVENT_TYPE_PROPERTY_NAME));
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_STATE_PROPERTY_ID, TRACE_EVENT_STATE_PROPERTY_NAME));
        if (this.fEvent.getLogLevel() != TraceLogLevel.LEVEL_UNKNOWN) {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_LOGLEVEL_PROPERTY_ID, TRACE_EVENT_LOGLEVEL_PROPERTY_NAME));
        }
        if (this.fEvent.getFilterExpression() != null) {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_EVENT_FILTER_PROPERTY_ID, TRACE_EVENT_FILTER_PROPERTY_NAME));
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TRACE_EVENT_NAME_PROPERTY_ID.equals(id)) {
            return this.fEvent.getName();
        }
        if (TRACE_EVENT_TYPE_PROPERTY_ID.equals(id)) {
            return this.fEvent.getEventType().name();
        }
        if (TRACE_EVENT_LOGLEVEL_PROPERTY_ID.equals(id)) {
            StringBuffer buffer = new StringBuffer();
            if (this.fEvent.getLogLevelType() != LogLevelType.LOGLEVEL_NONE) {
                buffer.append(this.fEvent.getLogLevelType().getShortName()).append(' ');
            }
            buffer.append(this.fEvent.getLogLevel().name());
            return buffer.toString();
        }
        if (TRACE_EVENT_STATE_PROPERTY_ID.equals(id)) {
            return this.fEvent.getState().name();
        }
        if (TRACE_EVENT_FILTER_PROPERTY_ID.equals(id)) {
            return this.fEvent.getFilterExpression();
        }
        return null;
    }
}

