/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.dialog;

import java.io.File;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.dialog.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OpenGCDialog
extends Dialog {
    private Text binText;
    private String binValue;
    private boolean openCoverageSummary = true;
    private Label errorLabel;
    private boolean binaryValid;
    private final String defaultValue;
    private final IPath gcFile;

    public OpenGCDialog(Shell parentShell, String binPath, IPath gcFile) {
        super(parentShell);
        this.gcFile = gcFile;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultValue = binPath;
    }

    public String getBinaryFile() {
        return this.binValue;
    }

    public boolean isCompleteCoverageResultWanted() {
        return this.openCoverageSummary;
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.validateBinary();
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.OpenGCDialog_open_results);
        Composite composite = (Composite)super.createDialogArea(parent);
        Group c = new Group(composite, 0);
        c.setText(Messages.OpenGCDialog_bin_group_header);
        c.setToolTipText(Messages.OpenGCDialog_bin_group_tooltip);
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        c.setLayoutData((Object)data);
        Label binLabel = new Label((Composite)c, 0);
        binLabel.setText(Messages.OpenGCDialog_bin_group_label);
        data = new GridData();
        data.horizontalSpan = 2;
        binLabel.setLayoutData((Object)data);
        this.binText = new Text((Composite)c, 2048);
        this.binText.setText(this.defaultValue);
        data = new GridData(768);
        data.widthHint = 200;
        this.binText.setLayoutData((Object)data);
        this.binText.addModifyListener((ModifyListener)new BinaryModifyListener());
        Composite cbBin = new Composite((Composite)c, 0);
        data = new GridData(128);
        cbBin.setLayoutData((Object)data);
        cbBin.setLayout((Layout)new GridLayout(2, true));
        Button binBrowseWorkspaceButton = new Button(cbBin, 8);
        binBrowseWorkspaceButton.setText(Messages.OpenGCDialog_bin_browser_button_text);
        binBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGCDialog.this.handleBrowseWorkspace(Messages.OpenGCDialog_bin_browser_handler_text, OpenGCDialog.this.binText);
            }
        });
        Button binBrowseFileSystemButton = new Button(cbBin, 8);
        binBrowseFileSystemButton.setText(Messages.OpenGCDialog_bin_browser_fs_button_text);
        binBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGCDialog.this.handleBrowse(Messages.OpenGCDialog_bin_browser_handler_text, OpenGCDialog.this.binText);
            }
        });
        Group covMode = new Group(composite, 0);
        covMode.setText(Messages.OpenGCDialog_coverage_mode_header);
        covMode.setToolTipText(Messages.OpenGCDialog_coverage_mode_tooltip);
        GridData covModeData = new GridData(1808);
        covMode.setLayoutData((Object)covModeData);
        covMode.setLayout((Layout)new GridLayout());
        Button openThisFileOnlyButton = new Button((Composite)covMode, 16);
        openThisFileOnlyButton.setLayoutData((Object)new GridData());
        final Button openCoverageSummaryButton = new Button((Composite)covMode, 16);
        openCoverageSummaryButton.setLayoutData((Object)new GridData());
        String cFile = String.valueOf(this.gcFile.removeFileExtension().lastSegment()) + ".c";
        openThisFileOnlyButton.setText(NLS.bind((String)Messages.OpenGCDialog_open_file_button_text, (Object)cFile));
        openCoverageSummaryButton.setText(Messages.OpenGCDialog_summ_button_text);
        openCoverageSummaryButton.setSelection(true);
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGCDialog.this.openCoverageSummary = openCoverageSummaryButton.getSelection();
            }
        };
        openCoverageSummaryButton.addSelectionListener((SelectionListener)sa);
        openThisFileOnlyButton.addSelectionListener((SelectionListener)sa);
        this.errorLabel = new Label(composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.errorLabel.setLayoutData((Object)data);
        this.errorLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        c.layout();
        return composite;
    }

    private void validateBinary() {
        this.binValue = this.binText.getText();
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            this.binValue = mgr.performStringSubstitution(this.binValue, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        File f = new File(this.binValue);
        if (f.exists()) {
            IBinaryParser.IBinaryObject binary = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(this.binValue));
            if (binary == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.OpenGCDialog_invalid_bin_error_title, (String)NLS.bind((String)Messages.OpenGCDialog_invalid_bin_error_message, (Object)this.binText.getText()));
                return;
            }
        } else {
            this.binaryValid = false;
            this.getButton(0).setEnabled(false);
            if (!this.binValue.isEmpty()) {
                this.errorLabel.setText(NLS.bind((String)Messages.OpenGCDialog_bin_dne_error_label, (Object)this.binText.getText()));
            } else {
                this.errorLabel.setText(Messages.OpenGCDialog_no_bin_error_label);
            }
            return;
        }
        this.binaryValid = true;
        this.getButton(0).setEnabled(this.binaryValid);
        this.errorLabel.setText("");
    }

    protected void handleBrowseWorkspace(String msg, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(msg);
        dialog.setMessage(msg);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(false);
        IContainer c = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.gcFile);
        if (c != null) {
            dialog.setInitialSelection((Object)c.getProject());
        }
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1) {
                    return new Status(4, "org.eclipse.linuxtools.gcov.core", 0, "", null);
                }
                if (!(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.linuxtools.gcov.core", 0, "", null);
                }
                return new Status(0, "org.eclipse.linuxtools.gcov.core", 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            text.setText("${resource_loc:" + resource.getFullPath() + "}");
        }
    }

    protected void handleBrowse(String msg, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(msg);
        String t = text.getText();
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            t = mgr.performStringSubstitution(t, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        File f = new File(t);
        t = f.getParent();
        if (t == null || t.length() == 0) {
            t = this.gcFile.removeLastSegments(1).toOSString();
        }
        dialog.setFilterPath(t);
        String s = dialog.open();
        if (s != null) {
            text.setText(s);
        }
    }

    protected void okPressed() {
        IDialogSettings ds = Activator.getDefault().getDialogSettings();
        IDialogSettings defaultMapping = ds.getSection(OpenGCDialog.class.getName());
        if (defaultMapping == null) {
            defaultMapping = ds.addNewSection(OpenGCDialog.class.getName());
        }
        defaultMapping.put(this.gcFile.toOSString(), this.binValue);
        super.okPressed();
    }

    private class BinaryModifyListener
    implements ModifyListener {
        private BinaryModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            OpenGCDialog.this.validateBinary();
        }
    }
}

