/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.tabs;

import org.eclipse.cdt.debug.mi.internal.ui.GDBDebuggerPage;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class RemoteGDBDebuggerPage
extends GDBDebuggerPage {
    protected Text fGDBServerCommandText;
    protected Text fGDBServerPortNumberText;

    public String getName() {
        return Messages.Remote_GDB_Debugger_Options;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        configuration.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        String gdbserverCommand = null;
        String gdbserverPortNumber = null;
        try {
            gdbserverCommand = configuration.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            gdbserverPortNumber = configuration.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fGDBServerCommandText.setText(gdbserverCommand);
        this.fGDBServerPortNumberText.setText(gdbserverPortNumber);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String str = this.fGDBServerCommandText.getText();
        str.trim();
        configuration.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, str);
        str = this.fGDBServerPortNumberText.getText();
        str.trim();
        configuration.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, str);
    }

    protected void createGdbserverSettingsTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.Gdbserver_Settings_Tab_Name);
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = new Composite(comp, 0);
        subComp.setLayout((Layout)new GridLayout(2, true));
        subComp.setLayoutData((Object)new GridData(1808));
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label label = new Label(subComp, 16384);
        label.setText(Messages.Gdbserver_name_textfield_label);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBServerCommandText = new Text(subComp, 2052);
        GridData data = new GridData();
        this.fGDBServerCommandText.setLayoutData((Object)data);
        this.fGDBServerCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteGDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(subComp, 16384);
        label.setText(Messages.Port_number_textfield_label);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBServerPortNumberText = new Text(subComp, 2052);
        data = new GridData();
        this.fGDBServerPortNumberText.setLayoutData((Object)data);
        this.fGDBServerPortNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteGDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void createTabs(TabFolder tabFolder) {
        super.createTabs(tabFolder);
        this.createGdbserverSettingsTab(tabFolder);
    }
}

