/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractUIActivator
extends AbstractUIPlugin {
    private static AbstractUIActivator fgInstance;
    protected boolean fIsDebugging;

    public static AbstractUIActivator getInstance() {
        return fgInstance;
    }

    public abstract String getBundleId();

    public AbstractUIActivator() {
        fgInstance = this;
        this.fIsDebugging = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(this.getBundleId()) + "/debug")));
    }

    public void start(BundleContext context) throws Exception {
        if (this.isDebugging()) {
            System.out.println(String.valueOf(this.getBundleId()) + ".start()");
        }
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.isDebugging()) {
            System.out.println(String.valueOf(this.getBundleId()) + ".stop()");
        }
    }

    public boolean isDebugging() {
        return this.fIsDebugging;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        String str = name.toLowerCase();
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(str);
        if (imageDescriptor == null) {
            imageDescriptor = this.declareImage(str);
        }
        return imageDescriptor;
    }

    public Image getImage(String name) {
        String str = name.toLowerCase();
        Image image = this.getImageRegistry().get(str);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = this.declareImage(str);
        if (imageDescriptor == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        image = this.getImageRegistry().get(str);
        return image;
    }

    protected ImageDescriptor declareImage(String name) {
        ImageDescriptor imageDescriptor;
        Path path;
        Path pathx = path = new Path("icons/", name);
        String extension = ((IPath)path).getFileExtension();
        if (extension == null || extension.isEmpty()) {
            pathx = ((IPath)path).addFileExtension("png");
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundleId(), (String)((IPath)pathx).toString())) == null) {
            if (extension == null || extension.isEmpty()) {
                pathx = ((IPath)path).addFileExtension("gif");
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundleId(), (String)((IPath)pathx).toString());
            }
            if (imageDescriptor == null) {
                return null;
            }
        }
        try {
            String key = this.getKey(name);
            if (this.getImageRegistry().getDescriptor(key) == null) {
                this.getImageRegistry().put(key, imageDescriptor);
            }
        }
        catch (Exception e) {
            AbstractUIActivator.log(e);
        }
        return imageDescriptor;
    }

    private String getKey(String name) {
        return name.toLowerCase();
    }

    public static void log(IStatus status) {
        AbstractUIActivator.getInstance().getLog().log(status);
    }

    public static void log(Throwable e) {
        AbstractUIActivator.log((IStatus)new Status(4, AbstractUIActivator.getInstance().getBundleId(), 1, "Internal Error", e));
    }

    public static void log(String message) {
        AbstractUIActivator.log((IStatus)new Status(4, AbstractUIActivator.getInstance().getBundleId(), 1, message, null));
    }
}

