/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;

public class StringUtils {
    public static String join(String[] strArray, String joiner) {
        assert (strArray != null);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (i > 0) {
                sb.append(joiner);
            }
            sb.append(item.trim());
            ++i;
            ++n2;
        }
        return sb.toString();
    }

    public static long convertHexLong(String hex) {
        boolean isNegative = false;
        if (hex.startsWith("+")) {
            hex = hex.substring(1);
        } else if (hex.startsWith("-")) {
            hex = hex.substring(1);
            isNegative = true;
        }
        if (hex.startsWith("0x") || hex.startsWith("0X")) {
            hex = hex.substring(2);
        }
        long value = Long.valueOf("0" + hex, 16);
        if (isNegative) {
            value = -value;
        }
        return value;
    }

    public static String capitalizeFirst(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public static String cosmetiseUrl(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return String.valueOf(url) + "/";
    }

    public static String convertSizeToString(int size) {
        String sizeString = size < 1024 ? String.valueOf(String.valueOf(size)) + "B" : (size < 0x100000 ? String.valueOf(String.valueOf((size + 512) / 1024)) + "kB" : String.valueOf(String.valueOf((size + 524288) / 0x100000)) + "MB");
        return sizeString;
    }

    public static String duplicateBackslashes(String str) {
        if (str.indexOf(92) < 0) {
            return str;
        }
        String[] sa = str.split("\\\\\\\\");
        int i = 0;
        while (i < sa.length) {
            sa[i] = sa[i].replaceAll("\\\\", "\\\\\\\\");
            ++i;
        }
        str = StringUtils.join(sa, "\\\\");
        return str;
    }

    public static String extractNameFromPath(String str) {
        if (str == null) {
            return null;
        }
        Path path = new Path(str);
        String ret = path.lastSegment();
        if (ret != null) {
            return ret;
        }
        return str;
    }

    public static List<String> splitCommandLineOptions(String str) {
        ArrayList<String> lst = new ArrayList<String>();
        SplitState state = SplitState.None;
        char quote = '\u0000';
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (state) {
                case None: {
                    if (ch == '\"' || ch == '\'') {
                        quote = ch;
                        sb.setLength(0);
                        state = SplitState.InString;
                        break;
                    }
                    if (ch == ' ' || ch == '\n' || ch == '\r') break;
                    sb.setLength(0);
                    sb.append(ch);
                    state = SplitState.InOption;
                    break;
                }
                case InOption: {
                    if (ch != ' ' && ch != '\n' && ch != '\r') {
                        sb.append(ch);
                        break;
                    }
                    lst.add(sb.toString());
                    state = SplitState.None;
                    break;
                }
                case InString: {
                    if (ch != quote) {
                        sb.append(ch);
                        break;
                    }
                    lst.add(sb.toString());
                    state = SplitState.None;
                    quote = '\u0000';
                }
            }
            ++i;
        }
        if (state == SplitState.InOption || state == SplitState.InString) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static int compareNumericVersions(String v1, String v2) {
        String[] v1digits = v1.split("\\.");
        String[] v2digits = v2.split("\\.");
        int i = 0;
        while (i < v1digits.length && i < v2digits.length) {
            int d2;
            int d1 = Integer.parseInt(v1digits[i]);
            if (d1 < (d2 = Integer.parseInt(v2digits[i]))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            ++i;
        }
        if (v1digits.length < v2digits.length) {
            return -1;
        }
        if (v1digits.length > v2digits.length) {
            return 1;
        }
        return 0;
    }

    private static enum SplitState {
        None,
        InOption,
        InString;

    }
}

