/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.TaskAttachmentPage;
import org.eclipse.ui.IEditorInput;

public abstract class AbstractRepositoryConnectorUi {
    private static final String LABEL_TASK_DEFAULT = Messages.AbstractRepositoryConnectorUi_Task;
    private final boolean customNotificationHandling = false;
    private final AbstractRepositoryConnector connector;

    public AbstractRepositoryConnectorUi(AbstractRepositoryConnector connector) {
        this.connector = connector;
    }

    public AbstractRepositoryConnectorUi() {
        this(null);
    }

    @NonNull
    public abstract String getConnectorKind();

    @NonNull
    public abstract ITaskRepositoryPage getSettingsPage(@Nullable TaskRepository var1);

    @NonNull
    public abstract IWizard getQueryWizard(@NonNull TaskRepository var1, @Nullable IRepositoryQuery var2);

    @NonNull
    public abstract IWizard getNewTaskWizard(@NonNull TaskRepository var1, @Nullable ITaskMapping var2);

    @Nullable
    public IWizard getNewSubTaskWizard(@NonNull TaskRepository taskRepository, @NonNull ITask parentTask) {
        return null;
    }

    @NonNull
    public String getTaskEditorId(@NonNull ITask repositoryTask) {
        return "org.eclipse.mylyn.tasks.ui.editors.task";
    }

    @NonNull
    public IEditorInput getTaskEditorInput(@NonNull TaskRepository repository, @NonNull ITask task) {
        return new TaskEditorInput(repository, task);
    }

    public abstract boolean hasSearchPage();

    @Deprecated
    @NonNull
    public List<ITask> getLegendItems() {
        return Collections.emptyList();
    }

    @NonNull
    public List<LegendElement> getLegendElements() {
        return Collections.emptyList();
    }

    @NonNull
    public String getTaskKindLabel(@Nullable ITask task) {
        return LABEL_TASK_DEFAULT;
    }

    @Nullable
    public ImageDescriptor getImageDescriptor(@NonNull IRepositoryElement element) {
        if (element instanceof RepositoryQuery) {
            return ((RepositoryQuery)element).getAutoUpdate() ? TasksUiImages.QUERY : TasksUiImages.QUERY_OFFLINE;
        }
        if (element instanceof ITask) {
            return TasksUiImages.TASK;
        }
        return null;
    }

    @Nullable
    public ImageDescriptor getTaskKindOverlay(@NonNull ITask task) {
        return null;
    }

    @NonNull
    public ImageDescriptor getTaskPriorityOverlay(@NonNull ITask task) {
        return TasksUiInternal.getPriorityImage(task);
    }

    @Deprecated
    @Nullable
    public IWizard getAddExistingTaskWizard(@Nullable TaskRepository repository) {
        return null;
    }

    @Nullable
    public ITaskSearchPage getSearchPage(@NonNull TaskRepository repository, @Nullable IStructuredSelection selection) {
        return null;
    }

    @Nullable
    public String getAccountCreationUrl(@NonNull TaskRepository taskRepository) {
        return null;
    }

    @Nullable
    public String getAccountManagementUrl(@NonNull TaskRepository taskRepository) {
        return null;
    }

    @Nullable
    public String getTaskHistoryUrl(@NonNull TaskRepository taskRepository, @NonNull ITask task) {
        return null;
    }

    @Nullable
    public String getReplyText(@NonNull TaskRepository taskRepository, @NonNull ITask task, @Nullable ITaskComment taskComment, boolean includeTask) {
        if (taskComment == null) {
            return Messages.AbstractRepositoryConnectorUi_InReplyToDescription;
        }
        if (includeTask) {
            return MessageFormat.format(Messages.AbstractRepositoryConnectorUi_InReplyToTaskAndComment, task.getTaskKey(), taskComment.getNumber());
        }
        return MessageFormat.format(Messages.AbstractRepositoryConnectorUi_InReplyToComment, taskComment.getNumber());
    }

    @Deprecated
    @Nullable
    public IHyperlink[] findHyperlinks(@NonNull TaskRepository repository, @NonNull String text, int index, int textOffset) {
        return null;
    }

    public boolean hasCustomNotifications() {
        return false;
    }

    public boolean hasStrictSubtaskHierarchy() {
        return false;
    }

    @NonNull
    public IWizardPage getTaskAttachmentPage(@NonNull TaskAttachmentModel model) {
        return new TaskAttachmentPage(model);
    }

    @Nullable
    public IHyperlink[] findHyperlinks(@NonNull TaskRepository repository, @Nullable ITask task, @NonNull String text, int index, int textOffset) {
        return this.findHyperlinks(repository, text, index, textOffset);
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }
}

