/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTraceFolderElementHandler
extends AbstractHandler {
    private TreeSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfTraceElement || element instanceof TmfTraceFolder) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    private static DeleteType getDeleteType(ISelection selection) {
        int numTracesFolder = 0;
        int numTraceFolder = 0;
        int numTraces = 0;
        int numTracesUnderExperiment = 0;
        for (Object next : (IStructuredSelection)selection) {
            if (next instanceof TmfTracesFolder) {
                ++numTracesFolder;
                continue;
            }
            if (next instanceof TmfTraceFolder) {
                ++numTraceFolder;
                continue;
            }
            if (!(next instanceof TmfTraceElement)) continue;
            TmfTraceElement traceElement = (TmfTraceElement)next;
            if (traceElement.getParent() instanceof TmfExperimentElement) {
                ++numTracesUnderExperiment;
                continue;
            }
            ++numTraces;
        }
        int total = numTraceFolder + numTracesFolder + numTracesUnderExperiment + numTraces;
        if (numTracesFolder == total) {
            return DeleteType.CLEAR_TRACES_FOLDER;
        }
        if (numTraceFolder == total) {
            return DeleteType.DELETE_TRACE_FOLDERS;
        }
        if (numTraces == total) {
            return DeleteType.DELETE_TRACES;
        }
        if (numTracesUnderExperiment == total) {
            return DeleteType.REMOVE_TRACES_FROM_EXPERIMENT;
        }
        return DeleteType.DELETE_GENERIC;
    }

    private static String getTitle(DeleteType deleteType) {
        switch (deleteType) {
            case DELETE_TRACE_FOLDERS: 
            case DELETE_TRACES: 
            case DELETE_GENERIC: {
                return Messages.DeleteDialog_Title;
            }
            case CLEAR_TRACES_FOLDER: {
                return Messages.ClearDialog_Title;
            }
            case REMOVE_TRACES_FROM_EXPERIMENT: {
                return Messages.RemoveDialog_Title;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getMessage(DeleteType deleteType) {
        switch (deleteType) {
            case DELETE_GENERIC: {
                return Messages.DeleteTraceHandlerGeneric_Message;
            }
            case DELETE_TRACES: {
                return Messages.DeleteTraceHandler_Message;
            }
            case CLEAR_TRACES_FOLDER: {
                return Messages.DeleteFolderHandlerClear_Message;
            }
            case DELETE_TRACE_FOLDERS: {
                return Messages.DeleteFolderHandler_Message;
            }
            case REMOVE_TRACES_FROM_EXPERIMENT: {
                return Messages.RemoveTraceFromExperimentHandler_Message;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getTraceErrorMessage(DeleteType deleteType) {
        return deleteType == DeleteType.REMOVE_TRACES_FROM_EXPERIMENT ? Messages.RemoveTraceFromExperimentHandler_Error : Messages.DeleteFolderHandler_Error;
    }

    private static String getFolderErrorMessage(DeleteType deleteType) {
        return deleteType == DeleteType.CLEAR_TRACES_FOLDER ? Messages.DeleteFolderHandlerClear_Error : Messages.DeleteFolderHandler_Error;
    }

    private static String getTraceTaskName(DeleteType deleteType) {
        return deleteType == DeleteType.REMOVE_TRACES_FROM_EXPERIMENT ? Messages.RemoveTraceFromExperimentHandler_TaskName : Messages.DeleteFolderHandler_TaskName;
    }

    private static String getTraceFolderTaskName(DeleteType deleteType) {
        return deleteType == DeleteType.CLEAR_TRACES_FOLDER ? Messages.DeleteFolderHandlerClear_TaskName : Messages.DeleteFolderHandler_TaskName;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        final DeleteType deleteType = DeleteTraceFolderElementHandler.getDeleteType(selection);
        Shell shell = window.getShell();
        MessageBox confirmOperation = new MessageBox(shell, 292);
        confirmOperation.setText(DeleteTraceFolderElementHandler.getTitle(deleteType));
        confirmOperation.setMessage(DeleteTraceFolderElementHandler.getMessage(deleteType));
        if (confirmOperation.open() != 32) {
            return null;
        }
        final Iterator iterator = this.fSelection.iterator();
        final int nbElements = this.fSelection.size();
        TmfWorkspaceModifyOperation operation = new TmfWorkspaceModifyOperation(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)nbElements);
                while (iterator.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    Object element = iterator.next();
                    SubProgressMonitor elementSubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                    if (element instanceof TmfTraceElement) {
                        final TmfTraceElement trace = (TmfTraceElement)element;
                        if (!trace.getResource().exists()) continue;
                        subMonitor.setTaskName(String.valueOf(DeleteTraceFolderElementHandler.getTraceTaskName(deleteType)) + " " + trace.getElementPath());
                        try {
                            SubMonitor deleteSubMonitor = SubMonitor.convert((IProgressMonitor)elementSubMonitor, (int)1);
                            trace.delete((IProgressMonitor)deleteSubMonitor);
                        }
                        catch (CoreException e) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                                    mb.setText(String.valueOf(DeleteTraceFolderElementHandler.getTraceErrorMessage(deleteType)) + ' ' + trace.getName());
                                    mb.setMessage(e.getMessage());
                                    mb.open();
                                }
                            });
                            Activator.getDefault().logError(String.valueOf(DeleteTraceFolderElementHandler.getTraceErrorMessage(deleteType)) + trace.getName(), e);
                        }
                    } else if (element instanceof TmfTraceFolder) {
                        final TmfTraceFolder folder = (TmfTraceFolder)element;
                        IFolder resource = folder.getResource();
                        if (!resource.exists()) continue;
                        subMonitor.setTaskName(String.valueOf(DeleteTraceFolderElementHandler.getTraceFolderTaskName(deleteType)) + " " + folder.getPath());
                        try {
                            SubMonitor childrenSubMonitor = SubMonitor.convert((IProgressMonitor)elementSubMonitor, (int)(folder.getTraces().size() + 1));
                            for (TmfTraceElement traceElement : folder.getTraces()) {
                                SubProgressMonitor deleteSubMonitor = new SubProgressMonitor((IProgressMonitor)childrenSubMonitor, 1);
                                traceElement.delete((IProgressMonitor)deleteSubMonitor);
                            }
                            SubProgressMonitor deleteSubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                            if (folder instanceof TmfTracesFolder) {
                                resource.accept(new IResourceVisitor((IResource)resource, deleteSubMonitor){
                                    private final /* synthetic */ IResource val$resource;
                                    private final /* synthetic */ SubProgressMonitor val$deleteSubMonitor;
                                    {
                                        this.val$resource = iResource;
                                        this.val$deleteSubMonitor = subProgressMonitor;
                                    }

                                    public boolean visit(IResource visitedResource) throws CoreException {
                                        if (visitedResource != this.val$resource) {
                                            visitedResource.delete(true, (IProgressMonitor)this.val$deleteSubMonitor);
                                        }
                                        return true;
                                    }
                                }, 1, 0);
                            } else {
                                resource.delete(true, (IProgressMonitor)deleteSubMonitor);
                            }
                            childrenSubMonitor.done();
                        }
                        catch (CoreException e) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                                    mb.setText(String.valueOf(DeleteTraceFolderElementHandler.getFolderErrorMessage(deleteType)) + ' ' + folder.getName());
                                    mb.setMessage(e.getMessage());
                                    mb.open();
                                }
                            });
                            Activator.getDefault().logError(String.valueOf(DeleteTraceFolderElementHandler.getFolderErrorMessage(deleteType)) + folder.getName(), e);
                        }
                    }
                    subMonitor.setTaskName("");
                    elementSubMonitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)e.toString(), (String)e.getTargetException().toString());
            return null;
        }
        return null;
    }

    private static enum DeleteType {
        DELETE_TRACE_FOLDERS,
        DELETE_TRACES,
        DELETE_GENERIC,
        CLEAR_TRACES_FOLDER,
        REMOVE_TRACES_FROM_EXPERIMENT;

    }
}

