/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.handlers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SelectElementTypeContributionItem
extends CompoundContributionItem {
    private static final ImageDescriptor SELECTED_ICON = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/bullet.gif");
    private static final String BUNDLE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.bundle";
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";
    private static final String ICON_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.icon";
    private static final String SELECT_TRACE_TYPE_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.select_trace_type";
    private static final String DEFAULT_TRACE_ICON_PATH = "icons/elcl16/trace.gif";

    protected IContributionItem[] getContributionItems() {
        HashSet<String> selectedTraceTypes = new HashSet<String>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        boolean forTraces = false;
        boolean forExperiments = false;
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)element;
                    selectedTraceTypes.add(trace.getTraceType());
                    forTraces = true;
                    continue;
                }
                if (!(element instanceof TmfExperimentElement)) continue;
                TmfExperimentElement exp = (TmfExperimentElement)element;
                selectedTraceTypes.add(exp.getTraceType());
                forExperiments = true;
            }
        }
        if (forTraces && forExperiments) {
            throw new RuntimeException("You must select only experiments or only traces to set the element type");
        }
        return this.getContributionItems(selectedTraceTypes, forExperiments);
    }

    protected IContributionItem[] getContributionItems(Set<String> selectedTraceTypes, boolean forExperiments) {
        MenuManager subMenu;
        String label;
        String traceTypeId;
        String traceBundle;
        IConfigurationElement ce;
        IConfigurationElement[] config;
        String ceType = forExperiments ? "experiment" : "type";
        TmfTraceType.TraceElementType elementType = forExperiments ? TmfTraceType.TraceElementType.EXPERIMENT : TmfTraceType.TraceElementType.TRACE;
        LinkedList<IContributionItem> list = new LinkedList<IContributionItem>();
        HashMap<String, MenuManager> categoriesMap = new HashMap<String, MenuManager>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.core.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("category")) {
                String categoryId = ce.getAttribute("id");
                ImageDescriptor icon = SelectElementTypeContributionItem.isSelectedCategory(categoryId, config, selectedTraceTypes) ? SELECTED_ICON : null;
                MenuManager subMenu2 = new MenuManager(ce.getAttribute("name"), icon, null);
                categoriesMap.put(categoryId, subMenu2);
                list.add((IContributionItem)subMenu2);
            }
            ++n2;
        }
        iConfigurationElementArray = config;
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            if (ce.getName().equals(ceType)) {
                String traceBundle2 = ce.getContributor().getName();
                String traceTypeId2 = ce.getAttribute("id");
                String label2 = ce.getAttribute("name").replaceAll("&", "&&");
                boolean selected = selectedTraceTypes.contains(traceTypeId2);
                MenuManager subMenu3 = (MenuManager)categoriesMap.get(ce.getAttribute("category"));
                String traceIcon = null;
                IConfigurationElement uiCE = TmfTraceTypeUIUtils.getTraceUIAttributes(traceTypeId2, elementType);
                if (uiCE != null) {
                    traceIcon = uiCE.getAttribute("icon");
                }
                SelectElementTypeContributionItem.addContributionItem(list, traceBundle2, traceTypeId2, traceIcon, label2, selected, subMenu3);
            }
            ++n2;
        }
        Comparator<IContributionItem> comparator = new Comparator<IContributionItem>(){

            @Override
            public int compare(IContributionItem o1, IContributionItem o2) {
                if (o1 instanceof MenuManager) {
                    if (o2 instanceof MenuManager) {
                        MenuManager m1 = (MenuManager)o1;
                        MenuManager m2 = (MenuManager)o2;
                        return m1.getMenuText().compareTo(m2.getMenuText());
                    }
                    return -1;
                }
                if (o2 instanceof MenuManager) {
                    return 1;
                }
                CommandContributionItem c1 = (CommandContributionItem)o1;
                CommandContributionItem c2 = (CommandContributionItem)o2;
                return c1.getData().label.compareTo(c2.getData().label);
            }
        };
        if (forExperiments) {
            Collections.sort(list, comparator);
            return list.toArray(new IContributionItem[list.size()]);
        }
        CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n3 = customTxtTraceDefinitionArray.length;
        n = 0;
        while (n < n3) {
            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n];
            traceBundle = Activator.getDefault().getBundle().getSymbolicName();
            traceTypeId = CustomTxtTrace.buildTraceTypeId((String)def.categoryName, (String)def.definitionName);
            String traceIcon = DEFAULT_TRACE_ICON_PATH;
            label = def.definitionName;
            boolean selected = selectedTraceTypes.contains(traceTypeId);
            subMenu = SelectElementTypeContributionItem.getCategorySubMenu(list, categoriesMap, def.categoryName, selected);
            SelectElementTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            ++n;
        }
        customTxtTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n3 = customTxtTraceDefinitionArray.length;
        n = 0;
        while (n < n3) {
            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n];
            traceBundle = Activator.getDefault().getBundle().getSymbolicName();
            traceTypeId = CustomXmlTrace.buildTraceTypeId((String)def.categoryName, (String)def.definitionName);
            String traceIcon = DEFAULT_TRACE_ICON_PATH;
            label = def.definitionName;
            boolean selected = selectedTraceTypes.contains(traceTypeId);
            subMenu = SelectElementTypeContributionItem.getCategorySubMenu(list, categoriesMap, def.categoryName, selected);
            SelectElementTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            ++n;
        }
        Collections.sort(list, comparator);
        return list.toArray(new IContributionItem[list.size()]);
    }

    private static MenuManager getCategorySubMenu(List<IContributionItem> list, Map<String, MenuManager> categoriesMap, String categoryName, boolean selected) {
        for (Map.Entry<String, MenuManager> entry : categoriesMap.entrySet()) {
            MenuManager subMenu = entry.getValue();
            if (!subMenu.getMenuText().equals(categoryName)) continue;
            if (selected) {
                subMenu.setImageDescriptor(SELECTED_ICON);
            }
            return subMenu;
        }
        ImageDescriptor icon = selected ? SELECTED_ICON : null;
        MenuManager subMenu = new MenuManager(categoryName, icon, null);
        categoriesMap.put(categoryName, subMenu);
        list.add((IContributionItem)subMenu);
        return subMenu;
    }

    private static void addContributionItem(List<IContributionItem> list, String traceBundle, String traceTypeId, String traceIcon, String label, boolean selected, MenuManager subMenu) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(BUNDLE_PARAMETER, traceBundle);
        params.put(TYPE_PARAMETER, traceTypeId);
        params.put(ICON_PARAMETER, traceIcon);
        ImageDescriptor icon = null;
        if (selected) {
            icon = SELECTED_ICON;
        }
        CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "my.parameterid", SELECT_TRACE_TYPE_COMMAND_ID, 8);
        param.parameters = params;
        param.icon = icon;
        param.disabledIcon = icon;
        param.hoverIcon = icon;
        param.label = label;
        param.visibleEnabled = true;
        if (subMenu != null) {
            subMenu.add((IContributionItem)new CommandContributionItem(param));
        } else {
            list.add((IContributionItem)new CommandContributionItem(param));
        }
    }

    private static boolean isSelectedCategory(String categoryId, IConfigurationElement[] config, Set<String> selectedTraceTypes) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String traceTypeId;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("type") && selectedTraceTypes.contains(traceTypeId = ce.getAttribute("id")) && categoryId.equals(ce.getAttribute("category"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

