/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import org.eclipse.tracecompass.common.core.NonNullUtils;

class FileAndName
implements Comparable<FileAndName> {
    private final File fFile;
    private String fTraceTypeId;
    private String fName;
    private boolean fConflict;

    public FileAndName(File f, String n) {
        this.fFile = f;
        this.fName = n;
        this.fTraceTypeId = null;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setTraceTypeId(String elem) {
        this.fTraceTypeId = elem;
    }

    public String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    public File getFile() {
        return this.fFile;
    }

    public void setConflictingName(boolean conflict) {
        this.fConflict = conflict;
    }

    public boolean isConflictingName() {
        return this.fConflict;
    }

    public boolean isRenamed() {
        return !this.fName.equals(this.fFile.getName());
    }

    @Override
    public int compareTo(FileAndName o) {
        int retVal = this.getFile().compareTo(o.getFile());
        if (retVal == 0 && this.getTraceTypeId() != null && o.getTraceTypeId() != null) {
            retVal = this.getTraceTypeId().compareTo(o.getTraceTypeId());
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fTraceTypeId == null ? 0 : this.fTraceTypeId.hashCode());
        result = 31 * result + (this.fFile == null ? 0 : this.fFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileAndName)) {
            return false;
        }
        FileAndName other = (FileAndName)obj;
        if (!NonNullUtils.equalsNullable((Object)this.fTraceTypeId, (Object)other.fTraceTypeId)) {
            return false;
        }
        return NonNullUtils.equalsNullable((Object)this.fFile, (Object)other.fFile);
    }
}

