/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfStyledProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.osgi.framework.Bundle;

public class TmfAnalysisElement
extends TmfProjectModelElement
implements ITmfStyledProjectModelElement {
    private static final StyledString.Styler ANALYSIS_CANT_EXECUTE_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
        }
    };
    @NonNull
    private final IAnalysisModuleHelper fAnalysisHelper;
    private boolean fCanExecute = true;

    protected TmfAnalysisElement(String name, IResource resource, ITmfProjectModelElement parent, @NonNull IAnalysisModuleHelper module) {
        super(name, resource, parent);
        this.fAnalysisHelper = module;
        parent.addChild(this);
    }

    @Override
    void refreshChildren() {
        ITmfProjectModelElement parent;
        this.fCanExecute = true;
        HashMap<String, TmfAnalysisOutputElement> childrenMap = new HashMap<String, TmfAnalysisOutputElement>();
        for (TmfAnalysisOutputElement output : this.getAvailableOutputs()) {
            childrenMap.put(output.getName(), output);
        }
        IPath path = this.getProject().getTracesFolder().getPath();
        if (this.fResource instanceof IFolder) {
            path = ((IFolder)this.fResource).getFullPath();
        }
        if ((parent = this.getParent()) instanceof TmfCommonProjectElement) {
            ITmfTrace trace = ((TmfCommonProjectElement)parent).getTrace();
            if (trace == null) {
                this.deleteOutputs();
                return;
            }
            IAnalysisModule module = trace.getAnalysisModule(this.fAnalysisHelper.getId());
            if (module == null) {
                this.deleteOutputs();
                this.fCanExecute = false;
                return;
            }
            for (IAnalysisOutput output : module.getOutputs()) {
                TmfAnalysisOutputElement outputElement = (TmfAnalysisOutputElement)childrenMap.remove(output.getName());
                if (outputElement == null) {
                    IFolder newresource = ResourcesPlugin.getWorkspace().getRoot().getFolder(path.append(output.getName()));
                    outputElement = new TmfAnalysisOutputElement(output.getName(), (IResource)newresource, this, output);
                }
                outputElement.refreshChildren();
            }
        }
        for (TmfAnalysisOutputElement output : childrenMap.values()) {
            this.removeChild(output);
        }
    }

    @Override
    public StyledString.Styler getStyler() {
        if (!this.fCanExecute) {
            return ANALYSIS_CANT_EXECUTE_STYLER;
        }
        return null;
    }

    public List<TmfAnalysisOutputElement> getAvailableOutputs() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfAnalysisOutputElement> outputs = new ArrayList<TmfAnalysisOutputElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfAnalysisOutputElement)) continue;
            outputs.add((TmfAnalysisOutputElement)child);
        }
        return outputs;
    }

    public String getAnalysisId() {
        return this.fAnalysisHelper.getId();
    }

    public String getHelpMessage() {
        IAnalysisModule module;
        TmfTraceElement traceElement;
        ITmfProjectModelElement parent = this.getParent();
        ITmfTrace trace = null;
        if (parent instanceof TmfTraceElement && (trace = (traceElement = (TmfTraceElement)parent).getTrace()) != null && (module = trace.getAnalysisModule(this.fAnalysisHelper.getId())) != null) {
            return module.getHelpText(trace);
        }
        if (trace != null) {
            return this.fAnalysisHelper.getHelpText(trace);
        }
        return this.fAnalysisHelper.getHelpText();
    }

    public String getIconFile() {
        return this.fAnalysisHelper.getIcon();
    }

    public Bundle getBundle() {
        return this.fAnalysisHelper.getBundle();
    }

    private void deleteOutputs() {
        for (TmfAnalysisOutputElement output : this.getAvailableOutputs()) {
            this.removeChild(output);
        }
    }

    public void activateParent() {
        ITmfProjectModelElement parent = this.getParent();
        if (parent instanceof TmfTraceElement) {
            TmfTraceElement traceElement = (TmfTraceElement)parent;
            TmfOpenTraceHelper.openTraceFromElement(traceElement);
        }
    }
}

