/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphCombo;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;

public abstract class AbstractTimeGraphView
extends TmfView
implements ITmfTimeAligned {
    protected static final int ALL_LEVELS = -1;
    private ITimeGraphWrapper fTimeGraphWrapper;
    private ITmfTrace fTrace;
    private List<TimeGraphEntry> fEntryList;
    private final Map<ITmfTrace, List<TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private final Map<ITmfTrace, ViewerFilter[]> fFiltersMap = new HashMap<ITmfTrace, ViewerFilter[]>();
    private final Map<ITmfTrace, BuildThread> fBuildThreadMap = new HashMap<ITmfTrace, BuildThread>();
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private Comparator<ITimeGraphEntry> fEntryComparator = null;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private final TimeGraphPresentationProvider fPresentation;
    private String[] fColumns;
    private TreeLabelProvider fLabelProvider = null;
    @NonNull
    private ITimeGraphContentProvider fTimeGraphContentProvider = new TimeGraphContentProvider();
    private int[] fWeight = new int[]{1, 3};
    private String[] fFilterColumns;
    private boolean fPackDone = false;
    private ITreeContentProvider fFilterContentProvider;
    private TreeLabelProvider fFilterLabelProvider;
    private int fAutoExpandLevel = -1;

    public AbstractTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id);
        this.fPresentation = pres;
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    protected TimeGraphCombo getTimeGraphCombo() {
        if (this.fTimeGraphWrapper instanceof TimeGraphComboWrapper) {
            return ((TimeGraphComboWrapper)this.fTimeGraphWrapper).getTimeGraphCombo();
        }
        return null;
    }

    protected TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphWrapper.getTimeGraphViewer();
    }

    protected ITimeGraphPresentationProvider2 getPresentationProvider() {
        return this.fPresentation;
    }

    protected void setTreeColumns(String[] columns) {
        this.checkPartNotCreated();
        this.fColumns = columns;
    }

    protected void setTreeLabelProvider(TreeLabelProvider tlp) {
        this.checkPartNotCreated();
        this.fLabelProvider = tlp;
    }

    protected void setTimeGraphContentProvider(@NonNull ITimeGraphContentProvider tgcp) {
        this.checkPartNotCreated();
        this.fTimeGraphContentProvider = tgcp;
    }

    protected void setWeight(int[] weights) {
        this.checkPartNotCreated();
        this.fWeight = weights;
    }

    protected void setFilterColumns(String[] filterColumns) {
        this.checkPartNotCreated();
        this.fFilterColumns = filterColumns;
    }

    protected void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.checkPartNotCreated();
        this.fFilterContentProvider = contentProvider;
    }

    protected void setFilterLabelProvider(TreeLabelProvider labelProvider) {
        this.checkPartNotCreated();
        this.fFilterLabelProvider = labelProvider;
    }

    private void checkPartNotCreated() {
        if (this.getParentComposite() != null) {
            throw new IllegalStateException("This method must be called before createPartControl.");
        }
    }

    protected int getDisplayWidth() {
        return this.fDisplayWidth;
    }

    protected Comparator<ITimeGraphEntry> getEntryComparator() {
        return this.fEntryComparator;
    }

    protected void setEntryComparator(Comparator<ITimeGraphEntry> comparator) {
        this.fEntryComparator = comparator;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected long getStartTime() {
        return this.fStartTime;
    }

    protected void setStartTime(long time) {
        this.fStartTime = time;
    }

    protected long getEndTime() {
        return this.fEndTime;
    }

    protected void setEndTime(long time) {
        this.fEndTime = time;
    }

    protected void setAutoExpandLevel(int level) {
        this.fAutoExpandLevel = level;
        ITimeGraphWrapper tgWrapper = this.fTimeGraphWrapper;
        if (tgWrapper != null) {
            tgWrapper.setAutoExpandLevel(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TimeGraphEntry> getEntryList(ITmfTrace trace) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            return this.fEntryListMap.get(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                entryList.addAll(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList != null) {
                entryList.removeAll(list);
            }
        }
    }

    protected String getNextText() {
        return Messages.AbstractTimeGraphtView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.AbstractTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.AbstractTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.AbstractTimeGraphView_PreviousTooltip;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fColumns == null || this.fLabelProvider == null) {
            this.fTimeGraphWrapper = new TimeGraphViewerWrapper(parent, 0);
        } else {
            TimeGraphComboWrapper wrapper = new TimeGraphComboWrapper(parent, 0);
            this.fTimeGraphWrapper = wrapper;
            TimeGraphCombo combo = wrapper.getTimeGraphCombo();
            combo.setTreeContentProvider(this.fTimeGraphContentProvider);
            combo.setTreeLabelProvider(this.fLabelProvider);
            combo.setTreeColumns(this.fColumns);
        }
        this.fTimeGraphWrapper.setTimeGraphContentProvider(this.fTimeGraphContentProvider);
        this.fTimeGraphWrapper.setFilterContentProvider((ITreeContentProvider)(this.fFilterContentProvider != null ? this.fFilterContentProvider : this.fTimeGraphContentProvider));
        this.fTimeGraphWrapper.setFilterLabelProvider(this.fFilterLabelProvider);
        this.fTimeGraphWrapper.setFilterColumns(this.fFilterColumns);
        this.fTimeGraphWrapper.setTimeGraphPresentationProvider(this.fPresentation);
        this.fTimeGraphWrapper.setAutoExpandLevel(this.fAutoExpandLevel);
        this.fTimeGraphWrapper.getTimeGraphViewer().addRangeListener(new ITimeGraphRangeListener(){

            @Override
            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime));
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)AbstractTimeGraphView.this, range));
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                TmfNanoTimestamp startTime = new TmfNanoTimestamp(event.getBeginTime());
                TmfNanoTimestamp endTime = new TmfNanoTimestamp(event.getEndTime());
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractTimeGraphView.this, (ITmfTimestamp)startTime, (ITmfTimestamp)endTime));
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().setTimeFormat(Utils.TimeFormat.CALENDAR);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeGraphWrapper.getTimeGraphViewer().getTimeGraphControl().setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.getSite().setSelectionProvider(this.fTimeGraphWrapper.getSelectionProvider());
    }

    public void setFocus() {
        this.fTimeGraphWrapper.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.loadTrace(signal.getTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        Map<ITmfTrace, Object> map = this.fBuildThreadMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(signal.getTrace())) {
                BuildThread buildThread = this.fBuildThreadMap.remove(trace);
                if (buildThread == null) continue;
                buildThread.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(signal.getTrace());
        }
        this.fFiltersMap.remove(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fStartTime = -1L;
            this.fEndTime = -1L;
            if (this.fZoomThread != null) {
                this.fZoomThread.cancel();
                this.fZoomThread = null;
            }
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        final long beginTime = signal.getBeginTime().normalize(0L, -9).getValue();
        final long endTime = signal.getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectedTime(beginTime, true);
                } else {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectionRange(beginTime, endTime, true);
                }
                AbstractTimeGraphView.this.synchingToTime(AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().getSelectionBegin());
            }
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void updateTimeFormat(TmfTimestampFormatUpdateSignal signal) {
        this.fTimeGraphWrapper.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace(ITmfTrace trace) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
        if (this.fTrace != null) {
            this.fFiltersMap.put(this.fTrace, this.fTimeGraphWrapper.getFilters());
        }
        this.fTrace = trace;
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                this.rebuild();
            } else {
                this.fStartTime = this.fTrace.getStartTime().normalize(0L, -9).getValue();
                this.fEndTime = this.fTrace.getEndTime().normalize(0L, -9).getValue();
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuild() {
        this.setStartTime(Long.MAX_VALUE);
        this.setEndTime(Long.MIN_VALUE);
        this.refresh();
        ITmfTrace viewTrace = this.fTrace;
        if (viewTrace == null) {
            return;
        }
        Map<ITmfTrace, BuildThread> map = this.fBuildThreadMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                if (trace == null) break;
                BuildThread buildThread = new BuildThread(trace, viewTrace, this.getName());
                this.fBuildThreadMap.put(trace, buildThread);
                buildThread.start();
            }
        }
    }

    protected void synchingToTime(long time) {
    }

    @NonNull
    protected Iterable<ITmfTrace> getTracesToBuild(@NonNull ITmfTrace trace) {
        return TmfTraceManager.getTraceSet((ITmfTrace)trace);
    }

    protected abstract void buildEventList(@NonNull ITmfTrace var1, @NonNull ITmfTrace var2, @NonNull IProgressMonitor var3);

    @Nullable
    protected abstract List<ITimeEvent> getEventList(@NonNull TimeGraphEntry var1, long var2, long var4, long var6, @NonNull IProgressMonitor var8);

    @Nullable
    protected List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected void refresh() {
        final boolean zoomThread = Thread.currentThread() instanceof ZoomThread;
        TmfUiRefreshHandler.getInstance().queueUpdate(this, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean inputChanged;
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                boolean hasEntries = false;
                Map map = AbstractTimeGraphView.this.fEntryListMap;
                synchronized (map) {
                    AbstractTimeGraphView.this.fEntryList = (List)AbstractTimeGraphView.this.fEntryListMap.get(AbstractTimeGraphView.this.fTrace);
                    if (AbstractTimeGraphView.this.fEntryList == null) {
                        AbstractTimeGraphView.this.fEntryList = new CopyOnWriteArrayList();
                    } else if (AbstractTimeGraphView.this.fEntryComparator != null) {
                        ArrayList list = new ArrayList(AbstractTimeGraphView.this.fEntryList);
                        Collections.sort(list, AbstractTimeGraphView.this.fEntryComparator);
                        for (ITimeGraphEntry entry : list) {
                            AbstractTimeGraphView.sortChildren(entry, AbstractTimeGraphView.this.fEntryComparator);
                        }
                        AbstractTimeGraphView.this.fEntryList.clear();
                        AbstractTimeGraphView.this.fEntryList.addAll(list);
                    }
                    hasEntries = !AbstractTimeGraphView.this.fEntryList.isEmpty();
                }
                boolean bl = inputChanged = AbstractTimeGraphView.this.fEntryList != AbstractTimeGraphView.this.fTimeGraphWrapper.getInput();
                if (inputChanged) {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.setInput(AbstractTimeGraphView.this.fEntryList);
                    AbstractTimeGraphView.this.fTimeGraphWrapper.setFilters((ViewerFilter[])AbstractTimeGraphView.this.fFiltersMap.get(AbstractTimeGraphView.this.fTrace));
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setLinks(null);
                } else {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.refresh();
                }
                long startBound = AbstractTimeGraphView.this.fStartTime == Long.MAX_VALUE ? -1L : AbstractTimeGraphView.this.fStartTime;
                long endBound = AbstractTimeGraphView.this.fEndTime == Long.MIN_VALUE ? -1L : AbstractTimeGraphView.this.fEndTime;
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setTimeBounds(startBound, endBound);
                TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                long selectionBeginTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getSelectionRange().getStartTime().normalize(0L, -9).getValue();
                long selectionEndTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getSelectionRange().getEndTime().normalize(0L, -9).getValue();
                long startTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getWindowRange().getStartTime().normalize(0L, -9).getValue();
                long endTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getWindowRange().getEndTime().normalize(0L, -9).getValue();
                startTime = AbstractTimeGraphView.this.fStartTime == Long.MAX_VALUE ? -1L : Math.max(startTime, AbstractTimeGraphView.this.fStartTime);
                endTime = AbstractTimeGraphView.this.fEndTime == Long.MIN_VALUE ? -1L : Math.min(endTime, AbstractTimeGraphView.this.fEndTime);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectionRange(selectionBeginTime, selectionEndTime, false);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                if (inputChanged && selectionBeginTime != -1L) {
                    AbstractTimeGraphView.this.synchingToTime(selectionBeginTime);
                }
                if (AbstractTimeGraphView.this.fTimeGraphWrapper instanceof TimeGraphComboWrapper && !AbstractTimeGraphView.this.fPackDone) {
                    TreeColumn[] treeColumnArray = ((TimeGraphComboWrapper)AbstractTimeGraphView.this.fTimeGraphWrapper).getTreeViewer().getTree().getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn column = treeColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                    if (hasEntries) {
                        AbstractTimeGraphView.this.fPackDone = true;
                    }
                }
                if (!zoomThread) {
                    AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.redraw();
                AbstractTimeGraphView.this.fTimeGraphWrapper.update();
                Object object = AbstractTimeGraphView.this.fSyncObj;
                synchronized (object) {
                    if (AbstractTimeGraphView.this.fRedrawState == State.PENDING) {
                        AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                        AbstractTimeGraphView.this.redraw();
                    } else {
                        AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private static void sortChildren(ITimeGraphEntry entry, Comparator<ITimeGraphEntry> comparator) {
        if (entry instanceof TimeGraphEntry) {
            ((TimeGraphEntry)entry).sortChildren(comparator);
        }
        for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
            AbstractTimeGraphView.sortChildren(iTimeGraphEntry, comparator);
        }
    }

    protected void startZoomThread(long startTime, long endTime) {
        boolean restart = false;
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            if (this.fZoomThread.fZoomStartTime == startTime && this.fZoomThread.fZoomEndTime == endTime) {
                restart = true;
            }
        }
        long resolution = Math.max(1L, (endTime - startTime) / (long)this.fDisplayWidth);
        this.fZoomThread = this.createZoomThread(startTime, endTime, resolution, restart);
        if (this.fZoomThread != null) {
            this.fZoomThread.start();
        }
    }

    @Nullable
    protected ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        List<TimeGraphEntry> entryList = this.fEntryList;
        if (entryList == null) {
            return null;
        }
        return new ZoomThreadByEntry(entryList, startTime, endTime, resolution);
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousResourceAction.setText(this.getPrevText());
        this.fPreviousResourceAction.setToolTipText(this.getPrevTooltip());
        this.fNextResourceAction = this.fTimeGraphWrapper.getTimeGraphViewer().getNextItemAction();
        this.fNextResourceAction.setText(this.getNextText());
        this.fNextResourceAction.setToolTipText(this.getNextTooltip());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.fFilterColumns != null && this.fFilterLabelProvider != null && this.fFilterColumns.length > 0) {
            manager.add(this.fTimeGraphWrapper.getShowFilterDialogAction());
        }
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getNextEventAction());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fTimeGraphWrapper == null) {
            return null;
        }
        return this.fTimeGraphWrapper.getTimeViewAlignmentInfo();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        if (this.fTimeGraphWrapper == null) {
            return 0;
        }
        return this.fTimeGraphWrapper.getAvailableWidth(requestedOffset);
    }

    @Override
    public void performAlign(int offset, int width) {
        if (this.fTimeGraphWrapper != null) {
            this.fTimeGraphWrapper.performAlign(offset, width);
        }
    }

    private class BuildThread
    extends Thread {
        @NonNull
        private final ITmfTrace fBuildTrace;
        @NonNull
        private final ITmfTrace fParentTrace;
        @NonNull
        private final IProgressMonitor fMonitor;

        public BuildThread(@NonNull ITmfTrace trace, ITmfTrace parentTrace, String name) {
            super(String.valueOf(name) + " build");
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractTimeGraphView.this.buildEventList(this.fBuildTrace, this.fParentTrace, this.fMonitor);
            Map map = AbstractTimeGraphView.this.fBuildThreadMap;
            synchronized (map) {
                AbstractTimeGraphView.this.fBuildThreadMap.remove(this.fBuildTrace);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    private static interface ITimeGraphWrapper {
        public void setTimeGraphContentProvider(ITimeGraphContentProvider var1);

        public void setTimeGraphPresentationProvider(TimeGraphPresentationProvider var1);

        public TimeGraphViewer getTimeGraphViewer();

        public void addSelectionListener(ITimeGraphSelectionListener var1);

        public ISelectionProvider getSelectionProvider();

        public void setFocus();

        public boolean isDisposed();

        public void refresh();

        public void setInput(Object var1);

        public Object getInput();

        public void setFilters(ViewerFilter[] var1);

        public ViewerFilter[] getFilters();

        public void redraw();

        public void update();

        public void setAutoExpandLevel(int var1);

        public void setFilterColumns(String[] var1);

        public void setFilterContentProvider(ITreeContentProvider var1);

        public void setFilterLabelProvider(ITableLabelProvider var1);

        public IAction getShowFilterDialogAction();

        public void performAlign(int var1, int var2);

        public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo();

        public int getAvailableWidth(int var1);
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class TimeGraphComboWrapper
    implements ITimeGraphWrapper {
        private TimeGraphCombo combo;

        private TimeGraphComboWrapper(Composite parent, int style) {
            this.combo = new TimeGraphCombo(parent, style, AbstractTimeGraphView.this.fWeight);
        }

        @Override
        public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
            this.combo.setTimeGraphContentProvider(timeGraphContentProvider);
        }

        @Override
        public void setTimeGraphPresentationProvider(TimeGraphPresentationProvider timeGraphPresentationProvider) {
            this.combo.setTimeGraphProvider(timeGraphPresentationProvider);
        }

        @Override
        public TimeGraphViewer getTimeGraphViewer() {
            return this.combo.getTimeGraphViewer();
        }

        @Override
        public void addSelectionListener(ITimeGraphSelectionListener listener) {
            this.combo.addSelectionListener(listener);
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return this.combo.getTreeViewer();
        }

        @Override
        public void setFocus() {
            this.combo.setFocus();
        }

        @Override
        public boolean isDisposed() {
            return this.combo.isDisposed();
        }

        @Override
        public void setInput(Object input) {
            this.combo.setInput(input);
        }

        @Override
        public Object getInput() {
            return this.combo.getInput();
        }

        @Override
        public void setFilterColumns(String[] columnNames) {
            this.combo.setFilterColumns(columnNames);
        }

        @Override
        public void setFilterContentProvider(ITreeContentProvider contentProvider) {
            this.combo.setFilterContentProvider(contentProvider);
        }

        @Override
        public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
            this.combo.setFilterLabelProvider(labelProvider);
        }

        @Override
        public void setFilters(ViewerFilter[] filters) {
            this.combo.setFilters(filters);
        }

        @Override
        public ViewerFilter[] getFilters() {
            return this.combo.getFilters();
        }

        @Override
        public IAction getShowFilterDialogAction() {
            return this.combo.getShowFilterDialogAction();
        }

        @Override
        public void refresh() {
            this.combo.refresh();
        }

        @Override
        public void redraw() {
            this.combo.redraw();
        }

        @Override
        public void update() {
            this.combo.update();
        }

        @Override
        public void setAutoExpandLevel(int level) {
            this.combo.setAutoExpandLevel(level);
        }

        TimeGraphCombo getTimeGraphCombo() {
            return this.combo;
        }

        TreeViewer getTreeViewer() {
            return this.combo.getTreeViewer();
        }

        @Override
        public void performAlign(int offset, int width) {
            this.combo.performAlign(offset, width);
        }

        @Override
        public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
            return this.combo.getTimeViewAlignmentInfo();
        }

        @Override
        public int getAvailableWidth(int requestedOffset) {
            return this.combo.getAvailableWidth(requestedOffset);
        }
    }

    private class TimeGraphViewerWrapper
    implements ITimeGraphWrapper {
        private TimeGraphViewer viewer;

        private TimeGraphViewerWrapper(Composite parent, int style) {
            this.viewer = new TimeGraphViewer(parent, style);
        }

        @Override
        public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
            this.viewer.setTimeGraphContentProvider(timeGraphContentProvider);
        }

        @Override
        public void setTimeGraphPresentationProvider(TimeGraphPresentationProvider timeGraphPresentationProvider) {
            this.viewer.setTimeGraphProvider(timeGraphPresentationProvider);
        }

        @Override
        public TimeGraphViewer getTimeGraphViewer() {
            return this.viewer;
        }

        @Override
        public void addSelectionListener(ITimeGraphSelectionListener listener) {
            this.viewer.addSelectionListener(listener);
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return this.viewer.getSelectionProvider();
        }

        @Override
        public void setFocus() {
            this.viewer.setFocus();
        }

        @Override
        public boolean isDisposed() {
            return this.viewer.getControl().isDisposed();
        }

        @Override
        public void setInput(Object input) {
            this.viewer.setInput(input);
        }

        @Override
        public Object getInput() {
            return this.viewer.getInput();
        }

        @Override
        public void setFilterColumns(String[] columnNames) {
            this.viewer.setFilterColumns(columnNames);
        }

        @Override
        public void setFilterContentProvider(ITreeContentProvider contentProvider) {
            this.viewer.setFilterContentProvider(contentProvider);
        }

        @Override
        public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
            this.viewer.setFilterLabelProvider(labelProvider);
        }

        @Override
        public void setFilters(ViewerFilter[] filters) {
            this.viewer.setFilters(filters);
        }

        @Override
        public ViewerFilter[] getFilters() {
            return this.viewer.getFilters();
        }

        @Override
        public IAction getShowFilterDialogAction() {
            return this.viewer.getShowFilterDialogAction();
        }

        @Override
        public void refresh() {
            this.viewer.refresh();
        }

        @Override
        public void redraw() {
            this.viewer.getControl().redraw();
        }

        @Override
        public void update() {
            this.viewer.getControl().update();
        }

        @Override
        public void setAutoExpandLevel(int level) {
            this.viewer.setAutoExpandLevel(level);
        }

        @Override
        public void performAlign(int offset, int width) {
            this.viewer.performAlign(offset, width);
        }

        @Override
        public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
            return this.viewer.getTimeViewAlignmentInfo();
        }

        @Override
        public int getAvailableWidth(int requestedOffset) {
            return this.viewer.getAvailableWidth(requestedOffset);
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return new String();
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            return entry.getName();
        }
    }

    protected abstract class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        @NonNull
        private final IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime, long resolution) {
            super(String.valueOf(AbstractTimeGraphView.this.getName()) + " zoom");
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fMonitor = new NullProgressMonitor();
        }

        public long getZoomStartTime() {
            return this.fZoomStartTime;
        }

        public long getZoomEndTime() {
            return this.fZoomEndTime;
        }

        public long getResolution() {
            return this.fResolution;
        }

        @NonNull
        public IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    private class ZoomThreadByEntry
    extends ZoomThread {
        @NonNull
        private final List<TimeGraphEntry> fZoomEntryList;

        public ZoomThreadByEntry(List<TimeGraphEntry> entryList, long startTime, long endTime, long resolution) {
            super(startTime, endTime, resolution);
            this.fZoomEntryList = entryList;
        }

        @Override
        public void run() {
            for (TimeGraphEntry entry : this.fZoomEntryList) {
                if (this.getMonitor().isCanceled()) {
                    return;
                }
                if (entry == null) break;
                this.zoom(entry, this.getMonitor());
            }
            List<ILinkEvent> events = AbstractTimeGraphView.this.getLinkList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            if (events != null) {
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setLinks(events);
                AbstractTimeGraphView.this.redraw();
            }
        }

        private void zoom(@NonNull TimeGraphEntry entry, @NonNull IProgressMonitor monitor) {
            if (this.getZoomStartTime() <= AbstractTimeGraphView.this.fStartTime && this.getZoomEndTime() >= AbstractTimeGraphView.this.fEndTime) {
                entry.setZoomedEventList(null);
            } else {
                List<ITimeEvent> list = AbstractTimeGraphView.this.getEventList(entry, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), monitor);
                if (list != null) {
                    entry.setZoomedEventList(list);
                }
            }
            AbstractTimeGraphView.this.redraw();
            for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (!(iTimeGraphEntry instanceof TimeGraphEntry)) continue;
                this.zoom((TimeGraphEntry)iTimeGraphEntry, monitor);
            }
        }
    }
}

