/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTreeExpansionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ShowFilterDialogAction;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class TimeGraphCombo
extends Composite {
    public static final int ALL_LEVELS = -1;
    private static final Object FILLER = new Object();
    private TreeViewer fTreeViewer;
    @NonNull
    private TimeGraphViewer fTimeGraphViewer;
    private final Map<ITimeGraphSelectionListener, SelectionListenerWrapper> fSelectionListenerMap = new HashMap<ITimeGraphSelectionListener, SelectionListenerWrapper>();
    private final Map<ViewerFilter, ViewerFilter> fViewerFilterMap = new HashMap<ViewerFilter, ViewerFilter>();
    private boolean fInhibitTreeSelection = false;
    private int fNumFillerRows;
    private int fLinuxItemHeight = 0;
    private ShowFilterDialogAction fShowFilterDialogAction;
    private static final int[] DEFAULT_WEIGHTS = new int[]{1, 1};
    private List<TreeItem> fVisibleExpandedItems = null;
    private Listener fSashDragListener;
    private SashForm fSashForm;
    private final boolean fScrollBarsInTreeWorkaround;

    public TimeGraphCombo(Composite parent, int style) {
        this(parent, style, DEFAULT_WEIGHTS);
    }

    public TimeGraphCombo(Composite parent, int style, int[] weights) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.fSashForm = new SashForm((Composite)this, 0);
        this.fScrollBarsInTreeWorkaround = "win32".equals(SWT.getPlatform());
        int scrollBarStyle = this.fScrollBarsInTreeWorkaround ? 256 : 272;
        this.fTreeViewer = new TreeViewer((Composite)this.fSashForm, 0x10000 | scrollBarStyle);
        this.fTreeViewer.setAutoExpandLevel(-1);
        final Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fTimeGraphViewer = new TimeGraphViewer((Composite)this.fSashForm, 0);
        this.fTimeGraphViewer.setItemHeight(this.getItemHeight(tree));
        this.fTimeGraphViewer.setHeaderHeight(tree.getHeaderHeight());
        this.fTimeGraphViewer.setBorderWidth(tree.getBorderWidth());
        this.fTimeGraphViewer.setNameWidthPref(0);
        if (this.fScrollBarsInTreeWorkaround) {
            tree.addControlListener((ControlListener)new ControlAdapter(){
                private int depth = 0;

                public void controlResized(ControlEvent e) {
                    if (this.depth == 0) {
                        ++this.depth;
                        tree.getVerticalBar().setEnabled(false);
                        tree.getVerticalBar().setVisible(false);
                        --this.depth;
                    }
                }
            });
        }
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int headerHeight = tree.getHeaderHeight();
                if (headerHeight > 0) {
                    TimeGraphCombo.this.fTimeGraphViewer.setHeaderHeight(headerHeight);
                    tree.removePaintListener((PaintListener)this);
                }
            }
        });
        this.fTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                TimeGraphCombo.this.fTimeGraphViewer.setExpandedState((ITimeGraphEntry)event.getElement(), false);
                TimeGraphCombo.this.fVisibleExpandedItems = null;
                TimeGraphCombo.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimeGraphCombo.this.alignTreeItems(true);
                    }
                });
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ITimeGraphEntry entry = (ITimeGraphEntry)event.getElement();
                TimeGraphCombo.this.fTimeGraphViewer.setExpandedState(entry, true);
                HashSet<Object> expandedElements = new HashSet<Object>(Arrays.asList(TimeGraphCombo.this.fTreeViewer.getExpandedElements()));
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    if (!iTimeGraphEntry.hasChildren()) continue;
                    boolean expanded = expandedElements.contains(iTimeGraphEntry);
                    TimeGraphCombo.this.fTimeGraphViewer.setExpandedState(iTimeGraphEntry, expanded);
                }
                TimeGraphCombo.this.fVisibleExpandedItems = null;
                TimeGraphCombo.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimeGraphCombo.this.alignTreeItems(true);
                    }
                });
            }
        });
        this.fTimeGraphViewer.addTreeListener(new ITimeGraphTreeListener(){

            @Override
            public void treeCollapsed(TimeGraphTreeExpansionEvent event) {
                TimeGraphCombo.this.fTreeViewer.setExpandedState((Object)event.getEntry(), false);
                TimeGraphCombo.this.alignTreeItems(true);
            }

            @Override
            public void treeExpanded(TimeGraphTreeExpansionEvent event) {
                ITimeGraphEntry entry = event.getEntry();
                TimeGraphCombo.this.fTreeViewer.setExpandedState((Object)entry, true);
                HashSet<Object> expandedElements = new HashSet<Object>(Arrays.asList(TimeGraphCombo.this.fTreeViewer.getExpandedElements()));
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    if (!iTimeGraphEntry.hasChildren()) continue;
                    boolean expanded = expandedElements.contains(iTimeGraphEntry);
                    TimeGraphCombo.this.fTimeGraphViewer.setExpandedState(iTimeGraphEntry, expanded);
                }
                TimeGraphCombo.this.alignTreeItems(true);
            }
        });
        tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
                if (treeItem == null || treeItem.getData() == FILLER) {
                    event.doit = false;
                    List treeItems = TimeGraphCombo.this.getVisibleExpandedItems(tree, false);
                    if (treeItems.size() == 0) {
                        TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                        TimeGraphCombo.this.fTimeGraphViewer.setSelection(null);
                        return;
                    }
                    tree.select((TreeItem)treeItems.get(treeItems.size() - 1));
                    TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                    TimeGraphCombo.this.fTimeGraphViewer.setSelection(null);
                }
            }
        });
        tree.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                Slider scrollBar = TimeGraphCombo.this.fTimeGraphViewer.getVerticalBar();
                TimeGraphCombo.this.fTimeGraphViewer.setTopIndex(scrollBar.getSelection() - event.count);
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        tree.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                List treeItems = TimeGraphCombo.this.getVisibleExpandedItems(tree, false);
                if (treeItems.size() == 0) {
                    TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                    event.doit = false;
                    return;
                }
                if (event.keyCode == 0x1000002) {
                    int index = Math.min(TimeGraphCombo.this.fTimeGraphViewer.getSelectionIndex() + 1, treeItems.size() - 1);
                    TimeGraphCombo.this.fTimeGraphViewer.setSelection((ITimeGraphEntry)((TreeItem)treeItems.get(index)).getData());
                    event.doit = false;
                } else if (event.keyCode == 0x1000006) {
                    int height = tree.getSize().y - tree.getHeaderHeight() - tree.getHorizontalBar().getSize().y;
                    int countPerPage = height / TimeGraphCombo.this.getItemHeight(tree);
                    int index = Math.min(TimeGraphCombo.this.fTimeGraphViewer.getSelectionIndex() + countPerPage - 1, treeItems.size() - 1);
                    TimeGraphCombo.this.fTimeGraphViewer.setSelection((ITimeGraphEntry)((TreeItem)treeItems.get(index)).getData());
                    event.doit = false;
                } else if (event.keyCode == 0x1000008) {
                    TimeGraphCombo.this.fTimeGraphViewer.setSelection((ITimeGraphEntry)((TreeItem)treeItems.get(treeItems.size() - 1)).getData());
                    event.doit = false;
                }
                if (TimeGraphCombo.this.fTimeGraphViewer.getSelectionIndex() >= 0) {
                    TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)TimeGraphCombo.this.fTimeGraphViewer.getSelection()));
                } else {
                    TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                }
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTimeGraphViewer.getTimeGraphControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TimeGraphCombo.this.fInhibitTreeSelection) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selection instanceof ITimeGraphEntry) {
                        TimeGraphCombo.this.fTimeGraphViewer.setSelection((ITimeGraphEntry)selection);
                    }
                    TimeGraphCombo.this.alignTreeItems(false);
                }
            }
        });
        this.fTimeGraphViewer.addSelectionListener(new ITimeGraphSelectionListener(){

            @Override
            public void selectionChanged(TimeGraphSelectionEvent event) {
                ITimeGraphEntry entry = TimeGraphCombo.this.fTimeGraphViewer.getSelection();
                TimeGraphCombo.this.fInhibitTreeSelection = true;
                if (entry != null) {
                    StructuredSelection selection = new StructuredSelection((Object)entry);
                    TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)selection);
                } else {
                    TimeGraphCombo.this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                }
                TimeGraphCombo.this.fInhibitTreeSelection = false;
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTimeGraphViewer.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTimeGraphViewer.getTimeGraphControl().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTreeViewer.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TimeGraphCombo.this.fTimeGraphViewer.getTimeGraphControl().isFocusControl()) {
                    TimeGraphCombo.this.fTreeViewer.getControl().setFocus();
                }
            }
        });
        this.fTimeGraphViewer.getTimeGraphControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TimeGraphCombo.this.fTreeViewer.getControl().isFocusControl()) {
                    TimeGraphCombo.this.fTimeGraphViewer.getTimeGraphControl().setFocus();
                }
            }
        });
        this.fTimeGraphViewer.getTimeGraphScale().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TimeGraphCombo.this.fTreeViewer.getControl().isFocusControl()) {
                    TimeGraphCombo.this.fTimeGraphViewer.getTimeGraphControl().setFocus();
                }
            }
        });
        this.fNumFillerRows = Display.getDefault().getBounds().height / this.getItemHeight(tree);
        this.fSashForm.setWeights(weights);
        this.fTimeGraphViewer.getTimeGraphControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TimeGraphCombo.this.fSashDragListener == null) {
                    Control[] controlArray = TimeGraphCombo.this.fSashForm.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            TimeGraphCombo.this.fSashDragListener = new Listener(){

                                public void handleEvent(Event event) {
                                    TimeGraphCombo.this.sendTimeViewAlignmentChanged();
                                }
                            };
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, TimeGraphCombo.this.fSashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void sendTimeViewAlignmentChanged() {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(this.fSashForm, this.getTimeViewAlignmentInfo()));
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    @NonNull
    public TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    @Deprecated
    public void showFilterDialog() {
        this.getShowFilterDialogAction().run();
    }

    @Deprecated
    public Action getShowFilterAction() {
        return this.getShowFilterDialogAction();
    }

    public ShowFilterDialogAction getShowFilterDialogAction() {
        if (this.fShowFilterDialogAction == null) {
            this.fShowFilterDialogAction = new ShowFilterDialogAction(this.fTimeGraphViewer){

                @Override
                protected void addFilter(ViewerFilter filter) {
                    TimeGraphCombo.this.addFilter(filter);
                }

                @Override
                protected void removeFilter(ViewerFilter filter) {
                    TimeGraphCombo.this.removeFilter(filter);
                }

                @Override
                protected void refresh() {
                    TimeGraphCombo.this.refresh();
                }
            };
        }
        return this.fShowFilterDialogAction;
    }

    public void redraw() {
        this.fTimeGraphViewer.getControl().redraw();
        super.redraw();
    }

    public void setTreeContentProvider(ITreeContentProvider contentProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProviderWrapper(contentProvider));
    }

    public void setTreeLabelProvider(ITableLabelProvider labelProvider) {
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProviderWrapper(labelProvider));
    }

    public void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.getShowFilterDialogAction().getFilterDialog().setContentProvider(contentProvider);
    }

    public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
        this.getShowFilterDialogAction().getFilterDialog().setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void addTimeGraphFilterCheckActiveButton(ITimeGraphEntryActiveProvider activeProvider) {
        this.getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterCheckActiveButton(activeProvider);
    }

    public void addTimeGraphFilterUncheckInactiveButton(ITimeGraphEntryActiveProvider inactiveProvider) {
        this.getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterUncheckInactiveButton(inactiveProvider);
    }

    public void setTreeColumns(String[] columnNames) {
        Tree tree = this.fTreeViewer.getTree();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(columnName);
            column.pack();
            ++n2;
        }
    }

    public void setFilterColumns(String[] columnNames) {
        this.getShowFilterDialogAction().getFilterDialog().setColumnNames(columnNames);
    }

    public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
        this.fTimeGraphViewer.setTimeGraphContentProvider(timeGraphContentProvider);
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphViewer.setTimeGraphProvider(timeGraphProvider);
    }

    public void setInput(Object input) {
        this.fInhibitTreeSelection = true;
        this.fTreeViewer.setInput(input);
        for (SelectionListenerWrapper listenerWrapper : this.fSelectionListenerMap.values()) {
            listenerWrapper.selection = null;
        }
        this.fInhibitTreeSelection = false;
        if (this.fScrollBarsInTreeWorkaround) {
            this.fTreeViewer.getTree().getVerticalBar().setEnabled(false);
            this.fTreeViewer.getTree().getVerticalBar().setVisible(false);
        }
        this.fTimeGraphViewer.setInput(input);
        this.fTimeGraphViewer.setItemHeight(this.getItemHeight(this.fTreeViewer.getTree()));
        this.fVisibleExpandedItems = null;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TimeGraphCombo.this.alignTreeItems(true);
            }
        });
    }

    public Object getInput() {
        return this.fTreeViewer.getInput();
    }

    public void setLinks(List<ILinkEvent> links) {
        this.fTimeGraphViewer.setLinks(links);
    }

    public void addFilter(ViewerFilter filter) {
        this.fInhibitTreeSelection = true;
        ViewerFilterWrapper wrapper = new ViewerFilterWrapper(filter);
        this.fTreeViewer.addFilter((ViewerFilter)wrapper);
        this.fTimeGraphViewer.addFilter(filter);
        this.fViewerFilterMap.put(filter, wrapper);
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public void removeFilter(ViewerFilter filter) {
        this.fInhibitTreeSelection = true;
        ViewerFilter wrapper = this.fViewerFilterMap.get(filter);
        this.fTreeViewer.removeFilter(wrapper);
        this.fTimeGraphViewer.removeFilter(filter);
        this.fViewerFilterMap.remove(filter);
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public ViewerFilter[] getFilters() {
        return this.fTimeGraphViewer.getFilters();
    }

    public void setFilters(ViewerFilter[] filters) {
        this.fInhibitTreeSelection = true;
        this.fViewerFilterMap.clear();
        if (filters == null) {
            this.fTreeViewer.resetFilters();
        } else {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                ViewerFilterWrapper wrapper = new ViewerFilterWrapper(filter);
                this.fViewerFilterMap.put(filter, wrapper);
                ++n2;
            }
            ViewerFilter[] wrappers = (ViewerFilter[])Iterables.toArray(this.fViewerFilterMap.values(), ViewerFilter.class);
            this.fTreeViewer.setFilters(wrappers);
        }
        this.fTimeGraphViewer.setFilters(filters);
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public void refresh() {
        this.fInhibitTreeSelection = true;
        Tree tree = this.fTreeViewer.getTree();
        try {
            tree.setRedraw(false);
            this.fTreeViewer.refresh();
        }
        finally {
            tree.setRedraw(true);
        }
        this.fTimeGraphViewer.refresh();
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public void addSelectionListener(ITimeGraphSelectionListener listener) {
        SelectionListenerWrapper listenerWrapper = new SelectionListenerWrapper(listener);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)listenerWrapper);
        this.fSelectionListenerMap.put(listener, listenerWrapper);
        this.fTimeGraphViewer.addSelectionListener(listenerWrapper);
    }

    public void removeSelectionListener(ITimeGraphSelectionListener listener) {
        SelectionListenerWrapper listenerWrapper = this.fSelectionListenerMap.remove(listener);
        this.fTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)listenerWrapper);
        this.fTimeGraphViewer.removeSelectionListener(listenerWrapper);
    }

    public void setSelection(ITimeGraphEntry selection) {
        this.fTimeGraphViewer.setSelection(selection);
        this.fInhibitTreeSelection = true;
        if (selection != null) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)selection);
            this.fTreeViewer.setSelection((ISelection)structuredSelection);
        } else {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
        }
        this.fInhibitTreeSelection = false;
        this.alignTreeItems(false);
    }

    public void setAutoExpandLevel(int level) {
        this.fTimeGraphViewer.setAutoExpandLevel(level);
        if (level <= 0) {
            this.fTreeViewer.setAutoExpandLevel(level);
        } else {
            this.fTreeViewer.setAutoExpandLevel(level + 1);
        }
    }

    public int getAutoExpandLevel() {
        return this.fTimeGraphViewer.getAutoExpandLevel();
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        this.fTimeGraphViewer.setExpandedState(entry, expanded);
        this.fTreeViewer.setExpandedState((Object)entry, expanded);
        this.alignTreeItems(true);
    }

    public void collapseAll() {
        this.fTimeGraphViewer.collapseAll();
        this.fTreeViewer.collapseAll();
        this.alignTreeItems(true);
    }

    public void expandAll() {
        this.fTimeGraphViewer.expandAll();
        this.fTreeViewer.expandAll();
        this.alignTreeItems(true);
    }

    private List<TreeItem> getVisibleExpandedItems(Tree tree, boolean refresh) {
        if (this.fVisibleExpandedItems == null || refresh) {
            ArrayList<TreeItem> visibleExpandedItems = new ArrayList<TreeItem>();
            this.addVisibleExpandedItems(visibleExpandedItems, tree.getItems());
            this.fVisibleExpandedItems = visibleExpandedItems;
        }
        return this.fVisibleExpandedItems;
    }

    private void addVisibleExpandedItems(List<TreeItem> visibleExpandedItems, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data == FILLER) break;
            visibleExpandedItems.add(item);
            boolean expandedState = this.fTimeGraphViewer.getExpandedState((ITimeGraphEntry)data);
            if (item.getExpanded() != expandedState) {
                this.fTreeViewer.setExpandedState(data, expandedState);
            }
            if (expandedState) {
                this.addVisibleExpandedItems(visibleExpandedItems, item.getItems());
            }
            ++n2;
        }
    }

    private int getItemHeight(final Tree tree) {
        if (this.fLinuxItemHeight >= 0 && System.getProperty("os.name").contains("Linux")) {
            if (this.fLinuxItemHeight != 0) {
                return this.fLinuxItemHeight;
            }
            if (this.getVisibleExpandedItems(tree, true).size() > 1) {
                PaintListener paintListener = new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        List treeItems = TimeGraphCombo.this.getVisibleExpandedItems(tree, true);
                        if (treeItems.size() < 2) {
                            return;
                        }
                        TreeItem treeItem0 = (TreeItem)treeItems.get(0);
                        TreeItem treeItem1 = (TreeItem)treeItems.get(1);
                        tree.removePaintListener((PaintListener)this);
                        int y0 = treeItem0.getBounds().y;
                        int y1 = treeItem1.getBounds().y;
                        int itemHeight = y1 - y0;
                        if (itemHeight > 0) {
                            TimeGraphCombo.this.fLinuxItemHeight = itemHeight;
                            TimeGraphCombo.this.fTimeGraphViewer.setItemHeight(itemHeight);
                        }
                    }
                };
                tree.addPaintListener(paintListener);
            }
        } else {
            this.fLinuxItemHeight = -1;
        }
        return tree.getItemHeight();
    }

    private void alignTreeItems(boolean refreshExpandedItems) {
        Tree tree = this.fTreeViewer.getTree();
        List<TreeItem> treeItems = this.getVisibleExpandedItems(tree, refreshExpandedItems);
        int topIndex = this.fTimeGraphViewer.getTopIndex();
        if (topIndex >= treeItems.size()) {
            return;
        }
        TreeItem item = treeItems.get(topIndex);
        tree.setTopItem(item);
        int treeHeight = this.fTreeViewer.getTree().getBounds().height;
        int index = topIndex;
        Rectangle bounds = item.getBounds();
        while (index < treeItems.size() - 1) {
            if (bounds.y > treeHeight) break;
            TreeItem nextItem = treeItems.get(index + 1);
            Rectangle nextBounds = nextItem.getBounds();
            Integer itemHeight = nextBounds.y - bounds.y;
            if (itemHeight > 0) {
                ITimeGraphEntry entry = (ITimeGraphEntry)item.getData();
                this.fTimeGraphViewer.getTimeGraphControl().setItemHeight(entry, itemHeight);
            }
            ++index;
            item = nextItem;
            bounds = nextBounds;
        }
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        Point location = this.fSashForm.toDisplay(0, 0);
        int timeAxisOffset = this.fTreeViewer.getControl().getSize().x + this.fSashForm.getSashWidth();
        return new TmfTimeViewAlignmentInfo(this.fSashForm.getShell(), location, timeAxisOffset);
    }

    public int getAvailableWidth(int requestedOffset) {
        int vBarWidth = this.fTimeGraphViewer.getVerticalBar() != null && this.fTimeGraphViewer.getVerticalBar().isVisible() ? this.fTimeGraphViewer.getVerticalBar().getSize().x : 0;
        int totalWidth = this.fSashForm.getBounds().width;
        return Math.min(totalWidth, Math.max(0, totalWidth - requestedOffset - vBarWidth));
    }

    public void performAlign(int offset, int width) {
        int total = this.fSashForm.getBounds().width;
        int timeAxisOffset = Math.min(offset, total);
        int width1 = Math.max(0, timeAxisOffset - this.fSashForm.getSashWidth());
        int width2 = total - timeAxisOffset;
        this.fSashForm.setWeights(new int[]{width1, width2});
        this.fSashForm.layout();
        Composite composite = this.fTimeGraphViewer.getTimeAlignedComposite();
        GridLayout layout = (GridLayout)composite.getLayout();
        int timeBasedControlsWidth = composite.getSize().x;
        int marginSize = timeBasedControlsWidth - width;
        layout.marginRight = Math.max(0, marginSize);
        composite.layout();
    }

    private class SelectionListenerWrapper
    implements ISelectionChangedListener,
    ITimeGraphSelectionListener {
        private final ITimeGraphSelectionListener listener;
        private ITimeGraphEntry selection = null;

        public SelectionListenerWrapper(ITimeGraphSelectionListener listener) {
            this.listener = listener;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITimeGraphEntry entry;
            if (TimeGraphCombo.this.fInhibitTreeSelection) {
                return;
            }
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof ITimeGraphEntry && (entry = (ITimeGraphEntry)element) != this.selection) {
                this.selection = entry;
                this.listener.selectionChanged(new TimeGraphSelectionEvent(event.getSource(), this.selection));
            }
        }

        @Override
        public void selectionChanged(TimeGraphSelectionEvent event) {
            ITimeGraphEntry entry = event.getSelection();
            if (entry != this.selection) {
                this.selection = entry;
                this.listener.selectionChanged(new TimeGraphSelectionEvent(event.getSource(), this.selection));
            }
        }
    }

    private class TreeContentProviderWrapper
    implements ITreeContentProvider {
        private final ITreeContentProvider contentProvider;

        public TreeContentProviderWrapper(ITreeContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        public void dispose() {
            this.contentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contentProvider.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.contentProvider.getElements(inputElement);
            Object[] oElements = Arrays.copyOf(elements, elements.length + TimeGraphCombo.this.fNumFillerRows, Object[].class);
            int i = 0;
            while (i < TimeGraphCombo.this.fNumFillerRows) {
                oElements[elements.length + i] = FILLER;
                ++i;
            }
            return oElements;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITimeGraphEntry) {
                return this.contentProvider.getChildren(parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ITimeGraphEntry) {
                return this.contentProvider.getParent(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITimeGraphEntry) {
                return this.contentProvider.hasChildren(element);
            }
            return false;
        }
    }

    private class TreeLabelProviderWrapper
    implements ITableLabelProvider {
        private final ITableLabelProvider labelProvider;

        public TreeLabelProviderWrapper(ITableLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.labelProvider.addListener(listener);
        }

        public void dispose() {
            this.labelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof ITimeGraphEntry) {
                return this.labelProvider.isLabelProperty(element, property);
            }
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.labelProvider.removeListener(listener);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ITimeGraphEntry) {
                return this.labelProvider.getColumnImage(element, columnIndex);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITimeGraphEntry) {
                return this.labelProvider.getColumnText(element, columnIndex);
            }
            return null;
        }
    }

    private class ViewerFilterWrapper
    extends ViewerFilter {
        private ViewerFilter fWrappedFilter;

        ViewerFilterWrapper(ViewerFilter filter) {
            this.fWrappedFilter = filter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ITimeGraphEntry) {
                return this.fWrappedFilter.select(viewer, parentElement, element);
            }
            return true;
        }
    }
}

