/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;

public abstract class TimeGraphBaseControl
extends Canvas
implements PaintListener {
    public static final int MARGIN = 4;
    public static final int EXPAND_SIZE = 9;
    public static final int RIGHT_MARGIN = 1;
    public static final int SMALL_ICON_SIZE = 16;
    private TimeGraphColorScheme fColorScheme;
    private int fFontHeight = 0;

    public TimeGraphBaseControl(Composite parent, TimeGraphColorScheme colors) {
        this(parent, colors, 786432);
    }

    public TimeGraphBaseControl(Composite parent, TimeGraphColorScheme colorScheme, int style) {
        super(parent, style);
        this.fColorScheme = colorScheme;
        this.addPaintListener(this);
    }

    public void paintControl(PaintEvent e) {
        if (e.widget != this) {
            return;
        }
        this.fFontHeight = e.gc.getFontMetrics().getHeight();
        Rectangle bound = this.getClientArea();
        if (!bound.isEmpty()) {
            Color colBackup = e.gc.getBackground();
            this.paint(bound, e);
            e.gc.setBackground(colBackup);
        }
    }

    public TimeGraphColorScheme getColorScheme() {
        return this.fColorScheme;
    }

    public int getFontHeight() {
        return this.fFontHeight;
    }

    abstract void paint(Rectangle var1, PaintEvent var2);
}

