/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.core.tree;

import ilg.gnuarmeclipse.packs.core.tree.ITreeIterator;
import ilg.gnuarmeclipse.packs.core.tree.Leaf;
import ilg.gnuarmeclipse.packs.core.tree.Node;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractTreePreOrderIterator
implements ITreeIterator {
    private Leaf fTopNode = null;
    private Leaf fCurrentNode = null;
    private Leaf fNextNode = null;

    @Override
    public void setTreeNode(Leaf node) {
        this.fTopNode = node;
        this.fCurrentNode = null;
        this.fNextNode = null;
    }

    @Override
    public Iterator<Leaf> iterator() {
        return this;
    }

    public abstract boolean isIterable(Leaf var1);

    public abstract boolean isLeaf(Leaf var1);

    @Override
    public boolean hasNext() {
        Leaf node = this.tryNext(this.fCurrentNode);
        if (node != null) {
            this.fNextNode = node;
            return true;
        }
        return false;
    }

    @Override
    public Leaf next() {
        Leaf node = this.fNextNode != null ? this.fNextNode : this.tryNext(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
            this.fNextNode = null;
            return node;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
    }

    private Leaf tryNext(Leaf node) {
        block0: do {
            if (node == null) {
                node = this.fTopNode;
                continue;
            }
            if (!this.isLeaf(node) && node.hasChildren()) {
                node = ((Node)node).getFirstChild();
                continue;
            }
            while (true) {
                Leaf sibling;
                if ((sibling = node.getNextSibling()) != null) {
                    node = sibling;
                    continue block0;
                }
                if (node.getParent() == null) break;
                node = node.getParent();
            }
            node = null;
        } while (node != null && !this.isIterable(node));
        return node;
    }
}

