/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.VMViewerUpdateTracing;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class VMChildrenUpdate
extends VMViewerUpdate
implements IChildrenUpdate {
    private final int fOffset;
    private final int fLength;
    protected final List<Object> fElements;

    public VMChildrenUpdate(IViewerUpdate clientUpdate, int offset, int length, DataRequestMonitor<List<Object>> requestMonitor) {
        super(clientUpdate, (RequestMonitor)requestMonitor);
        this.fOffset = offset;
        this.fLength = length;
        this.fElements = length > 0 ? new ArrayList<Object>(length) : new ArrayList();
    }

    public VMChildrenUpdate(IModelDelta delta, IPresentationContext presentationContext, int offset, int length, DataRequestMonitor<List<Object>> rm) {
        super(delta, presentationContext, (RequestMonitor)rm);
        this.fOffset = offset;
        this.fLength = length;
        this.fElements = length > 0 ? new ArrayList<Object>(length) : new ArrayList();
    }

    public VMChildrenUpdate(TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, int offset, int length, DataRequestMonitor<List<Object>> rm) {
        super(elementPath, viewerInput, presentationContext, (RequestMonitor)rm);
        this.fOffset = offset;
        this.fLength = length;
        this.fElements = length > 0 ? new ArrayList<Object>(length) : new ArrayList();
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setChild(Object element, int offset) {
        int idx = offset - (this.fOffset > 0 ? this.fOffset : 0);
        if (idx < 0 || this.fLength > 0 && idx >= this.fLength) {
            return;
        }
        this.ensureElementsSize(idx + 1);
        this.fElements.set(idx, element);
    }

    private void ensureElementsSize(int size) {
        while (this.fElements.size() < size) {
            this.fElements.add(null);
        }
    }

    public String toString() {
        return "VMChildrenUpdate:" + this.getElement() + " {" + this.getOffset() + "->" + (this.getOffset() + this.getLength()) + "}";
    }

    @Override
    public void done() {
        DataRequestMonitor rm = (DataRequestMonitor)this.getRequestMonitor();
        rm.setData(this.fElements);
        if (VMViewerUpdateTracing.DEBUG_VMUPDATES && !this.isCanceled() && VMViewerUpdateTracing.matchesFilterRegex(((Object)((Object)this)).getClass())) {
            StringBuilder str = new StringBuilder();
            str.append(String.valueOf(DsfPlugin.getDebugTime()) + " " + LoggingUtils.toString((Object)((Object)this)) + " marked done; element = " + LoggingUtils.toString((Object)this.getElement()));
            if (this.fElements != null && !this.fElements.isEmpty()) {
                for (Object element : this.fElements) {
                    str.append("   " + LoggingUtils.toString((Object)element) + "\n");
                }
                str.deleteCharAt(str.length() - 1);
            }
            DsfUIPlugin.debug(str.toString());
        }
        super.done();
    }
}

