/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.ITmfMipmapFeature;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public abstract class TmfMipmapFeature
implements ITmfMipmapFeature {
    protected ITmfStateValue currentValue = TmfStateValue.nullValue();
    protected long currentStartTime;
    protected List<List<ITmfStateInterval>> intervals = new ArrayList<List<ITmfStateInterval>>();
    protected ITmfStateSystemBuilder ss;
    private int mipmapResolution;
    private int mipmapQuark;
    private List<Integer> levelQuarks = new ArrayList<Integer>();

    public TmfMipmapFeature(int baseQuark, int mipmapQuark, int mipmapResolution, ITmfStateSystemBuilder ss) {
        this.mipmapQuark = mipmapQuark;
        this.mipmapResolution = mipmapResolution;
        this.ss = ss;
        this.levelQuarks.add(baseQuark);
        this.intervals.add(new ArrayList(mipmapResolution));
    }

    @Override
    public void updateMipmap(ITmfStateValue value, long ts) {
        if (this.currentValue.equals(value)) {
            return;
        }
        if (!this.currentValue.isNull()) {
            TmfStateInterval interval = new TmfStateInterval(this.currentStartTime, ts, this.getLevelQuark(0), this.currentValue);
            this.intervals.get(0).add((ITmfStateInterval)interval);
        }
        if (!value.isNull()) {
            int level = 0;
            while (this.intervals.get(level).size() == this.getMipmapResolution()) {
                this.updateMipmapLevel(++level, ts);
            }
        }
        this.currentValue = value;
        this.currentStartTime = ts;
    }

    @Override
    public void updateAndCloseMipmap() {
        if (!this.currentValue.isNull()) {
            TmfStateInterval interval = new TmfStateInterval(this.currentStartTime, this.currentStartTime, this.getLevelQuark(0), this.currentValue);
            this.intervals.get(0).add((ITmfStateInterval)interval);
        }
        int level = 1;
        while (level <= this.getNbLevels()) {
            this.updateMipmapLevel(level, this.currentStartTime);
            ++level;
        }
    }

    protected void updateMipmapLevel(int level, long endTime) {
        try {
            List<ITmfStateInterval> lowerIntervals = this.intervals.get(level - 1);
            if (lowerIntervals.size() == 0) {
                return;
            }
            long startTime = lowerIntervals.get(0).getStartTime();
            ITmfStateValue value = this.computeMipmapValue(lowerIntervals, startTime, endTime);
            lowerIntervals.clear();
            int levelQuark = this.ss.getQuarkRelativeAndAdd(this.mipmapQuark, new String[]{String.valueOf(level)});
            if (!this.checkLevelExists(level)) {
                this.addLevelQuark(levelQuark);
                this.ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueInt((int)level), this.mipmapQuark);
                this.intervals.add(new ArrayList(this.getMipmapResolution()));
            }
            TmfStateInterval interval = new TmfStateInterval(startTime, endTime, levelQuark, value);
            this.intervals.get(level).add((ITmfStateInterval)interval);
            this.ss.modifyAttribute(startTime, value, levelQuark);
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
    }

    protected abstract ITmfStateValue computeMipmapValue(List<ITmfStateInterval> var1, long var2, long var4);

    protected int getMipmapResolution() {
        return this.mipmapResolution;
    }

    protected int getMipmapQuark() {
        return this.mipmapQuark;
    }

    protected int getLevelQuark(int level) {
        return this.levelQuarks.get(level);
    }

    protected void addLevelQuark(int quark) {
        this.levelQuarks.add(quark);
    }

    protected int getNbLevels() {
        return this.levelQuarks.size() - 1;
    }

    protected boolean checkLevelExists(int level) {
        return level < this.levelQuarks.size() && level >= 0;
    }
}

