/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.callstack;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.callstack.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class CallStackStateProvider
extends AbstractTmfStateProvider {
    public static final String THREADS = "Threads";
    public static final String CALL_STACK = "CallStack";
    public static final String UNDEFINED = "UNDEFINED";
    @NonNull
    private static final String ID = "org.eclipse.linuxtools.tmf.callstack";
    private static final String NO_FUNCTION = "no function";

    public CallStackStateProvider(@NonNull ITmfTrace trace) {
        super(trace, ID);
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        if (!this.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        try {
            String functionEntryName = this.functionEntry(event);
            if (functionEntryName != null) {
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                String thread = this.getThreadName(event);
                int threadQuark = ss.getQuarkAbsoluteAndAdd(new String[]{THREADS, thread});
                Long threadId = this.getThreadId(event);
                if (threadId != null) {
                    ss.updateOngoingState((ITmfStateValue)TmfStateValue.newValueLong((long)threadId), threadQuark);
                }
                int callStackQuark = ss.getQuarkRelativeAndAdd(threadQuark, new String[]{CALL_STACK});
                TmfStateValue value = TmfStateValue.newValueString((String)functionEntryName);
                ss.pushAttribute(timestamp, (ITmfStateValue)value, callStackQuark);
                return;
            }
            String functionExitName = this.functionExit(event);
            if (functionExitName != null) {
                String poppedName;
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                String thread = this.getThreadName(event);
                int quark = ss.getQuarkAbsoluteAndAdd(new String[]{THREADS, thread, CALL_STACK});
                ITmfStateValue poppedValue = ss.popAttribute(timestamp, quark);
                String string = poppedName = poppedValue == null ? NO_FUNCTION : poppedValue.unboxStr();
                if (!functionExitName.equals(UNDEFINED) && !functionExitName.equals(poppedName)) {
                    Activator.logWarning(NLS.bind((String)Messages.CallStackStateProvider_UnmatchedPoppedValue, (Object)functionExitName, (Object)poppedName));
                }
            }
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
    }

    protected abstract boolean considerEvent(ITmfEvent var1);

    protected abstract String functionEntry(ITmfEvent var1);

    protected abstract String functionExit(ITmfEvent var1);

    protected abstract String getThreadName(ITmfEvent var1);

    protected Long getThreadId(ITmfEvent event) {
        return null;
    }
}

