/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class DStoreKeyManager
implements X509KeyManager {
    private X509KeyManager _keyManager;
    private String _defaultAlias;

    public DStoreKeyManager(X509KeyManager keyManager, String defaultAlias) {
        this._keyManager = keyManager;
        this._defaultAlias = defaultAlias;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this._defaultAlias != null) {
            return this._defaultAlias;
        }
        return this._keyManager.chooseClientAlias(keyType, issuers, socket);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this._defaultAlias != null) {
            return this._defaultAlias;
        }
        return this._keyManager.chooseServerAlias(keyType, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this._keyManager.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this._keyManager.getClientAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this._keyManager.getPrivateKey(alias);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this._keyManager.getServerAliases(keyType, issuers);
    }
}

