/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.core;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CProjectPacksStorage {
    public static final String STORAGE_NAME = "ilg.gnuarmeclipse.managedbuild.packs";
    public static final String DEVICE_NAME = "cmsis.device.name";
    public static final String DEVICE_VENDOR_NAME = "cmsis.device.vendor.name";
    public static final String DEVICE_VENDOR_ID = "cmsis.device.vendor.id";
    public static final String FAMILY_NAME = "cmsis.family.name";
    public static final String SUBFAMILY_NAME = "cmsis.subfamily.name";
    public static final String CORE_NAME = "cmsis.core.name";
    public static final String COMPILER_DEFINE = "cmsis.compiler.define";
    public static final String DEVICE_PACK_VENDOR = "cmsis.device.pack.vendor";
    public static final String DEVICE_PACK_NAME = "cmsis.device.pack.name";
    public static final String DEVICE_PACK_VERSION = "cmsis.device.pack.version";
    public static final String BOARD_NAME = "cmsis.board.name";
    public static final String BOARD_REVISION = "cmsis.board.revision";
    public static final String BOARD_VENDOR_NAME = "cmsis.board.vendor.name";
    public static final String BOARD_CLOCK = "cmsis.board.clock";
    public static final String BOARD_PACK_VENDOR = "cmsis.board.pack.vendor";
    public static final String BOARD_PACK_NAME = "cmsis.board.pack.name";
    public static final String BOARD_PACK_VERSION = "cmsis.board.pack.version";
    private ICStorageElement fStorage;
    private Configuration fConfig;

    public CProjectPacksStorage(IConfiguration config) throws CoreException {
        if (!(config instanceof Configuration)) {
            throw new CoreException((IStatus)new Status(4, "ilg.gnuarmeclipse.core", "ConfigStorage() requires Configuration"));
        }
        this.fConfig = (Configuration)config;
        ICConfigurationDescription configDesc = this.fConfig.getConfigurationDescription();
        this.fStorage = configDesc.getStorage(STORAGE_NAME, true);
    }

    public void update() {
    }

    public void clear() {
        this.fStorage.clear();
    }

    public Map<String, String> getOptions() {
        assert (this.fStorage != null);
        HashMap<String, String> map = new HashMap<String, String>();
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("option");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (child.hasAttribute("id")) {
                map.put(child.getAttribute("id"), child.getAttribute("value"));
            }
            ++n2;
        }
        return map;
    }

    public String getOption(String id) {
        assert (id != null);
        assert (this.fStorage != null);
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("option");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (child.hasAttribute("id") && id.equals(child.getAttribute("id"))) {
                return child.getAttribute("value");
            }
            ++n2;
        }
        return null;
    }

    public String getOption(String id, String defaultValue) {
        String result = this.getOption(id);
        if (result != null && result.length() > 0) {
            return result;
        }
        return defaultValue;
    }

    public void setOption(String id, String value) {
        assert (id != null);
        assert (this.fStorage != null);
        ICStorageElement option = null;
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("option");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (id.equals(child.getAttribute("id"))) {
                if (option == null) {
                    option = child;
                } else {
                    this.fStorage.removeChild(child);
                }
            }
            ++n2;
        }
        if (option == null) {
            option = this.fStorage.createChild("option");
            option.setAttribute("id", id);
        }
        value = value == null ? "" : value.trim();
        option.setAttribute("value", value);
    }

    public void setNonEmptyOption(String id, String value) {
        if (value != null && (value = value.trim()).length() > 0) {
            this.setOption(id, value);
        }
    }

    public void setMemory(String section, String start, String size, String startup) {
        ICStorageElement memory = null;
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("memory");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (section.equals(child.getAttribute("section"))) {
                if (memory == null) {
                    memory = child;
                } else {
                    this.fStorage.removeChild(child);
                }
            }
            ++n2;
        }
        if (memory == null) {
            memory = this.fStorage.createChild("memory");
            memory.setAttribute("section", section);
        }
        memory.setAttribute("start", start);
        memory.setAttribute("size", size);
        memory.setAttribute("startup", startup);
    }

    public Map<String, String[]> getMemoryMap() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        ICStorageElement[] iCStorageElementArray = this.fStorage.getChildrenByName("memory");
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            String section = child.getAttribute("section");
            String[] arr = new String[]{section, child.getAttribute("start"), child.getAttribute("size"), child.getAttribute("startup")};
            map.put(section, arr);
            ++n2;
        }
        return map;
    }
}

