/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.HelpSupport;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertyFile;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OomphDialog
extends TitleAreaDialog
implements HelpSupport.HelpProvider {
    private static final PropertyFile HISTORY = new PropertyFile(UIPlugin.INSTANCE.getUserLocation().append("dialog-help-shown.properties").toFile());
    private static final String SETTING_DIALOG_WIDTH = "dialogWidth";
    private static final String SETTING_DIALOG_HEIGHT = "dialogHeight";
    private String title;
    private int width;
    private int height;
    private OomphUIPlugin plugin;
    private HelpSupport helpSupport;

    protected OomphDialog(Shell parentShell, String title, int defaultWidth, int defaultHeight, OomphUIPlugin plugin, boolean helpAvailable) {
        super(parentShell);
        this.setShellStyle(68848);
        this.title = title;
        this.plugin = plugin;
        this.width = defaultWidth;
        this.height = defaultHeight;
        IDialogSettings settings = this.getDialogSettings();
        try {
            int dialogWidth;
            this.width = dialogWidth = settings.getInt(SETTING_DIALOG_WIDTH);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            int dialogHeight;
            this.height = dialogHeight = settings.getInt(SETTING_DIALOG_HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {}
        if (helpAvailable) {
            this.helpSupport = new HelpSupport(this){

                protected void handleInactivity(Display display, boolean inactive) {
                    OomphDialog.this.handleInactivity(display, inactive);
                }
            };
        }
    }

    public boolean isHelpAvailable() {
        return this.helpSupport != null;
    }

    public final HelpSupport getHelpSupport() {
        return this.helpSupport;
    }

    @Override
    public String getHelpPath() {
        return null;
    }

    public boolean close() {
        if (this.helpSupport != null) {
            this.helpSupport.dispose();
            this.helpSupport = null;
        }
        if (this.getTray() != null) {
            this.closeTray();
        }
        Point size = this.getShell().getSize();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTING_DIALOG_WIDTH, size.x);
        settings.put(SETTING_DIALOG_HEIGHT, size.y);
        return super.close();
    }

    public String getTitle() {
        return this.title;
    }

    public void openTray(DialogTray tray) throws IllegalStateException, UnsupportedOperationException {
        super.openTray(tray);
        OomphDialog.hookTray((TrayDialog)this);
    }

    public void setTitleImage(Image newTitleImage) {
        super.setTitleImage(newTitleImage);
        OomphDialog.fixTitleImageLayout(this);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        OomphDialog.fixTitleImageLayout(this);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(this.getShellText());
        this.setTitle(this.title);
        this.setTitleImage(this.getDefaultImage(this.getImagePath()));
        this.setMessage(this.getDefaultMessage());
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(this.getContainerColumns(), false);
        layout.marginWidth = this.getContainerMargin();
        layout.marginHeight = this.getContainerMargin();
        layout.verticalSpacing = 0;
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createUI(container);
        if (this.getContainerMargin() == 0) {
            this.createSeparator(container);
        }
        shell.setActive();
        return area;
    }

    protected Button createCheckbox(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createHelpControl(Composite parent) {
        ToolBar toolBar = (ToolBar)super.createHelpControl(parent);
        if (this.helpSupport != null) {
            ToolItem helpButton = toolBar.getItems()[0];
            this.helpSupport.hook(helpButton);
        }
        this.createToolItemsForToolBar(toolBar);
        return toolBar;
    }

    protected void createToolItemsForToolBar(ToolBar toolBar) {
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String label) {
        return this.createToolItem(toolBar, null, label);
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String iconPath, String toolTip) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        if (iconPath == null) {
            toolItem.setText(toolTip);
        } else {
            Image image = this.getDefaultImage(iconPath);
            toolItem.setImage(image);
            toolItem.setToolTipText(toolTip);
        }
        return toolItem;
    }

    protected Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false, this.getContainerColumns(), 1));
        return separator;
    }

    protected int getContainerColumns() {
        return 1;
    }

    protected int getContainerMargin() {
        return 0;
    }

    protected abstract String getImagePath();

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getClass().getName();
        OomphUIPlugin plugin = this.plugin != null ? this.plugin : UIPlugin.INSTANCE;
        return plugin.getDialogSettings(sectionName);
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    protected final Point getInitialSize() {
        return new Point(this.width, this.height);
    }

    protected final Image getDefaultImage(String path) {
        return this.plugin.getSWTImage(path);
    }

    protected abstract String getDefaultMessage();

    protected abstract String getShellText();

    protected abstract void createUI(Composite var1);

    public static boolean showFirstTimeHelp(final TrayDialog dialog) {
        try {
            String value;
            String key;
            if (dialog.isHelpAvailable() && HISTORY.compareAndSetProperty(key = dialog.getClass().getName(), value = new Date().toString(), new String[0])) {
                UIUtil.asyncExec((Control)dialog.getShell(), new Runnable(){

                    public void run() {
                        try {
                            Method method = ReflectUtil.getMethod(TrayDialog.class, (String)"helpPressed", (Class[])new Class[0]);
                            ReflectUtil.invokeMethod((Method)method, (Object)dialog, (Object[])new Object[0]);
                        }
                        catch (Throwable ex) {
                            UIPlugin.INSTANCE.log(ex);
                        }
                    }
                });
                return true;
            }
        }
        catch (Throwable ex) {
            UIPlugin.INSTANCE.log(ex);
        }
        return false;
    }

    public static void hookTray(final TrayDialog dialog) throws IllegalStateException, UnsupportedOperationException {
        Control trayControl = (Control)OomphDialog.getFieldValue(dialog, "trayControl");
        final Label rightSeparator = (Label)OomphDialog.getFieldValue(dialog, "rightSeparator");
        final Sash sash = (Sash)OomphDialog.getFieldValue(dialog, "sash");
        if (trayControl == null || rightSeparator == null || sash == null) {
            return;
        }
        final GridData data = (GridData)trayControl.getLayoutData();
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    Shell shell = dialog.getShell();
                    Rectangle clientArea = shell.getClientArea();
                    int newWidth = clientArea.width - event.x - (sash.getSize().x + rightSeparator.getSize().x);
                    if (newWidth != data.widthHint) {
                        data.widthHint = newWidth;
                        shell.layout();
                    }
                }
            }
        });
    }

    public static void fixTitleImageLayout(TitleAreaDialog dialog) {
        try {
            Field titleImageLargestField = ReflectUtil.getField(TitleAreaDialog.class, (String)"titleImageLargest");
            boolean titleImageLargest = (Boolean)ReflectUtil.getValue((Field)titleImageLargestField, (Object)dialog);
            Field workAreaField = ReflectUtil.getField(TitleAreaDialog.class, (String)"workArea");
            Composite workArea = (Composite)ReflectUtil.getValue((Field)workAreaField, (Object)dialog);
            Field titleImageLabelField = ReflectUtil.getField(TitleAreaDialog.class, (String)"titleImageLabel");
            Label titleImageLabel = (Label)ReflectUtil.getValue((Field)titleImageLabelField, (Object)dialog);
            FormData layoutData = (FormData)titleImageLabel.getLayoutData();
            if (titleImageLargest) {
                layoutData.top = new FormAttachment(0, 0);
                layoutData.bottom = null;
            } else {
                layoutData.top = null;
                layoutData.bottom = new FormAttachment((Control)workArea);
            }
        }
        catch (Throwable throwable) {}
    }

    private static void animateMessage(TitleAreaDialog dialog) {
        try {
            final Text messageLabel = (Text)ReflectUtil.getValue((String)"messageLabel", (Object)dialog);
            final Display display = messageLabel.getDisplay();
            final Color[] colors = new Color[8];
            int color = 0;
            while (color < colors.length) {
                colors[color] = new Color((Device)display, 0, color * 32, 0);
                ++color;
            }
            display.asyncExec(new Runnable(){
                private int loop;
                private int color;
                private boolean reverse;

                public void run() {
                    messageLabel.setForeground(colors[this.color]);
                    if (this.reverse) {
                        if (--this.color == -1) {
                            if (++this.loop == 5) {
                                int i = 0;
                                while (i < colors.length) {
                                    colors[i].dispose();
                                    ++i;
                                }
                                return;
                            }
                            this.color = 1;
                            this.reverse = false;
                        }
                    } else if (++this.color == colors.length) {
                        this.color = colors.length - 2;
                        this.reverse = true;
                    }
                    display.timerExec(80, (Runnable)this);
                }
            });
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static <T> T getFieldValue(TrayDialog dialog, String name) {
        try {
            Field field = ReflectUtil.getField(TrayDialog.class, (String)name);
            if (field != null) {
                Object value = ReflectUtil.getValue((Field)field, (Object)dialog);
                return (T)value;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

