/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.ui.AbstractAutotoolsCPropertyTab;
import org.eclipse.cdt.internal.autotools.ui.properties.AutotoolsPropertyMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AutotoolsToolsPropertyTab
extends AbstractAutotoolsCPropertyTab {
    public static final String DEFAULT_ACLOCAL = "aclocal";
    public static final String DEFAULT_AUTOMAKE = "automake";
    public static final String DEFAULT_AUTOCONF = "autoconf";
    public static final String DEFAULT_AUTOHEADER = "autoheader";
    public static final String DEFAULT_AUTORECONF = "autoreconf";
    public static final String DEFAULT_LIBTOOLIZE = "libtoolize";
    protected Text fAclocalPath;
    protected Text fAutomakePath;
    protected Text fAutoconfPath;
    protected Text fAutoheaderPath;
    protected Text fAutoreconfPath;
    protected Text fLibtoolizePath;
    private IProject project;

    private IProject getProject() {
        return this.page.getProject();
    }

    public boolean canBeVisible() {
        return true;
    }

    public void cfgChanged(AutotoolsConfiguration cfg) {
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        Composite composite = this.usercomp;
        GridData gd = new GridData(848);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.project = this.getProject();
        Label label = new Label(composite, 16384);
        label.setText(AutotoolsPropertyMessages.getString("Autotools.aclocalPath"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAclocalPath = new Text(composite, 2052);
        this.fAclocalPath.setToolTipText(AutotoolsPropertyMessages.getString("Autotools.aclocalPath.tooltip"));
        gd = new GridData(802);
        this.fAclocalPath.setLayoutData((Object)gd);
        Label label2 = new Label(composite, 16384);
        label2.setText(AutotoolsPropertyMessages.getString("Autotools.automakePath"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label2.setLayoutData((Object)gd);
        this.fAutomakePath = new Text(composite, 2052);
        this.fAutomakePath.setToolTipText(AutotoolsPropertyMessages.getString("Autotools.automakePath.tooltip"));
        gd = new GridData(802);
        this.fAutomakePath.setLayoutData((Object)gd);
        Label label3 = new Label(composite, 16384);
        label3.setText(AutotoolsPropertyMessages.getString("Autotools.autoconfPath"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label3.setLayoutData((Object)gd);
        this.fAutoconfPath = new Text(composite, 2052);
        this.fAutoconfPath.setToolTipText(AutotoolsPropertyMessages.getString("Autotools.autoconfPath.tooltip"));
        gd = new GridData(802);
        this.fAutoconfPath.setLayoutData((Object)gd);
        Label label4 = new Label(composite, 16384);
        label4.setText(AutotoolsPropertyMessages.getString("Autotools.autoheaderPath"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label4.setLayoutData((Object)gd);
        this.fAutoheaderPath = new Text(composite, 2052);
        this.fAutoheaderPath.setToolTipText(AutotoolsPropertyMessages.getString("Autotools.autoheaderPath.tooltip"));
        gd = new GridData(802);
        this.fAutoheaderPath.setLayoutData((Object)gd);
        Label label5 = new Label(composite, 16384);
        label5.setText(AutotoolsPropertyMessages.getString("Autotools.autoreconfPath"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label5.setLayoutData((Object)gd);
        this.fAutoreconfPath = new Text(composite, 2052);
        this.fAutoreconfPath.setToolTipText(AutotoolsPropertyMessages.getString("Autotools.autoreconfPath.tooltip"));
        gd = new GridData(802);
        this.fAutoreconfPath.setLayoutData((Object)gd);
        Label label6 = new Label(composite, 16384);
        label6.setText(AutotoolsPropertyMessages.getString("Autotools.libtoolizePath"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label6.setLayoutData((Object)gd);
        this.fLibtoolizePath = new Text(composite, 2052);
        this.fLibtoolizePath.setToolTipText(AutotoolsPropertyMessages.getString("Autotools.libtoolizePath.tooltip"));
        gd = new GridData(802);
        this.fLibtoolizePath.setLayoutData((Object)gd);
        this.initialize();
    }

    public void performOK() {
        String aclocalPath = null;
        String automakePath = null;
        String autoconfPath = null;
        String autoheaderPath = null;
        String autoreconfPath = null;
        String libtoolizePath = null;
        try {
            aclocalPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.ACLOCAL_TOOL);
        }
        catch (CoreException e1) {
            aclocalPath = DEFAULT_ACLOCAL;
        }
        String newAclocalPath = this.fAclocalPath.getText().trim();
        if (aclocalPath == null || !newAclocalPath.equals(aclocalPath)) {
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.ACLOCAL_TOOL, newAclocalPath);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        try {
            automakePath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_TOOL);
        }
        catch (CoreException e1) {
            automakePath = DEFAULT_AUTOMAKE;
        }
        String newAutomakePath = this.fAutomakePath.getText().trim();
        if (automakePath == null || !newAutomakePath.equals(automakePath)) {
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_TOOL, newAutomakePath);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        try {
            autoconfPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_TOOL);
        }
        catch (CoreException e1) {
            autoconfPath = DEFAULT_AUTOCONF;
        }
        String newAutoconfPath = this.fAutoconfPath.getText().trim();
        if (autoconfPath == null || !newAutoconfPath.equals(autoconfPath)) {
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_TOOL, newAutoconfPath);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        try {
            autoheaderPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOHEADER_TOOL);
        }
        catch (CoreException e1) {
            autoheaderPath = DEFAULT_AUTOHEADER;
        }
        String newAutoheaderPath = this.fAutoheaderPath.getText().trim();
        if (autoheaderPath == null || !newAutoheaderPath.equals(autoheaderPath)) {
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.AUTOHEADER_TOOL, newAutoheaderPath);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        try {
            autoreconfPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL);
        }
        catch (CoreException e1) {
            autoreconfPath = DEFAULT_AUTORECONF;
        }
        String newAutoreconfPath = this.fAutoreconfPath.getText().trim();
        if (autoreconfPath == null || !newAutoreconfPath.equals(autoreconfPath)) {
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL, newAutoreconfPath);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        try {
            libtoolizePath = this.project.getPersistentProperty(AutotoolsPropertyConstants.LIBTOOLIZE_TOOL);
        }
        catch (CoreException e1) {
            libtoolizePath = DEFAULT_LIBTOOLIZE;
        }
        String newLibtoolizePath = this.fLibtoolizePath.getText().trim();
        if (libtoolizePath == null || !newLibtoolizePath.equals(libtoolizePath)) {
            try {
                this.project.setPersistentProperty(AutotoolsPropertyConstants.LIBTOOLIZE_TOOL, newLibtoolizePath);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.performOK();
    }

    public void performDefaults() {
        this.fAclocalPath.setText(DEFAULT_ACLOCAL);
        this.fAutomakePath.setText(DEFAULT_AUTOMAKE);
        this.fAutoconfPath.setText(DEFAULT_AUTOCONF);
        this.fAutoheaderPath.setText(DEFAULT_AUTOHEADER);
        this.fAutoreconfPath.setText(DEFAULT_AUTORECONF);
        this.fLibtoolizePath.setText(DEFAULT_LIBTOOLIZE);
    }

    public void updateData(ICResourceDescription cfgd) {
    }

    public void updateButtons() {
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void initialize() {
        String aclocalPath = null;
        String automakePath = null;
        String autoconfPath = null;
        String autoheaderPath = null;
        String autoreconfPath = null;
        String libtoolizePath = null;
        try {
            aclocalPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.ACLOCAL_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (aclocalPath == null) {
            aclocalPath = DEFAULT_ACLOCAL;
        }
        this.fAclocalPath.setText(aclocalPath);
        try {
            automakePath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOMAKE_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (automakePath == null) {
            automakePath = DEFAULT_AUTOMAKE;
        }
        this.fAutomakePath.setText(automakePath);
        try {
            autoconfPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (autoconfPath == null) {
            autoconfPath = DEFAULT_AUTOCONF;
        }
        this.fAutoconfPath.setText(autoconfPath);
        try {
            autoheaderPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTOHEADER_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (autoheaderPath == null) {
            autoheaderPath = DEFAULT_AUTOHEADER;
        }
        this.fAutoheaderPath.setText(autoheaderPath);
        try {
            autoreconfPath = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (autoreconfPath == null) {
            autoreconfPath = DEFAULT_AUTORECONF;
        }
        this.fAutoreconfPath.setText(autoreconfPath);
        try {
            libtoolizePath = this.project.getPersistentProperty(AutotoolsPropertyConstants.LIBTOOLIZE_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (libtoolizePath == null) {
            libtoolizePath = DEFAULT_LIBTOOLIZE;
        }
        this.fLibtoolizePath.setText(libtoolizePath);
    }
}

