/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryStateProvider;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class UstMemoryAnalysisModule
extends TmfStateSystemAnalysisModule {
    @NonNull
    public static final String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.memory";
    private static final ImmutableSet<String> REQUIRED_EVENTS = ImmutableSet.of((Object)"ust_libc:malloc", (Object)"ust_libc:free", (Object)"ust_libc:calloc", (Object)"ust_libc:realloc", (Object)"ust_libc:memalign", (Object)"ust_libc:posix_memalign", (Object[])new String[0]);
    @NonNull
    private static final Set<TmfAnalysisRequirement> REQUIREMENTS;

    static {
        TmfAnalysisRequirement eventsReq = new TmfAnalysisRequirement("event", REQUIRED_EVENTS, TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        eventsReq.addInformation(Messages.UstMemoryAnalysisModule_EventsLoadingInformation);
        eventsReq.addInformation(Messages.UstMemoryAnalysisModule_EventsLoadingExampleInformation);
        TmfAnalysisRequirement domainReq = new TmfAnalysisRequirement("domain");
        domainReq.addValue("UST", TmfAnalysisRequirement.ValuePriorityLevel.MANDATORY);
        REQUIREMENTS = (Set)NonNullUtils.checkNotNull((Object)ImmutableSet.of((Object)domainReq, (Object)eventsReq));
    }

    protected ITmfStateProvider createStateProvider() {
        return new UstMemoryStateProvider((LttngUstTrace)((Object)NonNullUtils.checkNotNull((Object)((Object)this.getTrace()))));
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        return super.setTrace(trace);
    }

    protected LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public Iterable<TmfAnalysisRequirement> getAnalysisRequirements() {
        return REQUIREMENTS;
    }
}

