/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMultiTerminate;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.Messages;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IProcess;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfSession fSession;
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fSession = session;
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length == 0) {
            request.setEnabled(false);
            request.done();
            return;
        }
        final GdbLaunch launch = this.getLaunch((IDebugCommandRequest)request);
        if (launch != null) {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    request.setEnabled(false);
                    IGDBControl gdbControl = (IGDBControl)DsfTerminateCommand.this.fTracker.getService(IGDBControl.class);
                    if (gdbControl != null && gdbControl.isActive()) {
                        request.setEnabled(true);
                    } else {
                        IProcess[] iProcessArray = launch.getProcesses();
                        int n = iProcessArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcess p = iProcessArray[n2];
                            if (p.canTerminate()) {
                                request.setEnabled(true);
                                break;
                            }
                            ++n2;
                        }
                    }
                    request.done();
                }
            });
        } else {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IProcesses.IProcessDMContext[] procDmcs = DsfTerminateCommand.this.getProcessDMContexts(request.getElements());
                    DsfTerminateCommand.this.canTerminate(procDmcs, (DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)DsfTerminateCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                request.setEnabled(false);
                            } else {
                                request.setEnabled(((Boolean)this.getData()).booleanValue());
                            }
                            request.done();
                        }
                    }));
                }
            });
        }
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length == 0) {
            request.done();
            return false;
        }
        final GdbLaunch launch = this.getLaunch(request);
        if (launch != null) {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IGDBControl gdbControl = (IGDBControl)DsfTerminateCommand.this.fTracker.getService(IGDBControl.class);
                    if (gdbControl != null && gdbControl.isActive()) {
                        gdbControl.terminate(new RequestMonitor((Executor)DsfTerminateCommand.this.fExecutor, null){

                            protected void handleCompleted() {
                                if (!this.isSuccess()) {
                                    request.setStatus(this.getStatus());
                                    request.done();
                                } else {
                                    DsfTerminateCommand.this.waitForTermination(request);
                                }
                            }
                        });
                    } else {
                        DsfTerminateCommand.this.terminateRemainingProcesses(launch, request);
                    }
                }
            });
        } else {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    IProcesses.IProcessDMContext[] procDmcs = DsfTerminateCommand.this.getProcessDMContexts(request.getElements());
                    DsfTerminateCommand.this.terminate(procDmcs, new RequestMonitor((Executor)DsfTerminateCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                request.setStatus(this.getStatus());
                                request.done();
                            } else {
                                DsfTerminateCommand.this.waitForTermination(request);
                            }
                        }
                    });
                }
            });
        }
        return false;
    }

    private void waitForTermination(final IDebugCommandRequest request) {
        if (!DsfSession.isSessionActive((String)this.fSession.getId())) {
            request.done();
            return;
        }
        final DsfSession.SessionEndedListener endedListener = new DsfSession.SessionEndedListener(){

            public void sessionEnded(DsfSession session) {
                if (DsfTerminateCommand.this.fSession.equals((Object)session)) {
                    DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
                    GdbLaunch launch = DsfTerminateCommand.this.getLaunch(request);
                    if (launch != null) {
                        DsfTerminateCommand.this.terminateRemainingProcesses(launch, request);
                    } else {
                        request.done();
                    }
                }
            }
        };
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)endedListener);
        this.fExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                if (DsfSession.isSessionActive((String)DsfTerminateCommand.this.fSession.getId())) {
                    DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)endedListener);
                    request.setStatus(Status.CANCEL_STATUS);
                    request.done();
                }
            }
        }, 1L, TimeUnit.MINUTES);
    }

    private IProcesses.IProcessDMContext[] getProcessDMContexts(Object[] elements) {
        HashSet<IProcesses.IProcessDMContext> procDmcs = new HashSet<IProcesses.IProcessDMContext>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            Object obj = objectArray[n2];
            if (obj instanceof IDMVMContext && (procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)obj).getDMContext(), IProcesses.IProcessDMContext.class)) != null) {
                procDmcs.add(procDmc);
            }
            ++n2;
        }
        return procDmcs.toArray(new IProcesses.IProcessDMContext[procDmcs.size()]);
    }

    private void canTerminate(IProcesses.IProcessDMContext[] procDmcs, DataRequestMonitor<Boolean> rm) {
        if (procDmcs.length == 0) {
            IGDBControl gdbControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
            if (gdbControl != null) {
                rm.setData((Object)gdbControl.isActive());
            } else {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Service is not available."));
            }
            rm.done();
            return;
        }
        IMultiTerminate multiTerminate = (IMultiTerminate)this.fTracker.getService(IMultiTerminate.class);
        if (multiTerminate != null) {
            multiTerminate.canTerminateSome((IProcesses.IThreadDMContext[])procDmcs, rm);
        } else {
            IProcesses procService = (IProcesses)this.fTracker.getService(IProcesses.class);
            if (procService != null && procDmcs.length == 1) {
                procService.canTerminate((IProcesses.IThreadDMContext)procDmcs[0], rm);
            } else {
                rm.setData((Object)false);
                rm.done();
            }
        }
    }

    private void terminate(IProcesses.IProcessDMContext[] procDmcs, RequestMonitor rm) {
        if (procDmcs.length == 0) {
            IGDBControl gdbControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
            if (gdbControl != null) {
                gdbControl.terminate(rm);
            } else {
                rm.done();
            }
            return;
        }
        IMultiTerminate multiTerminate = (IMultiTerminate)this.fTracker.getService(IMultiTerminate.class);
        if (multiTerminate != null) {
            multiTerminate.terminate((IProcesses.IThreadDMContext[])procDmcs, rm);
        } else {
            IProcesses procService = (IProcesses)this.fTracker.getService(IProcesses.class);
            if (procService != null && procDmcs.length == 1) {
                procService.terminate((IProcesses.IThreadDMContext)procDmcs[0], rm);
            } else {
                rm.done();
            }
        }
    }

    private GdbLaunch getLaunch(IDebugCommandRequest request) {
        Object[] objectArray = request.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (el instanceof GdbLaunch) {
                return (GdbLaunch)el;
            }
            ++n2;
        }
        return null;
    }

    private void terminateRemainingProcesses(final GdbLaunch launch, final IDebugCommandRequest request) {
        new Job("Terminate Job"){

            protected IStatus run(IProgressMonitor monitor) {
                MultiStatus status = new MultiStatus("org.eclipse.cdt.dsf.gdb.ui", 5012, Messages.DsfTerminateCommand_Terminate_failed, null);
                IProcess[] iProcessArray = launch.getProcesses();
                int n = iProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess p = iProcessArray[n2];
                    if (p.canTerminate()) {
                        try {
                            p.terminate();
                        }
                        catch (DebugException e) {
                            status.merge(e.getStatus());
                        }
                    }
                    ++n2;
                }
                if (!status.isOK()) {
                    request.setStatus((IStatus)status);
                }
                request.done();
                return Status.OK_STATUS;
            }
        }.schedule(100L);
    }
}

