/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnuarmeclipse.packs.data;

import ilg.gnuarmeclipse.core.StringUtils;
import ilg.gnuarmeclipse.packs.data.Activator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsoleStream;

public class Utils {
    private static final String MARKER_ID = "ilg.gnuarmeclipse.packs.marker";

    public static InputStream checkForUtf8BOM(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 3);
        byte[] bom = new byte[3];
        if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
            pushbackInputStream.unread(bom);
        }
        return pushbackInputStream;
    }

    public static int getRemoteFileSize(URL url) throws IOException {
        URLConnection connection;
        block2: {
            int responseCode;
            while (true) {
                connection = url.openConnection();
                if ("file".equals(url.getProtocol())) break block2;
                if (!(connection instanceof HttpURLConnection)) continue;
                responseCode = ((HttpURLConnection)connection).getResponseCode();
                if (responseCode == 200) break block2;
                if (responseCode != 302 && responseCode != 301 && responseCode != 303) break;
                String newUrl = connection.getHeaderField("Location");
                url = new URL(newUrl);
            }
            throw new IOException("Failed to open connection, response code " + responseCode);
        }
        int length = connection.getContentLength();
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
        return length;
    }

    public static boolean copyFileWithShell(URL sourceUrl, File destinationFile, MessageConsoleStream out, IProgressMonitor monitor, Shell shell) throws IOException {
        while (true) {
            try {
                Utils.copyFile(sourceUrl, destinationFile, out, monitor);
                return true;
            }
            catch (IOException e) {
                class ErrorMessageDialog
                implements Runnable {
                    public int retCode = 0;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ URL val$sourceUrl;
                    private final /* synthetic */ IOException val$e;

                    ErrorMessageDialog(Shell shell, URL uRL, IOException iOException) {
                        this.val$shell = shell;
                        this.val$sourceUrl = uRL;
                        this.val$e = iOException;
                    }

                    @Override
                    public void run() {
                        String[] buttons = new String[]{"Retry", "Ignore", "Abort"};
                        MessageDialog dialog = new MessageDialog(this.val$shell, "Read error", null, String.valueOf(this.val$sourceUrl.toString()) + "\n" + this.val$e.getMessage(), 1, buttons, 0);
                        this.retCode = dialog.open();
                    }
                }
                ErrorMessageDialog messageDialog = new ErrorMessageDialog(shell, sourceUrl, e);
                Display.getDefault().syncExec((Runnable)messageDialog);
                if (messageDialog.retCode != 2) continue;
                throw e;
                if (messageDialog.retCode != 1) continue;
                return false;
            }
            break;
        }
    }

    public static void copyFile(URL sourceUrl, File destinationFile, MessageConsoleStream out, IProgressMonitor monitor) throws IOException {
        int bytesRead;
        int size;
        URLConnection connection;
        URL url;
        block7: {
            int responseCode;
            url = sourceUrl;
            while (true) {
                connection = url.openConnection();
                if ("file".equals(url.getProtocol())) break block7;
                if (!(connection instanceof HttpURLConnection)) continue;
                responseCode = ((HttpURLConnection)connection).getResponseCode();
                if (responseCode == 200) break block7;
                if (responseCode != 302 && responseCode != 301 && responseCode != 303) break;
                String newUrl = connection.getHeaderField("Location");
                url = new URL(newUrl);
            }
            throw new IOException("Failed to open connection, response code " + responseCode);
        }
        if ((size = connection.getContentLength()) <= 0) {
            throw new IOException("Illegal PDSC file size " + size);
        }
        String sizeString = StringUtils.convertSizeToString((int)size);
        if (out != null) {
            String s = destinationFile.getPath();
            if (s.endsWith(".download")) {
                s = s.substring(0, s.length() - ".download".length());
            }
            out.println("Copy " + sizeString);
            out.println(" from \"" + url + "\"");
            if (!url.equals(sourceUrl)) {
                out.println(" redirected from \"" + sourceUrl + "\"");
            }
            out.println(" to   \"" + s + "\"");
        }
        destinationFile.getParentFile().mkdirs();
        InputStream input = connection.getInputStream();
        FileOutputStream output = new FileOutputStream(destinationFile);
        byte[] buf = new byte[1024];
        while ((bytesRead = input.read(buf)) > 0) {
            ((OutputStream)output).write(buf, 0, bytesRead);
            if (monitor == null) continue;
            monitor.worked(bytesRead);
        }
        ((OutputStream)output).close();
        input.close();
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public static void copyFile(File sourceFile, File destinationFile, MessageConsoleStream out, IProgressMonitor monitor) throws IOException {
        int bytesRead;
        if (out != null) {
            int size = (int)sourceFile.length();
            String sizeString = StringUtils.convertSizeToString((int)size);
            out.println("Copy " + sizeString);
            out.println(" from \"" + sourceFile + "\"");
            out.println(" to   \"" + destinationFile + "\"");
        }
        destinationFile.getParentFile().mkdirs();
        FileInputStream input = new FileInputStream(sourceFile);
        FileOutputStream output = new FileOutputStream(destinationFile);
        byte[] buf = new byte[1024];
        while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
            ((OutputStream)output).write(buf, 0, bytesRead);
            if (monitor == null) continue;
            monitor.worked(bytesRead);
        }
        ((OutputStream)output).close();
        ((InputStream)input).close();
    }

    public static int deleteFolderRecursive(File folder) {
        int count = 0;
        if (folder == null) {
            return count;
        }
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    count += Utils.deleteFolderRecursive(f);
                    f.setWritable(true, false);
                    f.delete();
                } else {
                    f.setWritable(true, false);
                    f.delete();
                    ++count;
                }
                ++n2;
            }
            folder.setWritable(true, false);
            folder.delete();
        }
        return count;
    }

    public static void makeFolderReadOnlyRecursive(File folder) {
        if (folder == null) {
            return;
        }
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    Utils.makeFolderReadOnlyRecursive(f);
                    f.setWritable(false, false);
                } else {
                    f.setWritable(false, false);
                }
                ++n2;
            }
            folder.setWritable(false, false);
        }
    }

    public static String reportError(String message) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)"-");
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        return message;
    }

    public static String reportWarning(String message) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 1);
            marker.setAttribute("location", (Object)"-");
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        return message;
    }

    public static String reportInfo(String message) {
        try {
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker(MARKER_ID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 0);
            marker.setAttribute("location", (Object)"-");
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        return message;
    }
}

