/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.events;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfCollapseFilter;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.commands.CopyToClipboardOperation;
import org.eclipse.tracecompass.internal.tmf.ui.dialogs.MultiLineInputDialog;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.event.collapse.ITmfCollapsibleEvent;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventFilterAppliedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventSearchAppliedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsCache;
import org.eclipse.tracecompass.tmf.ui.viewers.events.columns.TmfEventTableColumn;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.tracecompass.tmf.ui.views.colors.IColorSettingsListener;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterManager;
import org.eclipse.tracecompass.tmf.ui.widgets.rawviewer.TmfRawEventViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.virtualtable.ColumnData;
import org.eclipse.tracecompass.tmf.ui.widgets.virtualtable.TmfVirtualTable;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.themes.ColorUtil;

public class TmfEventsTable
extends TmfComponent
implements IGotoMarker,
IColorSettingsListener,
ISelectionProvider,
IPropertyChangeListener {
    @NonNull
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    @NonNull
    protected static final String EMPTY_STRING = "";
    private static final boolean IS_LINUX = System.getProperty("os.name").contains("Linux");
    private static final String FONT_DEFINITION_ID = "org.eclipse.tracecompass.tmf.ui.font.eventtable";
    private static final String HIGHLIGHT_COLOR_DEFINITION_ID = "org.eclipse.tracecompass.tmf.ui.color.eventtable.highlight";
    private static final Image BOOKMARK_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/bookmark_obj.gif");
    private static final Image SEARCH_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/search.gif");
    private static final Image SEARCH_MATCH_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/search_match.gif");
    private static final Image SEARCH_MATCH_BOOKMARK_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/search_match_bookmark.gif");
    private static final Image FILTER_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/filter_items.gif");
    private static final Image STOP_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/stop.gif");
    private static final String SEARCH_HINT = Messages.TmfEventsTable_SearchHint;
    private static final String FILTER_HINT = Messages.TmfEventsTable_FilterHint;
    private static final int MAX_CACHE_SIZE = 1000;
    private static final int MARGIN_COLUMN_INDEX = 0;
    private static final int FILTER_SUMMARY_INDEX = 1;
    private static final int EVENT_COLUMNS_START_INDEX = 1;
    protected TmfVirtualTable fTable;
    private Composite fComposite;
    private SashForm fSashForm;
    private TmfRawEventViewer fRawViewer;
    private ITmfTrace fTrace;
    private volatile boolean fPackDone = false;
    private HeaderState fHeaderState = HeaderState.SEARCH;
    private long fSelectedRank = -1L;
    private long fSelectedBeginRank = -1L;
    private ITmfTimestamp fSelectedBeginTimestamp = null;
    private IStatusLineManager fStatusLineManager = null;
    private long fFilterMatchCount;
    private long fFilterCheckCount;
    private FilterThread fFilterThread;
    private boolean fFilterThreadResume = false;
    private final Object fFilterSyncObj = new Object();
    private SearchThread fSearchThread;
    private final Object fSearchSyncObj = new Object();
    private ListenerList selectionChangedListeners = new ListenerList();
    private Multimap<Long, Long> fBookmarksMap = HashMultimap.create();
    private IFile fBookmarksFile;
    private long fPendingGotoRank = -1L;
    private LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Color fGrayColor;
    private Color fGreenColor;
    private Color fHighlightColor;
    private Font fFont;
    private Font fBoldFont;
    private final List<TmfEventTableColumn> fColumns = new LinkedList<TmfEventTableColumn>();
    private final TmfEventsCache fCache;
    private boolean fCacheUpdateBusy = false;
    private boolean fCacheUpdatePending = false;
    private boolean fCacheUpdateCompleted = false;
    private final Object fCacheUpdateSyncObj = new Object();
    private int[] fColumnOrder;
    private boolean fDisposeOnClose;
    private Menu fHeaderMenu;
    private Menu fTablePopup;
    private Menu fRawTablePopup;
    private Point fLastMenuCursorLocation;
    private MenuManager fRawViewerPopupMenuManager;
    private MenuManager fTablePopupMenuManager;
    private MenuManager fHeaderPopupMenuManager;

    public TmfEventsTable(Composite parent, int cacheSize) {
        this(parent, cacheSize, TmfTrace.BASE_ASPECTS);
    }

    @Deprecated
    public TmfEventsTable(Composite parent, int cacheSize, ColumnData[] columnData) {
        this(parent, cacheSize, TmfEventsTable.convertFromColumnData(columnData));
    }

    @Deprecated
    @NonNull
    private static Iterable<ITmfEventAspect> convertFromColumnData(ColumnData[] columnData) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ColumnData[] columnDataArray = columnData;
        int n = columnData.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnData col = columnDataArray[n2];
            String fieldName = col.header;
            if (fieldName != null) {
                builder.add((Object)new TmfContentFieldAspect(fieldName, new String[]{fieldName}));
            }
            ++n2;
        }
        return (Iterable)NonNullUtils.checkNotNull((Object)builder.build());
    }

    public TmfEventsTable(Composite parent, int cacheSize, @NonNull Iterable<ITmfEventAspect> aspects) {
        super("TmfEventsTable");
        this.fComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.fComposite.setLayout((Layout)gl);
        this.fSashForm = new SashForm(this.fComposite, 256);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 66306;
        this.fTable = new TmfVirtualTable((Composite)this.fSashForm, 66306);
        GridData layoutData = new GridData(4, 4, true, true);
        this.fTable.setLayoutData(layoutData);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        for (ITmfEventAspect aspect : aspects) {
            if (aspect == null) continue;
            this.fColumns.add(new TmfEventTableColumn(aspect));
        }
        TmfMarginColumn collapseCol = new TmfMarginColumn();
        this.fColumns.add(0, collapseCol);
        this.fHeaderMenu = new Menu((Control)this.fTable);
        for (TmfEventTableColumn col : this.fColumns) {
            TableColumn column = this.fTable.newTableColumn(16384);
            column.setText(col.getHeaderName());
            column.setToolTipText(col.getHeaderTooltip());
            column.setData("$aspect", (Object)col.getEventAspect());
            column.pack();
            if (col instanceof TmfMarginColumn) {
                column.setResizable(false);
            } else {
                column.setMoveable(true);
                column.setData("$width", (Object)-1);
            }
            column.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent e) {
                    int[] order = TmfEventsTable.this.fTable.getColumnOrder();
                    if (order[0] == 0) {
                        TmfEventsTable.this.fColumnOrder = order;
                        return;
                    }
                    int i = order.length - 1;
                    while (i > 0) {
                        if (order[i] == 0) {
                            order[i] = order[i - 1];
                            order[i - 1] = 0;
                        }
                        --i;
                    }
                    TmfEventsTable.this.fTable.setColumnOrder(order);
                    TmfEventsTable.this.fColumnOrder = TmfEventsTable.this.fTable.getColumnOrder();
                }
            });
        }
        this.fColumnOrder = this.fTable.getColumnOrder();
        this.fTable.setFrozenRowCount(1);
        this.createHeaderEditor();
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null) {
                    return;
                }
                TmfEventsTable.this.updateStatusLine(null);
                if (TmfEventsTable.this.fTable.getSelectionIndices().length > 0) {
                    if (e.item.getData("$rank") instanceof Long) {
                        TmfEventsTable.this.fSelectedRank = (Long)e.item.getData("$rank");
                        TmfEventsTable.this.fRawViewer.selectAndReveal((Long)e.item.getData("$rank"));
                    } else {
                        TmfEventsTable.this.fSelectedRank = -1L;
                    }
                    if (TmfEventsTable.this.fTable.getSelectionIndices().length == 1) {
                        TmfEventsTable.this.fSelectedBeginRank = TmfEventsTable.this.fSelectedRank;
                    }
                    if (e.item.getData("$time") instanceof ITmfTimestamp) {
                        ITmfTimestamp selectedBeginTimestamp;
                        ITmfTimestamp ts = (ITmfTimestamp)NonNullUtils.checkNotNull((Object)((ITmfTimestamp)e.item.getData("$time")));
                        if (TmfEventsTable.this.fTable.getSelectionIndices().length == 1) {
                            TmfEventsTable.this.fSelectedBeginTimestamp = ts;
                        }
                        if ((selectedBeginTimestamp = TmfEventsTable.this.fSelectedBeginTimestamp) != null) {
                            TmfEventsTable.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)TmfEventsTable.this, selectedBeginTimestamp, ts));
                            if (TmfEventsTable.this.fTable.getSelectionIndices().length == 2) {
                                TmfEventsTable.this.updateStatusLine(ts.getDelta(selectedBeginTimestamp));
                            }
                        }
                    } else if (TmfEventsTable.this.fTable.getSelectionIndices().length == 1) {
                        TmfEventsTable.this.fSelectedBeginTimestamp = null;
                    }
                }
                if (e.item.getData() instanceof ITmfEvent) {
                    TmfEventsTable.this.broadcast((TmfSignal)new TmfEventSelectedSignal((Object)TmfEventsTable.this, (ITmfEvent)e.item.getData()));
                    TmfEventsTable.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)TmfEventsTable.this, (ISelection)new StructuredSelection(e.item.getData())));
                } else {
                    TmfEventsTable.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)TmfEventsTable.this, (ISelection)StructuredSelection.EMPTY));
                }
            }
        });
        int realCacheSize = Math.max(cacheSize, Display.getDefault().getBounds().height / this.fTable.getItemHeight());
        realCacheSize = Math.min(realCacheSize, 1000);
        this.fCache = new TmfEventsCache(realCacheSize, this);
        this.fTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TmfEventsCache.CachedEvent cachedEvent;
                TableItem item = (TableItem)event.item;
                int index = event.index - 1;
                if (event.index == 0) {
                    TmfEventsTable.this.setHeaderRowItemData(item);
                    return;
                }
                if (TmfEventsTable.this.fTable.getData("$fltr_obj") != null) {
                    if (event.index == 1 || event.index == TmfEventsTable.this.fTable.getItemCount() - 1) {
                        TmfEventsTable.this.setFilterStatusRowItemData(item);
                        return;
                    }
                    --index;
                }
                if ((cachedEvent = TmfEventsTable.this.fCache.getEvent(index)) != null) {
                    TmfEventsTable.this.setItemData(item, cachedEvent, cachedEvent.rank);
                    return;
                }
                event.doit = false;
            }
        });
        this.fTable.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                TmfEventsTable.this.fLastMenuCursorLocation = new Point(event.x, event.y);
                Point pt = TmfEventsTable.this.fTable.getDisplay().map(null, (Control)TmfEventsTable.this.fTable, TmfEventsTable.this.fLastMenuCursorLocation);
                Rectangle clientArea = TmfEventsTable.this.fTable.getClientArea();
                boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + TmfEventsTable.this.fTable.getHeaderHeight();
                TmfEventsTable.this.fTable.setMenu(header ? TmfEventsTable.this.fHeaderMenu : TmfEventsTable.this.fTablePopup);
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button != 1) {
                    return;
                }
                Point point = new Point(event.x, event.y);
                TableItem item = TmfEventsTable.this.fTable.getItem(point);
                if (item != null) {
                    Long rank;
                    Rectangle imageBounds = item.getImageBounds(0);
                    imageBounds.width = BOOKMARK_IMAGE.getBounds().width;
                    if (imageBounds.contains(point) && (rank = (Long)item.getData("$rank")) != null) {
                        TmfEventsTable.this.toggleBookmark(rank);
                    }
                }
            }
        });
        Listener tooltipListener = new Listener(){
            Shell tooltipShell = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        TableItem item = TmfEventsTable.this.fTable.getItem(new Point(event.x, event.y));
                        if (item == null) {
                            return;
                        }
                        Long rank = (Long)item.getData("$rank");
                        if (rank == null) {
                            return;
                        }
                        String tooltipText = (String)item.getData("$bookmark");
                        Rectangle bounds = item.getImageBounds(0);
                        bounds.width = BOOKMARK_IMAGE.getBounds().width;
                        if (!bounds.contains(event.x, event.y)) {
                            return;
                        }
                        if (this.tooltipShell != null && !this.tooltipShell.isDisposed()) {
                            this.tooltipShell.dispose();
                        }
                        this.tooltipShell = new Shell(TmfEventsTable.this.fTable.getShell(), 540676);
                        this.tooltipShell.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tooltipShell.setLayout((Layout)layout);
                        Label label = new Label((Composite)this.tooltipShell, 64);
                        String text = String.valueOf(rank.toString()) + (tooltipText != null ? ": " + tooltipText : TmfEventsTable.EMPTY_STRING);
                        label.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(28));
                        label.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
                        label.setText(text);
                        label.addListener(7, (Listener)this);
                        label.addListener(3, (Listener)this);
                        label.addListener(37, (Listener)this);
                        Point size = this.tooltipShell.computeSize(-1, -1);
                        int y = event.y;
                        if (IS_LINUX) {
                            y += TmfEventsTable.this.fTable.getHeaderHeight();
                        }
                        Point pt = TmfEventsTable.this.fTable.toDisplay(event.x, y);
                        pt.x += BOOKMARK_IMAGE.getBounds().width;
                        pt.y += item.getBounds().height;
                        this.tooltipShell.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tooltipShell.setVisible(true);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 12: 
                    case 37: {
                        if (this.tooltipShell == null) break;
                        this.tooltipShell.dispose();
                        this.tooltipShell = null;
                        break;
                    }
                }
            }
        };
        this.fTable.addListener(32, tooltipListener);
        this.fTable.addListener(12, tooltipListener);
        this.fTable.addListener(1, tooltipListener);
        this.fTable.addListener(5, tooltipListener);
        this.fTable.addListener(7, tooltipListener);
        this.fTable.addListener(3, tooltipListener);
        this.fTable.addListener(37, tooltipListener);
        this.fTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                List styleRanges = (List)item.getData("$style_ranges");
                GC gc = event.gc;
                Color background = item.getBackground(event.index);
                if (styleRanges != null || !background.equals((Object)item.getParent().getBackground())) {
                    event.detail &= 0xFFFFFFF7;
                    gc.setBackground(background);
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                }
                event.detail &= 0xFFFFFFEF;
                if (styleRanges != null) {
                    Rectangle textBounds = item.getTextBounds(event.index);
                    String text = item.getText(event.index);
                    for (Object o : styleRanges) {
                        if (!(o instanceof StyleRange)) continue;
                        StyleRange styleRange = (StyleRange)o;
                        if (!styleRange.data.equals(event.index)) continue;
                        int startIndex = styleRange.start;
                        int endIndex = startIndex + styleRange.length;
                        int startX = gc.textExtent((String)text.substring((int)0, (int)startIndex)).x;
                        int endX = gc.textExtent((String)text.substring((int)0, (int)endIndex)).x;
                        gc.setBackground(styleRange.background);
                        gc.fillRectangle(textBounds.x + startX, textBounds.y, endX - startX, textBounds.height);
                    }
                }
            }
        });
        this.fTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                GC gc = event.gc;
                Image image = item.getImage(event.index);
                if (image != null) {
                    Rectangle imageBounds = item.getImageBounds(event.index);
                    if (IS_LINUX) {
                        gc.drawImage(image, imageBounds.x + 1, imageBounds.y + 3);
                    } else {
                        gc.drawImage(image, imageBounds.x, imageBounds.y + 1);
                    }
                }
                gc.setForeground(item.getForeground(event.index));
                gc.setFont(item.getFont(event.index));
                String text = item.getText(event.index);
                Rectangle textBounds = item.getTextBounds(event.index);
                if (IS_LINUX) {
                    gc.drawText(text, textBounds.x + 1, textBounds.y + 3, true);
                } else {
                    gc.drawText(text, textBounds.x - 1, textBounds.y + 2, true);
                }
            }
        });
        this.createResources();
        this.initializeFonts();
        this.initializeColors();
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
        ColorSettingsManager.addColorSettingsListener(this);
        this.fTable.setItemCount(1);
        this.fRawViewer = new TmfRawEventViewer((Composite)this.fSashForm, 768);
        this.fRawViewer.addSelectionListener(new Listener(){

            public void handleEvent(Event e) {
                long rank;
                if (TmfEventsTable.this.fTrace == null) {
                    return;
                }
                if (e.data instanceof Long) {
                    rank = (Long)e.data;
                } else if (e.data instanceof ITmfLocation) {
                    rank = this.findRank((ITmfLocation)e.data);
                } else {
                    return;
                }
                int index = (int)rank;
                if (TmfEventsTable.this.fTable.getData("$fltr_obj") != null) {
                    index = TmfEventsTable.this.fCache.getFilteredEventIndex(rank) + 1;
                }
                TmfEventsTable.this.fTable.setSelection(index + 1);
                TmfEventsTable.this.fSelectedRank = rank;
                TmfEventsTable.this.fSelectedBeginRank = TmfEventsTable.this.fSelectedRank;
                TmfEventsTable.this.updateStatusLine(null);
                TableItem[] selection = TmfEventsTable.this.fTable.getSelection();
                if (selection != null && selection.length > 0) {
                    TableItem item = TmfEventsTable.this.fTable.getSelection()[0];
                    TmfTimestamp ts = (TmfTimestamp)item.getData("$time");
                    if (ts != null) {
                        TmfEventsTable.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)TmfEventsTable.this, (ITmfTimestamp)ts));
                    }
                    if (item.getData() instanceof ITmfEvent) {
                        TmfEventsTable.this.broadcast((TmfSignal)new TmfEventSelectedSignal((Object)TmfEventsTable.this, (ITmfEvent)item.getData()));
                        TmfEventsTable.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)TmfEventsTable.this, (ISelection)new StructuredSelection(item.getData())));
                    } else {
                        TmfEventsTable.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)TmfEventsTable.this, (ISelection)StructuredSelection.EMPTY));
                    }
                }
            }

            private long findRank(ITmfLocation selectedLocation) {
                double selectedRatio = TmfEventsTable.this.fTrace.getLocationRatio(selectedLocation);
                long low = 0L;
                long high = TmfEventsTable.this.fTrace.getNbEvents();
                long rank = high / 2L;
                double ratio = -1.0;
                while (ratio != selectedRatio) {
                    ITmfContext context = TmfEventsTable.this.fTrace.seekEvent(rank);
                    ratio = TmfEventsTable.this.fTrace.getLocationRatio(context.getLocation());
                    context.dispose();
                    if (ratio < selectedRatio) {
                        low = rank;
                        rank = (rank + high) / 2L;
                    } else if (ratio > selectedRatio) {
                        high = rank;
                        rank = (rank + low) / 2L;
                    }
                    if (high - low < 2L) break;
                }
                return rank;
            }
        });
        this.fSashForm.setWeights(new int[]{1, 1});
        this.fRawViewer.setVisible(false);
        this.createPopupMenu();
    }

    private static IAction createHeaderAction(final TableColumn column) {
        Action columnMenuAction = new Action(column.getText(), 2){

            public void run() {
                if (this.isChecked()) {
                    column.setWidth(((Integer)column.getData("$width")).intValue());
                    column.setResizable(true);
                } else {
                    column.setData("$width", (Object)column.getWidth());
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        };
        columnMenuAction.setChecked(column.getResizable());
        return columnMenuAction;
    }

    private IAction createResetHeaderAction() {
        return new Action(Messages.TmfEventsTable_ShowAll){

            public void run() {
                TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    Object widthVal = column.getData("$width");
                    if (widthVal instanceof Integer) {
                        Integer width = (Integer)widthVal;
                        if (!column.getResizable()) {
                            column.setWidth(width.intValue());
                            column.setResizable(true);
                            if (IS_LINUX) {
                                column.pack();
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
    }

    private void createPopupMenu() {
        Action copyAction = new Action(Messages.TmfEventsTable_CopyToClipboardActionText){

            public void run() {
                ITmfTrace trace = TmfEventsTable.this.fTrace;
                if (trace == null || TmfEventsTable.this.fSelectedRank == -1L && TmfEventsTable.this.fSelectedBeginRank == -1L) {
                    return;
                }
                ArrayList<TmfEventTableColumn> columns = new ArrayList<TmfEventTableColumn>();
                int[] nArray = TmfEventsTable.this.fTable.getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    TableColumn column = TmfEventsTable.this.fTable.getColumns()[i];
                    if (i >= 1 && (column.getResizable() || column.getWidth() > 0)) {
                        columns.add((TmfEventTableColumn)TmfEventsTable.this.fColumns.get(i));
                    }
                    ++n2;
                }
                long start = Math.min(TmfEventsTable.this.fSelectedBeginRank, TmfEventsTable.this.fSelectedRank);
                long end = Math.max(TmfEventsTable.this.fSelectedBeginRank, TmfEventsTable.this.fSelectedRank);
                ITmfFilter filter = (ITmfFilter)TmfEventsTable.this.fTable.getData("$fltr_obj");
                CopyToClipboardOperation operation = new CopyToClipboardOperation(trace, filter, columns, start, end);
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
                }
                catch (InvocationTargetException e) {
                    Activator.getDefault().logError("Invocation target exception copying to clipboard ", e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Action showTableAction = new Action(Messages.TmfEventsTable_ShowTableActionText){

            public void run() {
                TmfEventsTable.this.fTable.setVisible(true);
                TmfEventsTable.this.fSashForm.layout();
            }
        };
        Action hideTableAction = new Action(Messages.TmfEventsTable_HideTableActionText){

            public void run() {
                TmfEventsTable.this.fTable.setVisible(false);
                TmfEventsTable.this.fSashForm.layout();
            }
        };
        Action showRawAction = new Action(Messages.TmfEventsTable_ShowRawActionText){

            public void run() {
                TmfEventsTable.this.fRawViewer.setVisible(true);
                TmfEventsTable.this.fSashForm.layout();
                int index = TmfEventsTable.this.fTable.getSelectionIndex();
                if (index >= 1) {
                    TmfEventsTable.this.fRawViewer.selectAndReveal(index - 1);
                }
            }
        };
        Action hideRawAction = new Action(Messages.TmfEventsTable_HideRawActionText){

            public void run() {
                TmfEventsTable.this.fRawViewer.setVisible(false);
                TmfEventsTable.this.fSashForm.layout();
            }
        };
        Action openCallsiteAction = new Action(Messages.TmfEventsTable_OpenSourceCodeActionText){

            public void run() {
                TableItem[] items = TmfEventsTable.this.fTable.getSelection();
                if (items.length != 1) {
                    return;
                }
                TableItem item = items[0];
                Object data = item.getData();
                if (data instanceof ITmfSourceLookup) {
                    ITmfSourceLookup event = (ITmfSourceLookup)data;
                    ITmfCallsite cs = event.getCallsite();
                    if (cs == null || cs.getFileName() == null) {
                        return;
                    }
                    IMarker marker = null;
                    try {
                        String fileName = cs.getFileName();
                        final String trimmedPath = fileName.replaceAll("\\.\\./", TmfEventsTable.EMPTY_STRING);
                        final ArrayList files = new ArrayList();
                        ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource instanceof IFile && resource.getFullPath().toString().endsWith(trimmedPath)) {
                                    files.add((IFile)resource);
                                }
                                return true;
                            }
                        });
                        IFile file = null;
                        if (files.size() > 1) {
                            ListDialog dialog = new ListDialog(TmfEventsTable.this.getTable().getShell());
                            dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                            dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                                public String getText(Object element) {
                                    return ((IFile)element).getFullPath().toString();
                                }
                            });
                            dialog.setInput(files);
                            dialog.setTitle(Messages.TmfEventsTable_OpenSourceCodeSelectFileDialogTitle);
                            dialog.setMessage(String.valueOf(Messages.TmfEventsTable_OpenSourceCodeSelectFileDialogTitle) + '\n' + cs.toString());
                            dialog.open();
                            Object[] result = dialog.getResult();
                            if (result != null && result.length > 0) {
                                file = (IFile)result[0];
                            }
                        } else if (files.size() == 1) {
                            file = (IFile)files.get(0);
                        }
                        if (file != null) {
                            marker = file.createMarker("org.eclipse.core.resources.marker");
                            marker.setAttribute("lineNumber", Long.valueOf(cs.getLineNumber()).intValue());
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
                            marker.delete();
                        } else if (files.size() == 0) {
                            TmfEventsTable.displayException(new FileNotFoundException(String.valueOf('\'') + cs.toString() + '\'' + '\n' + Messages.TmfEventsTable_OpenSourceCodeNotFound));
                        }
                    }
                    catch (CoreException e) {
                        TmfEventsTable.displayException((Exception)((Object)e));
                    }
                }
            }
        };
        Action openModelAction = new Action(Messages.TmfEventsTable_OpenModelActionText){

            public void run() {
                String modelURI;
                TableItem[] items = TmfEventsTable.this.fTable.getSelection();
                if (items.length != 1) {
                    return;
                }
                TableItem item = items[0];
                Object eventData = item.getData();
                if (eventData instanceof ITmfModelLookup && (modelURI = ((ITmfModelLookup)eventData).getModelUri()) != null) {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IFile file = null;
                    URI uri = URI.createURI((String)modelURI);
                    if (uri.isPlatformResource()) {
                        Path path = new Path(uri.toPlatformString(true));
                        file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    } else if (uri.isFile() && !uri.isRelative()) {
                        file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
                    }
                    if (file != null) {
                        try {
                            IMarker marker = file.createMarker("org.eclipse.emf.ecore.diagnostic");
                            marker.setAttribute("uri", (Object)modelURI);
                            marker.setAttribute("severity", 0);
                            IDE.openEditor((IWorkbenchPage)activePage, (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
                            marker.delete();
                        }
                        catch (CoreException e) {
                            TmfEventsTable.displayException((Exception)((Object)e));
                        }
                    } else {
                        TmfEventsTable.displayException(new FileNotFoundException(String.valueOf('\'') + modelURI + '\'' + '\n' + Messages.TmfEventsTable_OpenModelUnsupportedURI));
                    }
                }
            }
        };
        Action exportToTextAction = new Action(Messages.TmfEventsTable_Export_to_text){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                Object handlerServiceObject = activePage.getActiveEditor().getSite().getService(IHandlerService.class);
                IHandlerService handlerService = (IHandlerService)handlerServiceObject;
                Object cmdServiceObject = activePage.getActiveEditor().getSite().getService(ICommandService.class);
                ICommandService cmdService = (ICommandService)cmdServiceObject;
                try {
                    HashMap parameters = new HashMap();
                    Command command = cmdService.getCommand("org.eclipse.linuxtools.tmf.ui.exportToText");
                    ParameterizedCommand cmd = ParameterizedCommand.generateCommand((Command)command, parameters);
                    IEvaluationContext context = handlerService.getCurrentState();
                    ArrayList<TmfEventTableColumn> exportColumns = new ArrayList<TmfEventTableColumn>();
                    int[] nArray = TmfEventsTable.this.fTable.getColumnOrder();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        TableColumn column = TmfEventsTable.this.fTable.getColumns()[i];
                        if (i >= 1 && (column.getResizable() || column.getWidth() > 0)) {
                            exportColumns.add((TmfEventTableColumn)TmfEventsTable.this.fColumns.get(i));
                        }
                        ++n2;
                    }
                    context.addVariable("org.eclipse.linuxtools.tmf.ui.exportToText.columns", exportColumns);
                    handlerService.executeCommandInContext(cmd, null, context);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    TmfEventsTable.displayException((Exception)e);
                }
            }
        };
        Action showSearchBarAction = new Action(Messages.TmfEventsTable_ShowSearchBarActionText){

            public void run() {
                TmfEventsTable.this.fHeaderState = HeaderState.SEARCH;
                TmfEventsTable.this.fTable.refresh();
                TmfEventsTable.this.fTable.redraw();
            }
        };
        Action showFilterBarAction = new Action(Messages.TmfEventsTable_ShowFilterBarActionText){

            public void run() {
                TmfEventsTable.this.fHeaderState = HeaderState.FILTER;
                TmfEventsTable.this.fTable.refresh();
                TmfEventsTable.this.fTable.redraw();
            }
        };
        Action clearFiltersAction = new Action(Messages.TmfEventsTable_ClearFiltersActionText){

            public void run() {
                TmfEventsTable.this.clearFilters();
            }
        };
        Action collapseAction = new Action(Messages.TmfEventsTable_CollapseFilterMenuName){

            public void run() {
                TmfEventsTable.this.applyFilter((ITmfFilter)new TmfCollapseFilter());
            }
        };
        this.fHeaderPopupMenuManager = new MenuManager();
        this.fHeaderPopupMenuManager.setRemoveAllWhenShown(true);
        this.fHeaderPopupMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int[] nArray = TmfEventsTable.this.fTable.getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    if (TmfEventsTable.this.fTable.getColumns()[index].getData("$width") != null) {
                        TmfEventsTable.this.fHeaderPopupMenuManager.add(TmfEventsTable.createHeaderAction(TmfEventsTable.this.fTable.getColumns()[index]));
                    }
                    ++n2;
                }
                TmfEventsTable.this.fHeaderPopupMenuManager.add((IContributionItem)new Separator());
                TmfEventsTable.this.fHeaderPopupMenuManager.add(TmfEventsTable.this.createResetHeaderAction());
            }
        });
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(new IMenuListener((IAction)showSearchBarAction, (IAction)showFilterBarAction, (IAction)copyAction, (IAction)hideTableAction, (IAction)hideRawAction, (IAction)showTableAction, (IAction)showRawAction, (IAction)exportToTextAction, (IAction)openCallsiteAction, (IAction)openModelAction, (IAction)collapseAction, (IAction)clearFiltersAction){
            private final /* synthetic */ IAction val$showSearchBarAction;
            private final /* synthetic */ IAction val$showFilterBarAction;
            private final /* synthetic */ IAction val$copyAction;
            private final /* synthetic */ IAction val$hideTableAction;
            private final /* synthetic */ IAction val$hideRawAction;
            private final /* synthetic */ IAction val$showTableAction;
            private final /* synthetic */ IAction val$showRawAction;
            private final /* synthetic */ IAction val$exportToTextAction;
            private final /* synthetic */ IAction val$openCallsiteAction;
            private final /* synthetic */ IAction val$openModelAction;
            private final /* synthetic */ IAction val$collapseAction;
            private final /* synthetic */ IAction val$clearFiltersAction;
            {
                this.val$showSearchBarAction = iAction;
                this.val$showFilterBarAction = iAction2;
                this.val$copyAction = iAction3;
                this.val$hideTableAction = iAction4;
                this.val$hideRawAction = iAction5;
                this.val$showTableAction = iAction6;
                this.val$showRawAction = iAction7;
                this.val$exportToTextAction = iAction8;
                this.val$openCallsiteAction = iAction9;
                this.val$openModelAction = iAction10;
                this.val$collapseAction = iAction11;
                this.val$clearFiltersAction = iAction12;
            }

            public void menuAboutToShow(IMenuManager manager) {
                TableItem item;
                if (TmfEventsTable.this.fTable.getSelectionIndices().length == 1 && TmfEventsTable.this.fTable.getSelectionIndices()[0] == 0) {
                    if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                        TmfEventsTable.this.fTablePopupMenuManager.add(this.val$showSearchBarAction);
                    } else {
                        TmfEventsTable.this.fTablePopupMenuManager.add(this.val$showFilterBarAction);
                    }
                    return;
                }
                Point point = TmfEventsTable.this.fTable.toControl(TmfEventsTable.this.fLastMenuCursorLocation);
                TableItem tableItem = item = TmfEventsTable.this.fTable.getSelection().length > 0 ? TmfEventsTable.this.fTable.getSelection()[0] : null;
                if (item != null) {
                    Rectangle imageBounds = item.getImageBounds(0);
                    imageBounds.width = BOOKMARK_IMAGE.getBounds().width;
                    if (point.x <= imageBounds.x + imageBounds.width) {
                        Long rank = (Long)item.getData("$rank");
                        if (rank != null && TmfEventsTable.this.fBookmarksFile != null) {
                            class ToggleBookmarkAction
                            extends Action {
                                Long fRank;

                                public ToggleBookmarkAction(String text, Long rank) {
                                    super(text);
                                    this.fRank = rank;
                                }

                                public void run() {
                                    TmfEventsTable.this.toggleBookmark(this.fRank);
                                }
                            }
                            if (TmfEventsTable.this.fBookmarksMap.containsKey((Object)rank)) {
                                TmfEventsTable.this.fTablePopupMenuManager.add((IAction)new ToggleBookmarkAction(Messages.TmfEventsTable_RemoveBookmarkActionText, rank));
                            } else {
                                TmfEventsTable.this.fTablePopupMenuManager.add((IAction)new ToggleBookmarkAction(Messages.TmfEventsTable_AddBookmarkActionText, rank));
                            }
                        }
                        return;
                    }
                }
                if (TmfEventsTable.this.fSelectedRank != -1L && TmfEventsTable.this.fSelectedBeginRank != -1L) {
                    TmfEventsTable.this.fTablePopupMenuManager.add(this.val$copyAction);
                    TmfEventsTable.this.fTablePopupMenuManager.add((IContributionItem)new Separator());
                }
                if (TmfEventsTable.this.fTable.isVisible() && TmfEventsTable.this.fRawViewer.isVisible()) {
                    TmfEventsTable.this.fTablePopupMenuManager.add(this.val$hideTableAction);
                    TmfEventsTable.this.fTablePopupMenuManager.add(this.val$hideRawAction);
                } else if (!TmfEventsTable.this.fTable.isVisible()) {
                    TmfEventsTable.this.fTablePopupMenuManager.add(this.val$showTableAction);
                } else if (!TmfEventsTable.this.fRawViewer.isVisible()) {
                    TmfEventsTable.this.fTablePopupMenuManager.add(this.val$showRawAction);
                }
                TmfEventsTable.this.fTablePopupMenuManager.add(this.val$exportToTextAction);
                TmfEventsTable.this.fTablePopupMenuManager.add((IContributionItem)new Separator());
                if (item != null) {
                    Object event;
                    Object data = item.getData();
                    Separator separator = null;
                    if (data instanceof ITmfSourceLookup && (event = (ITmfSourceLookup)data).getCallsite() != null) {
                        TmfEventsTable.this.fTablePopupMenuManager.add(this.val$openCallsiteAction);
                        separator = new Separator();
                    }
                    if (data instanceof ITmfModelLookup) {
                        event = (ITmfModelLookup)data;
                        if (event.getModelUri() != null) {
                            TmfEventsTable.this.fTablePopupMenuManager.add(this.val$openModelAction);
                            separator = new Separator();
                        }
                        if (separator != null) {
                            TmfEventsTable.this.fTablePopupMenuManager.add((IContributionItem)separator);
                        }
                    }
                }
                boolean isCollapsible = false;
                if (TmfEventsTable.this.fTrace != null) {
                    for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)TmfEventsTable.this.fTrace)) {
                        Class eventClass = trace.getEventType();
                        isCollapsible = ITmfCollapsibleEvent.class.isAssignableFrom(eventClass);
                        if (isCollapsible) break;
                    }
                }
                if (isCollapsible && !(TmfEventsTable.this.fTable.getData("$fltr_obj") instanceof TmfCollapseFilter)) {
                    TmfEventsTable.this.fTablePopupMenuManager.add(this.val$collapseAction);
                    TmfEventsTable.this.fTablePopupMenuManager.add((IContributionItem)new Separator());
                }
                TmfEventsTable.this.fTablePopupMenuManager.add(this.val$clearFiltersAction);
                ITmfFilterTreeNode[] savedFilters = FilterManager.getSavedFilters();
                if (savedFilters.length > 0) {
                    MenuManager subMenu = new MenuManager(Messages.TmfEventsTable_ApplyPresetFilterMenuName);
                    ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = savedFilters;
                    int n = savedFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
                        if (node instanceof TmfFilterNode) {
                            final TmfFilterNode filter = (TmfFilterNode)node;
                            subMenu.add((IAction)new Action(filter.getFilterName()){

                                public void run() {
                                    TmfEventsTable.this.applyFilter((ITmfFilter)filter);
                                }
                            });
                        }
                        ++n2;
                    }
                    TmfEventsTable.this.fTablePopupMenuManager.add((IContributionItem)subMenu);
                }
                TmfEventsTable.this.appendToTablePopupMenu(TmfEventsTable.this.fTablePopupMenuManager, item);
            }
        });
        this.fRawViewerPopupMenuManager = new MenuManager();
        this.fRawViewerPopupMenuManager.setRemoveAllWhenShown(true);
        this.fRawViewerPopupMenuManager.addMenuListener(new IMenuListener((IAction)hideTableAction, (IAction)hideRawAction, (IAction)showTableAction, (IAction)showRawAction){
            private final /* synthetic */ IAction val$hideTableAction;
            private final /* synthetic */ IAction val$hideRawAction;
            private final /* synthetic */ IAction val$showTableAction;
            private final /* synthetic */ IAction val$showRawAction;
            {
                this.val$hideTableAction = iAction;
                this.val$hideRawAction = iAction2;
                this.val$showTableAction = iAction3;
                this.val$showRawAction = iAction4;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (TmfEventsTable.this.fTable.isVisible() && TmfEventsTable.this.fRawViewer.isVisible()) {
                    TmfEventsTable.this.fRawViewerPopupMenuManager.add(this.val$hideTableAction);
                    TmfEventsTable.this.fRawViewerPopupMenuManager.add(this.val$hideRawAction);
                } else if (!TmfEventsTable.this.fTable.isVisible()) {
                    TmfEventsTable.this.fRawViewerPopupMenuManager.add(this.val$showTableAction);
                } else if (!TmfEventsTable.this.fRawViewer.isVisible()) {
                    TmfEventsTable.this.fRawViewerPopupMenuManager.add(this.val$showRawAction);
                }
                TmfEventsTable.this.appendToRawPopupMenu(TmfEventsTable.this.fRawViewerPopupMenuManager);
            }
        });
        this.fHeaderMenu = this.fHeaderPopupMenuManager.createContextMenu((Control)this.fTable);
        this.fTablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(this.fTablePopup);
        this.fRawTablePopup = this.fRawViewerPopupMenuManager.createContextMenu((Control)this.fRawViewer);
        this.fRawViewer.setMenu(this.fRawTablePopup);
    }

    protected void appendToTablePopupMenu(MenuManager tablePopupMenu, TableItem selectedItem) {
    }

    protected void appendToRawPopupMenu(MenuManager rawViewerPopupMenu) {
    }

    public void dispose() {
        this.stopSearchThread();
        this.stopFilterThread();
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        ColorSettingsManager.removeColorSettingsListener(this);
        this.fComposite.dispose();
        if (this.fTrace != null && this.fDisposeOnClose) {
            this.fTrace.dispose();
        }
        this.fResourceManager.dispose();
        this.fRawViewer.dispose();
        if (this.fRawViewerPopupMenuManager != null) {
            this.fRawViewerPopupMenuManager.dispose();
        }
        if (this.fHeaderPopupMenuManager != null) {
            this.fHeaderPopupMenuManager.dispose();
        }
        if (this.fTablePopupMenuManager != null) {
            this.fTablePopupMenuManager.dispose();
        }
        super.dispose();
    }

    public void setLayoutData(Object layoutData) {
        this.fComposite.setLayoutData(layoutData);
    }

    public TmfVirtualTable getTable() {
        return this.fTable;
    }

    @Deprecated
    protected void setColumnHeaders(ColumnData[] columnData) {
    }

    protected void setItemData(TableItem item, ITmfEvent event, long rank) {
        String[] itemStrings = TmfEventsTable.getItemStrings(this.fColumns, event);
        ITmfEvent tmfEvent = event;
        if (event instanceof TmfEventsCache.CachedEvent) {
            tmfEvent = ((TmfEventsCache.CachedEvent)event).event;
        }
        item.setText(itemStrings);
        item.setData((Object)tmfEvent);
        item.setData("$time", (Object)new TmfTimestamp(tmfEvent.getTimestamp()));
        item.setData("$rank", (Object)rank);
        Collection markerIds = this.fBookmarksMap.get((Object)rank);
        if (!markerIds.isEmpty()) {
            Joiner joiner = Joiner.on((String)"\n -").skipNulls();
            ArrayList<Object> parts = new ArrayList<Object>();
            if (markerIds.size() > 1) {
                parts.add(Messages.TmfEventsTable_MultipleBookmarksToolTip);
            }
            try {
                Iterator iterator = markerIds.iterator();
                while (iterator.hasNext()) {
                    long markerId = (Long)iterator.next();
                    IMarker marker = this.fBookmarksFile.findMarker(markerId);
                    parts.add(marker.getAttribute("message"));
                }
            }
            catch (CoreException e) {
                TmfEventsTable.displayException((Exception)((Object)e));
            }
            item.setData("$bookmark", (Object)joiner.join(parts));
        } else {
            item.setData("$bookmark", null);
        }
        boolean searchMatch = false;
        boolean searchNoMatch = false;
        ITmfFilter searchFilter = (ITmfFilter)this.fTable.getData("$srch_obj");
        if (searchFilter != null) {
            if (searchFilter.matches(tmfEvent)) {
                searchMatch = true;
            } else {
                searchNoMatch = true;
            }
        }
        ColorSetting colorSetting = ColorSettingsManager.getColorSetting(tmfEvent);
        if (searchNoMatch) {
            item.setForeground(colorSetting.getDimmedForegroundColor());
            item.setBackground(colorSetting.getDimmedBackgroundColor());
        } else {
            item.setForeground(colorSetting.getForegroundColor());
            item.setBackground(colorSetting.getBackgroundColor());
        }
        item.setFont(this.fFont);
        if (searchMatch) {
            if (!markerIds.isEmpty()) {
                item.setImage(SEARCH_MATCH_BOOKMARK_IMAGE);
            } else {
                item.setImage(SEARCH_MATCH_IMAGE);
            }
        } else if (!markerIds.isEmpty()) {
            item.setImage(BOOKMARK_IMAGE);
        } else {
            item.setImage(null);
        }
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        int index = 0;
        while (index < this.fTable.getColumns().length) {
            TableColumn column = this.fTable.getColumns()[index];
            String regex = null;
            if (this.fHeaderState == HeaderState.FILTER) {
                regex = (String)column.getData("$fltr_txt");
            } else if (searchMatch) {
                regex = (String)column.getData("$srch_txt");
            }
            if (regex != null) {
                String text = item.getText(index);
                try {
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(text);
                    while (matcher.find()) {
                        int start = matcher.start();
                        int length = matcher.end() - start;
                        Color foreground = colorSetting.getForegroundColor();
                        Color background = this.fHighlightColor;
                        StyleRange styleRange = new StyleRange(start, length, foreground, background);
                        styleRange.data = index;
                        styleRanges.add(styleRange);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            ++index;
        }
        if (styleRanges.isEmpty()) {
            item.setData("$style_ranges", null);
        } else {
            item.setData("$style_ranges", styleRanges);
        }
        item.getParent().redraw();
        if (itemStrings[0] != null && !itemStrings[0].isEmpty()) {
            this.packMarginColumn();
        }
    }

    protected void setHeaderRowItemData(TableItem item) {
        String txtKey = null;
        if (this.fHeaderState == HeaderState.SEARCH) {
            item.setImage(SEARCH_IMAGE);
            txtKey = "$srch_txt";
        } else if (this.fHeaderState == HeaderState.FILTER) {
            item.setImage(FILTER_IMAGE);
            txtKey = "$fltr_txt";
        }
        item.setForeground(this.fGrayColor);
        int i = 1;
        while (i < this.fTable.getColumns().length) {
            TableColumn column = this.fTable.getColumns()[i];
            String filter = (String)column.getData(txtKey);
            if (filter == null) {
                if (this.fHeaderState == HeaderState.SEARCH) {
                    item.setText(i, SEARCH_HINT);
                } else if (this.fHeaderState == HeaderState.FILTER) {
                    item.setText(i, FILTER_HINT);
                }
                item.setForeground(i, this.fGrayColor);
                item.setFont(i, this.fFont);
            } else {
                item.setText(i, filter);
                item.setForeground(i, this.fGreenColor);
                item.setFont(i, this.fBoldFont);
            }
            ++i;
        }
    }

    protected void setFilterStatusRowItemData(TableItem item) {
        int i = 0;
        while (i < this.fTable.getColumns().length) {
            if (i == 0) {
                if (this.fTrace == null || this.fFilterCheckCount == this.fTrace.getNbEvents()) {
                    item.setImage(FILTER_IMAGE);
                } else {
                    item.setImage(STOP_IMAGE);
                }
            }
            if (i == 1) {
                item.setText(1, String.valueOf(this.fFilterMatchCount) + "/" + this.fFilterCheckCount);
            } else {
                item.setText(i, EMPTY_STRING);
            }
            ++i;
        }
        item.setData(null);
        item.setData("$time", null);
        item.setData("$rank", null);
        item.setData("$style_ranges", null);
        item.setForeground(null);
        item.setBackground(null);
        item.setFont(this.fFont);
    }

    private void createHeaderEditor() {
        final TableEditor tableEditor = this.fTable.createTableEditor();
        tableEditor.horizontalAlignment = 16384;
        tableEditor.verticalAlignment = 0x1000000;
        tableEditor.grabHorizontal = true;
        tableEditor.minimumWidth = 50;
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){
            int columnIndex;
            TableColumn column;
            TableItem item;

            public void mouseDown(MouseEvent event) {
                if (event.button != 1) {
                    return;
                }
                Point point = new Point(event.x, event.y);
                this.item = TmfEventsTable.this.fTable.getItem(point);
                if (this.item != null && TmfEventsTable.this.fTable.indexOf(this.item) == 0) {
                    if (this.item.getBounds(0).contains(point)) {
                        if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                            TmfEventsTable.this.fHeaderState = HeaderState.FILTER;
                        } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                            TmfEventsTable.this.fHeaderState = HeaderState.SEARCH;
                        }
                        TmfEventsTable.this.fTable.setSelection(0);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.fTable.redraw();
                        return;
                    }
                    this.columnIndex = -1;
                    int i = 0;
                    while (i < TmfEventsTable.this.fTable.getColumns().length) {
                        Rectangle rect = this.item.getBounds(i);
                        if (rect.contains(point)) {
                            this.columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (this.columnIndex == -1) {
                        return;
                    }
                    this.column = TmfEventsTable.this.fTable.getColumns()[this.columnIndex];
                    String txtKey = null;
                    if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                        txtKey = "$srch_txt";
                    } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                        txtKey = "$fltr_txt";
                    }
                    final Text newEditor = (Text)TmfEventsTable.this.fTable.createTableEditorControl(Text.class);
                    String headerString = (String)this.column.getData(txtKey);
                    if (headerString != null) {
                        newEditor.setText(headerString);
                    }
                    newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            boolean changed = this.updateHeader(newEditor.getText());
                            if (changed) {
                                this.applyHeader();
                            }
                        }
                    });
                    newEditor.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            if (e.character == '\r') {
                                this.updateHeader(newEditor.getText());
                                this.applyHeader();
                                TmfEventsTable.this.getTable().setFocus();
                            } else if (e.character == '\u001b') {
                                tableEditor.getEditor().dispose();
                            }
                        }
                    });
                    newEditor.selectAll();
                    newEditor.setFocus();
                    tableEditor.setEditor((Control)newEditor, this.item, this.columnIndex);
                }
            }

            private boolean updateHeader(String regex) {
                String objKey = null;
                String txtKey = null;
                if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                    objKey = "$srch_obj";
                    txtKey = "$srch_txt";
                } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                    objKey = "$fltr_obj";
                    txtKey = "$fltr_txt";
                }
                if (regex.length() > 0) {
                    block8: {
                        try {
                            Pattern.compile(regex);
                            if (!regex.equals(this.column.getData(txtKey))) break block8;
                            tableEditor.getEditor().dispose();
                            return false;
                        }
                        catch (PatternSyntaxException ex) {
                            tableEditor.getEditor().dispose();
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ex.getDescription(), (String)ex.getMessage());
                            return false;
                        }
                    }
                    TmfFilterMatchesNode filter = new TmfFilterMatchesNode(null);
                    ITmfEventAspect aspect = (ITmfEventAspect)this.column.getData("$aspect");
                    filter.setEventAspect(aspect);
                    filter.setRegex(regex);
                    this.column.setData(objKey, (Object)filter);
                    this.column.setData(txtKey, (Object)regex);
                }
                if (this.column.getData(txtKey) == null) {
                    tableEditor.getEditor().dispose();
                    return false;
                }
                this.column.setData(objKey, null);
                this.column.setData(txtKey, null);
                return true;
            }

            private void applyHeader() {
                if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                    TmfEventsTable.this.stopSearchThread();
                    TmfFilterAndNode filter = new TmfFilterAndNode(null);
                    TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn col = tableColumnArray[n2];
                        Object filterObj = col.getData("$srch_obj");
                        if (filterObj instanceof ITmfFilterTreeNode) {
                            filter.addChild((ITmfFilterTreeNode)filterObj);
                        }
                        ++n2;
                    }
                    if (filter.getChildrenCount() > 0) {
                        TmfEventsTable.this.fTable.setData("$srch_obj", filter);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.searchNext();
                        TmfEventsTable.this.fireSearchApplied((ITmfFilter)filter);
                    } else {
                        TmfEventsTable.this.fTable.setData("$srch_obj", null);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.fireSearchApplied(null);
                    }
                } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                    TmfFilterAndNode filter = new TmfFilterAndNode(null);
                    TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                    int n = tableColumnArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableColumn col = tableColumnArray[n3];
                        Object filterObj = col.getData("$fltr_obj");
                        if (filterObj instanceof ITmfFilterTreeNode) {
                            filter.addChild((ITmfFilterTreeNode)filterObj);
                        }
                        ++n3;
                    }
                    if (filter.getChildrenCount() > 0) {
                        TmfEventsTable.this.applyFilter((ITmfFilter)filter);
                    } else {
                        TmfEventsTable.this.clearFilters();
                    }
                }
                tableEditor.getEditor().dispose();
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                e.doit = false;
                if (e.character == '\u001b') {
                    TmfEventsTable.this.stopFilterThread();
                    TmfEventsTable.this.stopSearchThread();
                    TmfEventsTable.this.fTable.refresh();
                } else if (e.character == '\u007f') {
                    if (TmfEventsTable.this.fHeaderState == HeaderState.SEARCH) {
                        TmfEventsTable.this.stopSearchThread();
                        TableColumn[] tableColumnArray = TmfEventsTable.this.fTable.getColumns();
                        int n = tableColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableColumn column = tableColumnArray[n2];
                            column.setData("$srch_obj", null);
                            column.setData("$srch_txt", null);
                            ++n2;
                        }
                        TmfEventsTable.this.fTable.setData("$srch_obj", null);
                        TmfEventsTable.this.fTable.refresh();
                        TmfEventsTable.this.fireSearchApplied(null);
                    } else if (TmfEventsTable.this.fHeaderState == HeaderState.FILTER) {
                        TmfEventsTable.this.clearFilters();
                    }
                } else if (e.character == '\r') {
                    if ((e.stateMask & 0x20000) == 0) {
                        TmfEventsTable.this.searchNext();
                    } else {
                        TmfEventsTable.this.searchPrevious();
                    }
                }
            }
        });
    }

    protected void fireFilterApplied(ITmfFilter filter) {
        this.broadcast((TmfSignal)new TmfEventFilterAppliedSignal((Object)this, this.fTrace, filter));
    }

    protected void fireSearchApplied(ITmfFilter filter) {
        this.broadcast((TmfSignal)new TmfEventSearchAppliedSignal((Object)this, this.fTrace, filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startFilterThread() {
        Object object = this.fFilterSyncObj;
        synchronized (object) {
            ITmfFilterTreeNode filter = (ITmfFilterTreeNode)this.fTable.getData("$fltr_obj");
            if (this.fFilterThread == null || this.fFilterThread.filter != filter) {
                if (this.fFilterThread != null) {
                    this.fFilterThread.cancel();
                    this.fFilterThreadResume = false;
                }
                this.fFilterThread = new FilterThread(filter);
                this.fFilterThread.start();
            } else {
                this.fFilterThreadResume = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopFilterThread() {
        Object object = this.fFilterSyncObj;
        synchronized (object) {
            if (this.fFilterThread != null) {
                this.fFilterThread.cancel();
                this.fFilterThread = null;
                this.fFilterThreadResume = false;
            }
        }
    }

    protected void applyFilter(ITmfFilter filter) {
        this.stopFilterThread();
        this.stopSearchThread();
        this.fFilterMatchCount = 0L;
        this.fFilterCheckCount = 0L;
        this.fCache.applyFilter(filter);
        this.fTable.clearAll();
        this.fTable.setData("$fltr_obj", filter);
        this.fTable.setItemCount(3);
        this.startFilterThread();
        this.fireFilterApplied(filter);
    }

    protected void clearFilters() {
        if (this.fTable.getData("$fltr_obj") == null) {
            return;
        }
        this.stopFilterThread();
        this.stopSearchThread();
        this.fCache.clearFilter();
        this.fTable.clearAll();
        TableColumn[] tableColumnArray = this.fTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setData("$fltr_obj", null);
            column.setData("$fltr_txt", null);
            ++n2;
        }
        this.fTable.setData("$fltr_obj", null);
        if (this.fTrace != null) {
            this.fTable.setItemCount((int)this.fTrace.getNbEvents() + 1);
        } else {
            this.fTable.setItemCount(1);
        }
        this.fFilterMatchCount = 0L;
        this.fFilterCheckCount = 0L;
        if (this.fSelectedRank >= 0L) {
            this.fTable.setSelection((int)this.fSelectedRank + 1);
        } else {
            this.fTable.setSelection(0);
        }
        this.fireFilterApplied(null);
        this.updateStatusLine(null);
        this.fTable.getColumns()[0].setWidth(0);
        this.packMarginColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchNext() {
        Object object = this.fSearchSyncObj;
        synchronized (object) {
            if (this.fSearchThread != null) {
                return;
            }
            ITmfFilterTreeNode searchFilter = (ITmfFilterTreeNode)this.fTable.getData("$srch_obj");
            if (searchFilter == null) {
                return;
            }
            int selectionIndex = this.fTable.getSelectionIndex();
            int startIndex = selectionIndex > 0 ? selectionIndex : Math.max(0, this.fTable.getTopIndex() - 1);
            ITmfFilterTreeNode eventFilter = (ITmfFilterTreeNode)this.fTable.getData("$fltr_obj");
            if (eventFilter != null) {
                startIndex = Math.max(0, startIndex - 1);
            }
            this.fSearchThread = new SearchThread(searchFilter, eventFilter, startIndex, this.fSelectedRank, 1);
            this.fSearchThread.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchPrevious() {
        Object object = this.fSearchSyncObj;
        synchronized (object) {
            if (this.fSearchThread != null) {
                return;
            }
            ITmfFilterTreeNode searchFilter = (ITmfFilterTreeNode)this.fTable.getData("$srch_obj");
            if (searchFilter == null) {
                return;
            }
            int selectionIndex = this.fTable.getSelectionIndex();
            int startIndex = selectionIndex > 0 ? selectionIndex - 2 : this.fTable.getTopIndex() - 2;
            ITmfFilterTreeNode eventFilter = (ITmfFilterTreeNode)this.fTable.getData("$fltr_obj");
            if (eventFilter != null) {
                --startIndex;
            }
            this.fSearchThread = new SearchThread(searchFilter, eventFilter, startIndex, this.fSelectedRank, -1);
            this.fSearchThread.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSearchThread() {
        this.fPendingGotoRank = -1L;
        Object object = this.fSearchSyncObj;
        synchronized (object) {
            if (this.fSearchThread != null) {
                this.fSearchThread.cancel();
                this.fSearchThread = null;
            }
        }
    }

    private void createResources() {
        this.fGrayColor = this.fResourceManager.createColor(ColorUtil.blend((RGB)this.fTable.getBackground().getRGB(), (RGB)this.fTable.getForeground().getRGB()));
        this.fGreenColor = PlatformUI.getWorkbench().getDisplay().getSystemColor(6);
    }

    private void initializeFonts() {
        FontRegistry fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        this.fFont = fontRegistry.get(FONT_DEFINITION_ID);
        this.fBoldFont = fontRegistry.getBold(FONT_DEFINITION_ID);
        this.fTable.setFont(this.fFont);
    }

    private void initializeColors() {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.fHighlightColor = colorRegistry.get(HIGHLIGHT_COLOR_DEFINITION_ID);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("CHANGE_CURRENT_THEME".equals(event.getProperty()) || FONT_DEFINITION_ID.equals(event.getProperty())) {
            this.initializeFonts();
            this.fTable.refresh();
        }
        if ("CHANGE_CURRENT_THEME".equals(event.getProperty()) || HIGHLIGHT_COLOR_DEFINITION_ID.equals(event.getProperty())) {
            this.initializeColors();
            this.fTable.refresh();
        }
    }

    protected void packColumns() {
        if (this.fPackDone) {
            return;
        }
        this.fTable.setRedraw(false);
        try {
            TableColumn[] tableColumns = this.fTable.getColumns();
            int i = 0;
            while (i < tableColumns.length) {
                TableColumn column = tableColumns[i];
                this.packSingleColumn(i, column);
                ++i;
            }
        }
        finally {
            this.fTable.setRedraw(true);
        }
        this.fPackDone = true;
    }

    private void packMarginColumn() {
        TableColumn[] columns = this.fTable.getColumns();
        if (columns.length > 0) {
            this.packSingleColumn(0, columns[0]);
        }
    }

    private void packSingleColumn(int i, TableColumn column) {
        int headerWidth = column.getWidth();
        column.pack();
        boolean isCollapseFilter = this.fTable.getData("$fltr_obj") instanceof TmfCollapseFilter;
        if (IS_LINUX && i == 0 && isCollapseFilter) {
            column.setWidth(column.getWidth() + TmfEventsTable.SEARCH_IMAGE.getBounds().width);
        }
        if (column.getWidth() < headerWidth) {
            column.setWidth(headerWidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getItemStrings(List<TmfEventTableColumn> columns, ITmfEvent event) {
        if (event == null) {
            return EMPTY_STRING_ARRAY;
        }
        List<TmfEventTableColumn> list = columns;
        synchronized (list) {
            ArrayList<String> itemStrings = new ArrayList<String>(columns.size());
            for (TmfEventTableColumn column : columns) {
                ITmfEvent passedEvent = event;
                if (!(column instanceof TmfMarginColumn) && event instanceof TmfEventsCache.CachedEvent) {
                    passedEvent = ((TmfEventsCache.CachedEvent)event).event;
                }
                if (passedEvent == null) {
                    itemStrings.add(EMPTY_STRING);
                    continue;
                }
                itemStrings.add(column.getItemString(passedEvent));
            }
            return itemStrings.toArray(new String[0]);
        }
    }

    public String[] getItemStrings(ITmfEvent event) {
        ArrayList<TmfEventTableColumn> columns = new ArrayList<TmfEventTableColumn>();
        int[] nArray = this.fTable.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            columns.add(this.fColumns.get(i));
            ++n2;
        }
        return TmfEventsTable.getItemStrings(columns, event);
    }

    public int[] getColumnOrder() {
        return this.fColumnOrder;
    }

    public void setColumnOrder(int[] order) {
        if (order == null || order.length != this.fTable.getColumns().length) {
            return;
        }
        this.fTable.setColumnOrder(order);
        this.fColumnOrder = this.fTable.getColumnOrder();
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void registerContextMenus(IWorkbenchPartSite site) {
        if (site instanceof IEditorSite) {
            IEditorSite editorSite = (IEditorSite)site;
            editorSite.registerContextMenu(this.fTablePopupMenuManager, (ISelectionProvider)this, false);
        }
    }

    public void setTrace(final ITmfTrace trace, boolean disposeOnClose) {
        if (this.fTrace != null && this.fDisposeOnClose) {
            this.fTrace.dispose();
        }
        this.fTrace = trace;
        this.fPackDone = false;
        this.fDisposeOnClose = disposeOnClose;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfEventsTable.this.fSelectedRank = -1L;
                TmfEventsTable.this.fSelectedBeginRank = -1L;
                TmfEventsTable.this.fTable.removeAll();
                TmfEventsTable.this.fCache.setTrace(trace);
                if (trace != null && !TmfEventsTable.this.fTable.isDisposed()) {
                    if (TmfEventsTable.this.fTable.getData("$fltr_obj") == null) {
                        TmfEventsTable.this.fTable.setItemCount((int)trace.getNbEvents() + 1);
                    } else {
                        TmfEventsTable.this.stopFilterThread();
                        TmfEventsTable.this.fFilterMatchCount = 0L;
                        TmfEventsTable.this.fFilterCheckCount = 0L;
                        TmfEventsTable.this.fTable.setItemCount(3);
                        TmfEventsTable.this.startFilterThread();
                    }
                }
                TmfEventsTable.this.fRawViewer.setTrace(trace);
            }
        });
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        if (this.fStatusLineManager != null && statusLineManager == null) {
            this.fStatusLineManager.setMessage(EMPTY_STRING);
        }
        this.fStatusLineManager = statusLineManager;
    }

    private void updateStatusLine(ITmfTimestamp delta) {
        if (this.fStatusLineManager != null) {
            if (delta != null) {
                this.fStatusLineManager.setMessage("\u0394: " + delta);
            } else {
                this.fStatusLineManager.setMessage(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheUpdated(final boolean completed) {
        Object object = this.fCacheUpdateSyncObj;
        synchronized (object) {
            if (this.fCacheUpdateBusy) {
                this.fCacheUpdatePending = true;
                this.fCacheUpdateCompleted = completed;
                return;
            }
            this.fCacheUpdateBusy = true;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!TmfEventsTable.this.fTable.isDisposed()) {
                    TmfEventsTable.this.fTable.refresh();
                    TmfEventsTable.this.packColumns();
                }
                if (completed) {
                    TmfEventsTable.this.populateCompleted();
                }
                Object object = TmfEventsTable.this.fCacheUpdateSyncObj;
                synchronized (object) {
                    TmfEventsTable.this.fCacheUpdateBusy = false;
                    if (TmfEventsTable.this.fCacheUpdatePending) {
                        TmfEventsTable.this.fCacheUpdatePending = false;
                        TmfEventsTable.this.cacheUpdated(TmfEventsTable.this.fCacheUpdateCompleted);
                    }
                }
            }
        });
    }

    protected void populateCompleted() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.fTable == null || this.fTable.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        ArrayList<Object> list = new ArrayList<Object>(this.fTable.getSelection().length);
        TableItem[] tableItemArray = this.fTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() != null) {
                list.add(item.getData());
            }
            ++n2;
        }
        return new StructuredSelection(list);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void addBookmark(IFile bookmarksFile) {
        TableItem tableItem;
        this.fBookmarksFile = bookmarksFile;
        TableItem[] selection = this.fTable.getSelection();
        if (selection.length > 0 && (tableItem = selection[0]).getData("$rank") != null) {
            StringBuffer defaultMessage = new StringBuffer();
            int i = 0;
            while (i < this.fTable.getColumns().length) {
                if (i > 0) {
                    defaultMessage.append(", ");
                }
                defaultMessage.append(tableItem.getText(i));
                ++i;
            }
            MultiLineInputDialog dialog = new MultiLineInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.TmfEventsTable_AddBookmarkDialogTitle, Messages.TmfEventsTable_AddBookmarkDialogMessage, defaultMessage.toString());
            if (dialog.open() == 0) {
                String message = dialog.getValue();
                try {
                    IMarker bookmark = bookmarksFile.createMarker("org.eclipse.core.resources.bookmark");
                    if (bookmark.exists()) {
                        bookmark.setAttribute("message", (Object)message.toString());
                        Long rank = (Long)tableItem.getData("$rank");
                        int location = rank.intValue();
                        bookmark.setAttribute("location", (Object)location);
                        this.fBookmarksMap.put((Object)rank, (Object)bookmark.getId());
                        this.fTable.refresh();
                    }
                }
                catch (CoreException e) {
                    TmfEventsTable.displayException((Exception)((Object)e));
                }
            }
        }
    }

    public void removeBookmark(IMarker bookmark) {
        for (Map.Entry entry : this.fBookmarksMap.entries()) {
            if (!((Long)entry.getValue()).equals(bookmark.getId())) continue;
            this.fBookmarksMap.remove(entry.getKey(), entry.getValue());
            this.fTable.refresh();
            return;
        }
    }

    private void toggleBookmark(Long rank) {
        if (this.fBookmarksFile == null) {
            return;
        }
        if (this.fBookmarksMap.containsKey((Object)rank)) {
            Collection markerIds = this.fBookmarksMap.removeAll((Object)rank);
            this.fTable.refresh();
            try {
                Iterator iterator = markerIds.iterator();
                while (iterator.hasNext()) {
                    long markerId = (Long)iterator.next();
                    IMarker bookmark = this.fBookmarksFile.findMarker(markerId);
                    if (bookmark == null) continue;
                    bookmark.delete();
                }
            }
            catch (CoreException e) {
                TmfEventsTable.displayException((Exception)((Object)e));
            }
        } else {
            this.addBookmark(this.fBookmarksFile);
        }
    }

    public void refreshBookmarks(IFile bookmarksFile) {
        this.fBookmarksFile = bookmarksFile;
        if (bookmarksFile == null) {
            this.fBookmarksMap.clear();
            this.fTable.refresh();
            return;
        }
        try {
            this.fBookmarksMap.clear();
            IMarker[] iMarkerArray = bookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker bookmark = iMarkerArray[n2];
                int location = bookmark.getAttribute("location", -1);
                if (location != -1) {
                    long rank = location;
                    this.fBookmarksMap.put((Object)rank, (Object)bookmark.getId());
                }
                ++n2;
            }
            this.fTable.refresh();
        }
        catch (CoreException e) {
            TmfEventsTable.displayException((Exception)((Object)e));
        }
    }

    public void gotoMarker(IMarker marker) {
        int rank = marker.getAttribute("location", -1);
        if (rank != -1) {
            int index = rank;
            if (this.fTable.getData("$fltr_obj") != null) {
                index = this.fCache.getFilteredEventIndex(rank) + 1;
            } else if (rank >= this.fTable.getItemCount()) {
                this.fPendingGotoRank = rank;
            }
            this.fSelectedBeginRank = this.fSelectedRank = (long)rank;
            this.fTable.setSelection(index + 1);
            this.updateStatusLine(null);
        }
    }

    @Override
    public void colorSettingsChanged(ColorSetting[] colorSettings) {
        this.fTable.refresh();
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace || this.fTable.isDisposed()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TmfEventsTable.this.fTable.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    if (TmfEventsTable.this.fTable.getData("$fltr_obj") == null) {
                        TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fTrace.getNbEvents() + 1);
                        if (TmfEventsTable.this.fPendingGotoRank != -1L && TmfEventsTable.this.fPendingGotoRank + 1L < (long)TmfEventsTable.this.fTable.getItemCount()) {
                            TmfEventsTable.this.fTable.setSelection((int)TmfEventsTable.this.fPendingGotoRank + 1);
                            TmfEventsTable.this.fPendingGotoRank = -1L;
                            TmfEventsTable.this.updateStatusLine(null);
                        }
                    } else {
                        TmfEventsTable.this.startFilterThread();
                    }
                }
                if (!TmfEventsTable.this.fRawViewer.isDisposed() && TmfEventsTable.this.fTrace != null) {
                    TmfEventsTable.this.fRawViewer.refreshEventCount();
                }
            }
        });
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        if (signal.getSource() != this && this.fTrace != null && !this.fTable.isDisposed()) {
            TmfEventRequest subRequest = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, 0L, 1, ITmfEventRequest.ExecutionType.FOREGROUND, signal){
                TmfTimestamp ts;
                {
                    this.ts = new TmfTimestamp(tmfSelectionRangeUpdatedSignal.getBeginTime());
                }

                public void handleData(ITmfEvent event) {
                    super.handleData(event);
                }

                public void handleSuccess() {
                    super.handleSuccess();
                    if (TmfEventsTable.this.fTrace == null) {
                        return;
                    }
                    TmfTimestamp timestamp = this.ts;
                    if (timestamp.compareTo(TmfEventsTable.this.fTrace.getStartTime()) == -1) {
                        timestamp = TmfEventsTable.this.fTrace.getStartTime();
                    }
                    if (timestamp.compareTo(TmfEventsTable.this.fTrace.getEndTime()) == 1) {
                        timestamp = TmfEventsTable.this.fTrace.getEndTime();
                    }
                    ITmfContext context = TmfEventsTable.this.fTrace.seekEvent((ITmfTimestamp)timestamp);
                    final long rank = context.getRank();
                    context.dispose();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TmfEventsTable.this.fTable.isDisposed()) {
                                return;
                            }
                            TmfEventsTable.this.fSelectedRank = rank;
                            TmfEventsTable.this.fSelectedBeginRank = TmfEventsTable.this.fSelectedRank;
                            int index = (int)rank;
                            if ((this).TmfEventsTable.this.fTable.getData("$fltr_obj") != null) {
                                index = TmfEventsTable.this.fCache.getFilteredEventIndex(rank) + 1;
                            }
                            (this).TmfEventsTable.this.fTable.setSelection(index + 1);
                            TmfEventsTable.this.fRawViewer.selectAndReveal(rank);
                            TmfEventsTable.this.updateStatusLine(null);
                        }
                    });
                }
            };
            this.fTrace.sendRequest((ITmfEventRequest)subRequest);
        }
    }

    private static void displayException(Exception e) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(e.getClass().getSimpleName());
        mb.setMessage(e.getMessage());
        mb.open();
    }

    public void refresh() {
        this.fCache.clear();
        this.fTable.refresh();
        this.fTable.redraw();
    }

    static interface Direction {
        public static final int FORWARD = 1;
        public static final int BACKWARD = -1;
    }

    protected class FilterThread
    extends Thread {
        private final ITmfFilterTreeNode filter;
        private TmfEventRequest request;
        private boolean refreshBusy;
        private boolean refreshPending;
        private final Object syncObj;

        public FilterThread(ITmfFilterTreeNode filter) {
            super("Filter Thread");
            this.refreshBusy = false;
            this.refreshPending = false;
            this.syncObj = new Object();
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TmfEventsTable.this.fTrace == null) {
                return;
            }
            int nbRequested = (int)(TmfEventsTable.this.fTrace.getNbEvents() - TmfEventsTable.this.fFilterCheckCount);
            if (nbRequested <= 0) {
                return;
            }
            this.request = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, (int)TmfEventsTable.this.fFilterCheckCount, nbRequested, ITmfEventRequest.ExecutionType.BACKGROUND){

                public void handleData(ITmfEvent event) {
                    super.handleData(event);
                    if (FilterThread.this.request.isCancelled()) {
                        return;
                    }
                    boolean refresh = false;
                    if (FilterThread.this.filter.matches(event)) {
                        long rank = TmfEventsTable.this.fFilterCheckCount;
                        int index = (int)TmfEventsTable.this.fFilterMatchCount;
                        TmfEventsTable tmfEventsTable = TmfEventsTable.this;
                        tmfEventsTable.fFilterMatchCount = tmfEventsTable.fFilterMatchCount + 1L;
                        TmfEventsTable.this.fCache.storeEvent(event, rank, index);
                        refresh = true;
                    } else if (FilterThread.this.filter instanceof TmfCollapseFilter) {
                        TmfEventsTable.this.fCache.updateCollapsedEvent((int)TmfEventsTable.this.fFilterMatchCount - 1);
                    }
                    if (refresh || TmfEventsTable.this.fFilterCheckCount % 100L == 0L) {
                        FilterThread.this.refreshTable();
                    }
                    TmfEventsTable tmfEventsTable = TmfEventsTable.this;
                    tmfEventsTable.fFilterCheckCount = tmfEventsTable.fFilterCheckCount + 1L;
                }
            };
            TmfEventsTable.this.fTrace.sendRequest((ITmfEventRequest)this.request);
            try {
                this.request.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.refreshTable();
            Object object = TmfEventsTable.this.fFilterSyncObj;
            synchronized (object) {
                TmfEventsTable.this.fFilterThread = null;
                if (TmfEventsTable.this.fFilterThreadResume) {
                    TmfEventsTable.this.fFilterThreadResume = false;
                    TmfEventsTable.this.fFilterThread = new FilterThread(this.filter);
                    TmfEventsTable.this.fFilterThread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshTable() {
            Object object = this.syncObj;
            synchronized (object) {
                if (this.refreshBusy) {
                    this.refreshPending = true;
                    return;
                }
                this.refreshBusy = true;
            }
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (FilterThread.this.request.isCancelled()) {
                        return;
                    }
                    if (((FilterThread)FilterThread.this).TmfEventsTable.this.fTable.isDisposed()) {
                        return;
                    }
                    ((FilterThread)FilterThread.this).TmfEventsTable.this.fTable.setItemCount((int)TmfEventsTable.this.fFilterMatchCount + 3);
                    ((FilterThread)FilterThread.this).TmfEventsTable.this.fTable.refresh();
                    Object object = FilterThread.this.syncObj;
                    synchronized (object) {
                        FilterThread.this.refreshBusy = false;
                        if (FilterThread.this.refreshPending) {
                            FilterThread.this.refreshPending = false;
                            FilterThread.this.refreshTable();
                        }
                    }
                }
            });
        }

        public void cancel() {
            if (this.request != null) {
                this.request.cancel();
            }
        }
    }

    public static enum HeaderState {
        SEARCH,
        FILTER;

    }

    public static interface Key {
        public static final String SEARCH_TXT = "$srch_txt";
        public static final String SEARCH_OBJ = "$srch_obj";
        public static final String FILTER_TXT = "$fltr_txt";
        public static final String FILTER_OBJ = "$fltr_obj";
        public static final String TIMESTAMP = "$time";
        public static final String RANK = "$rank";
        public static final String BOOKMARK = "$bookmark";
        public static final String ASPECT = "$aspect";
        public static final String STYLE_RANGES = "$style_ranges";
        public static final String WIDTH = "$width";
    }

    protected class SearchThread
    extends Job {
        private ITmfFilterTreeNode searchFilter;
        private ITmfFilterTreeNode eventFilter;
        private int startIndex;
        private int direction;
        private long rank;
        private long foundRank;
        private TmfEventRequest request;
        private ITmfTimestamp foundTimestamp;

        public SearchThread(ITmfFilterTreeNode searchFilter, ITmfFilterTreeNode eventFilter, int startIndex, long currentRank, int direction) {
            super(Messages.TmfEventsTable_SearchingJobName);
            this.foundRank = -1L;
            this.foundTimestamp = null;
            this.searchFilter = searchFilter;
            this.eventFilter = eventFilter;
            this.startIndex = startIndex;
            this.rank = currentRank;
            this.direction = direction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(final IProgressMonitor monitor) {
            ITmfTrace trace = TmfEventsTable.this.fTrace;
            if (trace == null) {
                return Status.OK_STATUS;
            }
            Display display = Display.getDefault();
            if (this.startIndex < 0) {
                this.rank = (int)trace.getNbEvents() - 1;
            } else if (this.startIndex >= TmfEventsTable.this.fTable.getItemCount() - (this.eventFilter == null ? 1 : 3)) {
                this.rank = 0L;
            } else {
                int idx = this.startIndex;
                while (this.foundRank == -1L) {
                    TmfEventsCache.CachedEvent event = TmfEventsTable.this.fCache.peekEvent(idx);
                    if (event == null) break;
                    this.rank = event.rank;
                    if (this.searchFilter.matches(event.event) && (this.eventFilter == null || this.eventFilter.matches(event.event))) {
                        this.foundRank = event.rank;
                        this.foundTimestamp = event.event.getTimestamp();
                        break;
                    }
                    if (this.direction == 1) {
                        ++idx;
                        continue;
                    }
                    --idx;
                }
                if (this.foundRank == -1L) {
                    if (this.direction == 1) {
                        ++this.rank;
                        if (this.rank > trace.getNbEvents() - 1L) {
                            this.rank = 0L;
                        }
                    } else {
                        --this.rank;
                        if (this.rank < 0L) {
                            this.rank = (int)trace.getNbEvents() - 1;
                        }
                    }
                }
            }
            int startRank = (int)this.rank;
            boolean wrapped = false;
            while (!monitor.isCanceled() && this.foundRank == -1L) {
                int nbRequested;
                int n = nbRequested = this.direction == 1 ? Integer.MAX_VALUE : Math.min((int)this.rank + 1, trace.getCacheSize());
                if (this.direction == -1) {
                    this.rank = Math.max(0L, this.rank - (long)trace.getCacheSize() + 1L);
                }
                this.request = new TmfEventRequest(ITmfEvent.class, TmfTimeRange.ETERNITY, (int)this.rank, nbRequested, ITmfEventRequest.ExecutionType.BACKGROUND){
                    long currentRank;
                    {
                        this.currentRank = SearchThread.this.rank;
                    }

                    public void handleData(ITmfEvent event) {
                        super.handleData(event);
                        if (SearchThread.this.searchFilter.matches(event) && (SearchThread.this.eventFilter == null || SearchThread.this.eventFilter.matches(event))) {
                            SearchThread.this.foundRank = this.currentRank;
                            SearchThread.this.foundTimestamp = event.getTimestamp();
                            if (SearchThread.this.direction == 1) {
                                this.done();
                                return;
                            }
                        }
                        ++this.currentRank;
                    }
                };
                trace.sendRequest((ITmfEventRequest)this.request);
                try {
                    this.request.waitForCompletion();
                    if (this.request.isCancelled()) {
                        return Status.OK_STATUS;
                    }
                }
                catch (InterruptedException e) {
                    Object object = TmfEventsTable.this.fSearchSyncObj;
                    synchronized (object) {
                        TmfEventsTable.this.fSearchThread = null;
                    }
                    return Status.OK_STATUS;
                }
                if (this.foundRank != -1L) continue;
                if (this.direction == 1) {
                    if (this.rank == 0L) {
                        Object e = TmfEventsTable.this.fSearchSyncObj;
                        synchronized (e) {
                            TmfEventsTable.this.fSearchThread = null;
                        }
                        return Status.OK_STATUS;
                    }
                    nbRequested = (int)this.rank;
                    this.rank = 0L;
                    wrapped = true;
                    continue;
                }
                --this.rank;
                if (this.rank < 0L) {
                    this.rank = (int)trace.getNbEvents() - 1;
                    wrapped = true;
                }
                if (this.rank > (long)startRank || !wrapped) continue;
                Object e = TmfEventsTable.this.fSearchSyncObj;
                synchronized (e) {
                    TmfEventsTable.this.fSearchThread = null;
                }
                return Status.OK_STATUS;
            }
            int index = (int)this.foundRank;
            if (this.eventFilter != null) {
                index = TmfEventsTable.this.fCache.getFilteredEventIndex(this.foundRank);
            }
            final int selection = index + 1 + (this.eventFilter != null ? 1 : 0);
            display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (((SearchThread)SearchThread.this).TmfEventsTable.this.fTable.isDisposed()) {
                        return;
                    }
                    ((SearchThread)SearchThread.this).TmfEventsTable.this.fTable.setSelection(selection);
                    TmfEventsTable.this.fSelectedRank = SearchThread.this.foundRank;
                    TmfEventsTable.this.fSelectedBeginRank = TmfEventsTable.this.fSelectedRank;
                    TmfEventsTable.this.fRawViewer.selectAndReveal(TmfEventsTable.this.fSelectedRank);
                    if (SearchThread.this.foundTimestamp != null) {
                        TmfEventsTable.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)TmfEventsTable.this, SearchThread.this.foundTimestamp));
                    }
                    TmfEventsTable.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)TmfEventsTable.this, TmfEventsTable.this.getSelection()));
                    Object object = TmfEventsTable.this.fSearchSyncObj;
                    synchronized (object) {
                        TmfEventsTable.this.fSearchThread = null;
                    }
                    TmfEventsTable.this.updateStatusLine(null);
                }
            });
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            this.request.cancel();
            Object object = TmfEventsTable.this.fSearchSyncObj;
            synchronized (object) {
                TmfEventsTable.this.fSearchThread = null;
            }
        }
    }

    private static final class TmfMarginColumn
    extends TmfEventTableColumn {
        @NonNull
        private static final ITmfEventAspect MARGIN_ASPECT = new ITmfEventAspect(){

            public String getName() {
                return TmfEventsTable.EMPTY_STRING;
            }

            public String resolve(ITmfEvent event) {
                if (!(event instanceof TmfEventsCache.CachedEvent) || ((TmfEventsCache.CachedEvent)event).repeatCount == 0L) {
                    return TmfEventsTable.EMPTY_STRING;
                }
                return "+" + ((TmfEventsCache.CachedEvent)event).repeatCount;
            }

            public String getHelpText() {
                return TmfEventsTable.EMPTY_STRING;
            }
        };

        public TmfMarginColumn() {
            super(MARGIN_ASPECT);
        }
    }
}

